/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.menu;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.MachineWoodBurnerBlockEntity;
import com.hbm_m.item.ModItems;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.menu.ModMenuTypes;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class MachineWoodBurnerMenu
extends AbstractContainerMenu {
    private final MachineWoodBurnerBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 2;

    public MachineWoodBurnerMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(6));
    }

    public MachineWoodBurnerMenu(int pContainerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.WOOD_BURNER_MENU.get(), pContainerId);
        MachineWoodBurnerMenu.m_38869_((Container)inv, (int)2);
        this.blockEntity = (MachineWoodBurnerBlockEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 0, 26, 18){

                public boolean m_5857_(@NotNull ItemStack stack) {
                    return MachineWoodBurnerMenu.this.isFuel(stack);
                }
            });
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, 1, 26, 54){

                public boolean m_5857_(@NotNull ItemStack stack) {
                    return false;
                }
            });
        });
        this.m_38884_(data);
    }

    private boolean isFuel(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item == Items.f_42448_) {
            return false;
        }
        if (item == ModItems.LIGNITE.get()) {
            return true;
        }
        return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
    }

    public int getEnergy() {
        return this.data.m_6413_(0);
    }

    public int getMaxEnergy() {
        return this.data.m_6413_(1);
    }

    public int getBurnTime() {
        return this.data.m_6413_(2);
    }

    public int getMaxBurnTime() {
        return this.data.m_6413_(3);
    }

    public boolean isLit() {
        return this.data.m_6413_(4) != 0;
    }

    public void toggleEnabled() {
        this.data.m_8050_(5, -1);
    }

    public boolean isEnabled() {
        return this.data.m_6413_(5) != 0;
    }

    public int getBurnTimeScaled(int scale) {
        int maxBurnTime = this.data.m_6413_(3);
        int burnTime = this.data.m_6413_(2);
        return maxBurnTime != 0 ? burnTime * scale / maxBurnTime : 0;
    }

    public int getEnergyScaled(int scale) {
        int energy = this.data.m_6413_(0);
        int maxEnergy = this.data.m_6413_(1);
        return maxEnergy != 0 ? energy * scale / maxEnergy : 0;
    }

    @NotNull
    public ItemStack m_7648_(@Nonnull Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (pIndex < 36) {
            boolean moved = false;
            if (this.isFuel(sourceStack)) {
                moved = this.m_38903_(sourceStack, 36, 37, false);
            }
            if (!moved) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex < 38) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            MainRegistry.LOGGER.debug("Invalid slotIndex:" + pIndex);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(@Nonnull Player pPlayer) {
        return MachineWoodBurnerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)ModBlocks.WOOD_BURNER.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 104 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 162));
        }
    }

    public MachineWoodBurnerBlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

