/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.module.machine;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public abstract class MachineModuleBase<T extends Recipe<?>> {
    protected final int moduleIndex;
    protected final IEnergyStorage energyStorage;
    protected final IItemHandler itemHandler;
    protected final Level level;
    protected int[] inputSlots;
    protected int[] outputSlots;
    protected double progress = 0.0;
    protected int maxProgress = 100;
    @Nullable
    protected T currentRecipe = null;
    public boolean didProcess = false;
    public boolean needsSync = false;

    public MachineModuleBase(int moduleIndex, IEnergyStorage energyStorage, IItemHandler itemHandler, Level level) {
        this.moduleIndex = moduleIndex;
        this.energyStorage = energyStorage;
        this.itemHandler = itemHandler;
        this.level = level;
    }

    protected abstract RecipeType<T> getRecipeType();

    @Nullable
    protected abstract T findRecipeForInputs();

    protected abstract boolean canProcess(@Nullable T var1);

    protected abstract void processCraft(T var1);

    protected abstract boolean matchesCurrentRecipe(T var1);

    protected abstract int getRecipeDuration(T var1);

    protected abstract int getRecipeEnergyCost(T var1);

    @Nullable
    protected abstract T findRecipeForItem(ItemStack var1);

    public void update(double speedMultiplier, double powerMultiplier, boolean extraCondition) {
        this.didProcess = false;
        this.needsSync = false;
        if (this.currentRecipe == null || !this.matchesCurrentRecipe(this.currentRecipe)) {
            this.currentRecipe = this.findRecipeForInputs();
            if (this.currentRecipe != null) {
                this.maxProgress = this.getRecipeDuration(this.currentRecipe);
                this.progress = 0.0;
                this.needsSync = true;
            }
        }
        if (extraCondition && this.currentRecipe != null && this.canProcess(this.currentRecipe)) {
            int energyPerTick = (int)((double)this.getRecipeEnergyCost(this.currentRecipe) * powerMultiplier);
            long totalEnergyRequired = (long)energyPerTick * (long)this.maxProgress;
            if (this.progress == 0.0 && (long)this.energyStorage.getEnergyStored() < totalEnergyRequired) {
                return;
            }
            if (this.energyStorage.getEnergyStored() >= energyPerTick) {
                this.energyStorage.extractEnergy(energyPerTick, false);
                double step = Math.min(speedMultiplier, 1.0);
                this.progress += step;
                this.didProcess = true;
                if (this.progress >= (double)this.maxProgress) {
                    this.processCraft(this.currentRecipe);
                    this.needsSync = true;
                    if (this.canProcess(this.currentRecipe)) {
                        this.progress -= (double)this.maxProgress;
                    } else {
                        this.progress = 0.0;
                        this.currentRecipe = null;
                    }
                }
            } else if (this.progress > 0.0) {
                this.progress = 0.0;
                this.needsSync = true;
            }
        } else if (this.progress > 0.0) {
            this.progress = 0.0;
            this.needsSync = true;
        }
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        for (int inputSlot : this.inputSlots) {
            if (inputSlot != slot) continue;
            T recipe = this.findRecipeForItem(stack);
            return recipe != null;
        }
        return false;
    }

    public boolean isSlotClogged(int slot) {
        for (int inputSlot : this.inputSlots) {
            ItemStack stack;
            if (inputSlot != slot || (stack = this.itemHandler.getStackInSlot(slot)).m_41619_()) continue;
            return !this.isItemValidForSlot(slot, stack);
        }
        return false;
    }

    public void resetProgress() {
        this.progress = 0.0;
        this.currentRecipe = null;
        this.didProcess = false;
        this.needsSync = true;
    }

    public double getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public int getProgressInt() {
        return (int)this.progress;
    }

    public double getProgressPercent() {
        return this.maxProgress > 0 ? this.progress / (double)this.maxProgress : 0.0;
    }

    @Nullable
    public T getCurrentRecipe() {
        return this.currentRecipe;
    }

    public boolean isProcessing() {
        return this.didProcess;
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.m_128347_("Progress_" + this.moduleIndex, this.progress);
        nbt.m_128405_("MaxProgress_" + this.moduleIndex, this.maxProgress);
    }

    public void readFromNBT(CompoundTag nbt) {
        this.progress = nbt.m_128459_("Progress_" + this.moduleIndex);
        this.maxProgress = nbt.m_128451_("MaxProgress_" + this.moduleIndex);
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.writeDouble(this.progress);
        buf.writeInt(this.maxProgress);
    }

    public void deserialize(FriendlyByteBuf buf) {
        this.progress = buf.readDouble();
        this.maxProgress = buf.readInt();
    }

    protected abstract boolean isRecipeValidForBlueprint(T var1, ItemStack var2);

    public void update(double speedMultiplier, double powerMultiplier, boolean extraCondition, ItemStack blueprint) {
        this.didProcess = false;
        this.needsSync = false;
        if (this.currentRecipe == null || !this.matchesCurrentRecipe(this.currentRecipe)) {
            this.currentRecipe = this.findRecipeForInputs();
            if (this.currentRecipe != null) {
                this.maxProgress = this.getRecipeDuration(this.currentRecipe);
                this.progress = 0.0;
                this.needsSync = true;
            }
        }
        if (this.currentRecipe != null && !this.isRecipeValidForBlueprint(this.currentRecipe, blueprint)) {
            this.didProcess = false;
            this.progress = 0.0;
            this.currentRecipe = null;
            this.needsSync = true;
            return;
        }
        if (extraCondition && this.currentRecipe != null && this.canProcess(this.currentRecipe)) {
            int energyPerTick = (int)((double)this.getRecipeEnergyCost(this.currentRecipe) * powerMultiplier);
            long totalEnergyRequired = (long)energyPerTick * (long)this.maxProgress;
            if (this.progress == 0.0 && (long)this.energyStorage.getEnergyStored() < totalEnergyRequired) {
                return;
            }
            if (this.energyStorage.getEnergyStored() >= energyPerTick) {
                this.energyStorage.extractEnergy(energyPerTick, false);
                double step = Math.min(speedMultiplier, 1.0);
                this.progress += step;
                this.didProcess = true;
                if (this.progress >= (double)this.maxProgress) {
                    this.processCraft(this.currentRecipe);
                    this.needsSync = true;
                    if (this.canProcess(this.currentRecipe)) {
                        this.progress -= (double)this.maxProgress;
                    } else {
                        this.progress = 0.0;
                        this.currentRecipe = null;
                    }
                }
            } else if (this.progress > 0.0) {
                this.progress = 0.0;
                this.needsSync = true;
            }
        } else if (this.progress > 0.0) {
            this.progress = 0.0;
            this.needsSync = true;
        }
    }
}

