/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.network;

import com.hbm_m.client.overlay.OverlayGeiger;
import com.hbm_m.main.MainRegistry;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class RadiationDataPacket {
    private final float totalEnvironmentRad;
    private final float playerRad;
    private static float lastEnvRad = -1.0f;
    private static float lastPlayerRad = -1.0f;

    public RadiationDataPacket(float totalEnvironmentRad, float playerRad) {
        this.totalEnvironmentRad = totalEnvironmentRad;
        this.playerRad = playerRad;
    }

    public static void encode(RadiationDataPacket msg, FriendlyByteBuf buf) {
        buf.writeFloat(msg.totalEnvironmentRad);
        buf.writeFloat(msg.playerRad);
    }

    public static RadiationDataPacket decode(FriendlyByteBuf buf) {
        float envRad = buf.readFloat();
        float pRad = buf.readFloat();
        return new RadiationDataPacket(envRad, pRad);
    }

    public static void handle(RadiationDataPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            OverlayGeiger.clientTotalEnvironmentRadiation = msg.totalEnvironmentRad;
            OverlayGeiger.clientPlayerRadiation = msg.playerRad;
            if (msg.totalEnvironmentRad != lastEnvRad || msg.playerRad != lastPlayerRad) {
                MainRegistry.LOGGER.debug("CLIENT: Received RadiationDataPacket. EnvRad: {}, PlayerRad: {}", (Object)Float.valueOf(msg.totalEnvironmentRad), (Object)Float.valueOf(msg.playerRad));
                lastEnvRad = msg.totalEnvironmentRad;
                lastPlayerRad = msg.playerRad;
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

