/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.network;

import com.hbm_m.block.entity.MachineWoodBurnerBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ToggleWoodBurnerPacket {
    private final BlockPos pos;

    public ToggleWoodBurnerPacket(BlockPos pos) {
        this.pos = pos;
    }

    public ToggleWoodBurnerPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
    }

    public static void encode(ToggleWoodBurnerPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
    }

    public static ToggleWoodBurnerPacket decode(FriendlyByteBuf buf) {
        return new ToggleWoodBurnerPacket(buf);
    }

    public static void handle(ToggleWoodBurnerPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            BlockEntity blockEntity = level.m_7702_(msg.pos);
            if (blockEntity instanceof MachineWoodBurnerBlockEntity) {
                MachineWoodBurnerBlockEntity woodBurner;
                boolean currentState = (woodBurner = (MachineWoodBurnerBlockEntity)blockEntity).isEnabled();
                woodBurner.setEnabled(!currentState);
                woodBurner.m_6596_();
            }
        });
        context.setPacketHandled(true);
    }
}

