/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.network.sounds;

import com.hbm_m.config.ModClothConfig;
import com.hbm_m.main.MainRegistry;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class GeigerSoundPacket {
    private final ResourceLocation soundLocation;
    private final float volume;
    private final float pitch;

    public GeigerSoundPacket(ResourceLocation soundLocation, float volume, float pitch) {
        this.soundLocation = soundLocation;
        this.volume = volume;
        this.pitch = pitch;
    }

    public static void encode(GeigerSoundPacket msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.soundLocation);
        buf.writeFloat(msg.volume);
        buf.writeFloat(msg.pitch);
    }

    public static GeigerSoundPacket decode(FriendlyByteBuf buf) {
        return new GeigerSoundPacket(buf.m_130281_(), buf.readFloat(), buf.readFloat());
    }

    public static void handle(GeigerSoundPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(msg.soundLocation);
            Minecraft mc = Minecraft.m_91087_();
            if (sound != null && mc != null && mc.f_91073_ != null && mc.f_91074_ != null) {
                mc.f_91073_.m_7785_(mc.f_91074_.m_20185_(), mc.f_91074_.m_20186_(), mc.f_91074_.m_20189_(), sound, SoundSource.PLAYERS, msg.volume, msg.pitch, false);
                if (ModClothConfig.get().enableDebugLogging) {
                    MainRegistry.LOGGER.debug("GeigerSoundPacket: Sound played successfully.");
                }
            } else if (ModClothConfig.get().enableDebugLogging) {
                MainRegistry.LOGGER.warn("GeigerSoundPacket: Failed to play sound. Sound: {}, MC: {}, Level: {}, Player: {}", (Object)(sound != null ? 1 : 0), (Object)(mc != null ? 1 : 0), (Object)(mc != null ? mc.f_91073_ != null : false), (Object)(mc != null ? mc.f_91074_ != null : false));
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

