/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.radiation;

import com.hbm_m.capability.ChunkRadiationProvider;
import com.hbm_m.config.ModClothConfig;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.radiation.ChunkRadiationHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ChunkRadiationHandlerPRISM
extends ChunkRadiationHandler {
    public ConcurrentHashMap<Level, RadPerWorld> perWorld = new ConcurrentHashMap();
    public static int cycles = 0;
    public static final float MAX_RADIATION = ModClothConfig.get().maxRad;
    private static final String NBT_KEY_CHUNK_RADIATION = "hfr_prism_radiation_";
    private static final String NBT_KEY_CHUNK_RESISTANCE = "hfr_prism_resistance_";
    private static final String NBT_KEY_CHUNK_EXISTS = "hfr_prism_exists_";
    public static final HashMap<ChunkPos, SubChunk[]> newAdditions = new HashMap();

    @Override
    public float getRadiation(Level level, int x, int y, int z) {
        RadPerWorld system = this.perWorld.get(level);
        if (system != null) {
            SubChunk rad;
            ChunkPos coords = new ChunkPos(x >> 4, z >> 4);
            int yReg = Mth.m_14045_((int)(y >> 4), (int)0, (int)15);
            SubChunk[] subChunks = system.radiation.get(coords);
            if (subChunks != null && (rad = subChunks[yReg]) != null) {
                return rad.radiation;
            }
        }
        return 0.0f;
    }

    @Override
    public void recalculateChunkRadiation(LevelChunk chunk) {
    }

    @Override
    public void setRadiation(Level level, int x, int y, int z, float rad) {
        RadPerWorld system;
        if (Float.isNaN(rad)) {
            rad = 0.0f;
        }
        if ((system = this.perWorld.get(level)) != null) {
            ChunkPos coords = new ChunkPos(x >> 4, z >> 4);
            int yReg = Mth.m_14045_((int)(y >> 4), (int)0, (int)15);
            SubChunk[] subChunks = system.radiation.get(coords);
            if (subChunks == null) {
                subChunks = new SubChunk[16];
                system.radiation.put(coords, subChunks);
            }
            if (subChunks[yReg] == null) {
                subChunks[yReg] = new SubChunk().rebuild(level, x, y, z);
            }
            subChunks[yReg].radiation = Mth.m_14036_((float)rad, (float)0.0f, (float)MAX_RADIATION);
            if (level.m_7232_(coords.f_45578_, coords.f_45579_)) {
                LevelChunk chunk = level.m_6325_(coords.f_45578_, coords.f_45579_);
                SubChunk finalSubChunk = subChunks[yReg];
                chunk.getCapability(ChunkRadiationProvider.CHUNK_RADIATION_CAPABILITY).ifPresent(cap -> {
                    cap.setBlockRadiation(finalSubChunk.radiation);
                    chunk.m_8092_(true);
                });
            }
        }
    }

    @Override
    public void incrementRad(Level level, int x, int y, int z, float rad) {
        this.setRadiation(level, x, y, z, this.getRadiation(level, x, y, z) + rad);
    }

    @Override
    public void decrementRad(Level level, int x, int y, int z, float rad) {
        this.setRadiation(level, x, y, z, Math.max(this.getRadiation(level, x, y, z) - rad, 0.0f));
    }

    @Override
    public void incrementBlockRadiation(Level level, BlockPos pos, float diff) {
    }

    @Override
    public void receiveWorldLoad(LevelEvent.Load event) {
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && !(level = (Level)levelAccessor).m_5776_()) {
            this.perWorld.put(level, new RadPerWorld());
        }
    }

    @Override
    public void receiveWorldUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            this.perWorld.remove(level);
        }
    }

    @Override
    public void receiveChunkLoad(ChunkDataEvent.Load event) {
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && !(level = (Level)levelAccessor).m_5776_()) {
            MainRegistry.LOGGER.debug("Loading chunk data for chunk: {}", (Object)event.getChunk().m_7697_());
            RadPerWorld radWorld = this.perWorld.get(level);
            if (radWorld != null) {
                SubChunk[] chunk = new SubChunk[16];
                for (int i = 0; i < 16; ++i) {
                    int j;
                    SubChunk sub;
                    if (!event.getData().m_128471_(NBT_KEY_CHUNK_EXISTS + i)) {
                        chunk[i] = new SubChunk();
                        chunk[i].needsRebuild = true;
                        MainRegistry.LOGGER.debug("  SubChunk {} did not exist, marked for rebuild.", (Object)i);
                        continue;
                    }
                    chunk[i] = sub = new SubChunk();
                    sub.radiation = event.getData().m_128457_(NBT_KEY_CHUNK_RADIATION + i);
                    for (j = 0; j < 16; ++j) {
                        sub.xResist[j] = event.getData().m_128457_("hfr_prism_resistance_x_" + j + "_" + i);
                    }
                    for (j = 0; j < 16; ++j) {
                        sub.yResist[j] = event.getData().m_128457_("hfr_prism_resistance_y_" + j + "_" + i);
                    }
                    for (j = 0; j < 16; ++j) {
                        sub.zResist[j] = event.getData().m_128457_("hfr_prism_resistance_z_" + j + "_" + i);
                    }
                    MainRegistry.LOGGER.debug("  Loaded SubChunk {} with radiation: {}", (Object)i, (Object)Float.valueOf(sub.radiation));
                }
                radWorld.radiation.put(event.getChunk().m_7697_(), chunk);
                MainRegistry.LOGGER.debug("Finished loading chunk data for chunk: {}", (Object)event.getChunk().m_7697_());
            } else {
                MainRegistry.LOGGER.warn("RadPerWorld not found for level {} during chunk load.", (Object)level.m_46472_().m_135782_());
            }
        }
    }

    @Override
    public void receiveChunkLoad(LevelChunk chunk) {
    }

    @Override
    public void receiveChunkSave(ChunkDataEvent.Save event) {
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && !(level = (Level)levelAccessor).m_5776_()) {
            MainRegistry.LOGGER.debug("Saving chunk data for chunk: {}", (Object)event.getChunk().m_7697_());
            RadPerWorld radWorld = this.perWorld.get(level);
            if (radWorld != null) {
                SubChunk[] chunk = radWorld.radiation.get(event.getChunk().m_7697_());
                if (chunk != null) {
                    for (int i = 0; i < 16; ++i) {
                        SubChunk sub = chunk[i];
                        if (sub != null) {
                            int j;
                            float rad = sub.radiation;
                            event.getData().m_128350_(NBT_KEY_CHUNK_RADIATION + i, rad);
                            for (j = 0; j < 16; ++j) {
                                event.getData().m_128350_("hfr_prism_resistance_x_" + j + "_" + i, sub.xResist[j]);
                            }
                            for (j = 0; j < 16; ++j) {
                                event.getData().m_128350_("hfr_prism_resistance_y_" + j + "_" + i, sub.yResist[j]);
                            }
                            for (j = 0; j < 16; ++j) {
                                event.getData().m_128350_("hfr_prism_resistance_z_" + j + "_" + i, sub.zResist[j]);
                            }
                            event.getData().m_128379_(NBT_KEY_CHUNK_EXISTS + i, true);
                            MainRegistry.LOGGER.debug("  Saved SubChunk {} with radiation: {}", (Object)i, (Object)Float.valueOf(sub.radiation));
                            continue;
                        }
                        event.getData().m_128379_(NBT_KEY_CHUNK_EXISTS + i, false);
                        MainRegistry.LOGGER.debug("  SubChunk {} was null, marked as not existing.", (Object)i);
                    }
                } else {
                    MainRegistry.LOGGER.warn("No SubChunk data found for chunk {} during save.", (Object)event.getChunk().m_7697_());
                }
                MainRegistry.LOGGER.debug("Finished saving chunk data for chunk: {}", (Object)event.getChunk().m_7697_());
            } else {
                MainRegistry.LOGGER.warn("RadPerWorld not found for level {} during chunk save.", (Object)level.m_46472_().m_135782_());
            }
        }
    }

    @Override
    public void receiveChunkUnload(ChunkEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            ConcurrentHashMap<ChunkPos, SubChunk[]> map;
            Level level = (Level)levelAccessor;
            ChunkPos pos = event.getChunk().m_7697_();
            ConcurrentHashMap<ChunkPos, SubChunk[]> concurrentHashMap = map = this.perWorld.get(level) != null ? this.perWorld.get((Object)level).radiation : null;
            if (map != null) {
                map.remove(pos);
            }
        }
    }

    @Override
    public void updateSystem() {
        MainRegistry.LOGGER.debug("Updating radiation system. Cycle: {}", (Object)(++cycles));
        for (ServerLevel level : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
            RadPerWorld system = this.perWorld.get(level);
            if (system == null) {
                MainRegistry.LOGGER.warn("RadPerWorld not found for level {} during system update.", (Object)level.m_46472_().m_135782_());
                continue;
            }
            int rebuildAllowance = 25;
            for (Map.Entry<ChunkPos, SubChunk[]> chunkEntry : system.radiation.entrySet()) {
                ChunkPos coord = chunkEntry.getKey();
                SubChunk[] subChunksInChunk = chunkEntry.getValue();
                for (int i = 0; i < 16; ++i) {
                    SubChunk sub = subChunksInChunk[i];
                    boolean hasTriedRebuild = false;
                    if (sub == null) continue;
                    sub.prevRadiation = sub.radiation;
                    sub.radiation = 0.0f;
                    if (rebuildAllowance > 0 && sub.needsRebuild) {
                        MainRegistry.LOGGER.debug("  Rebuilding SubChunk (needsRebuild) at chunk: {}, yReg: {}", (Object)coord, (Object)i);
                        sub.rebuild((Level)level, coord.f_45578_ << 4, i << 4, coord.f_45579_ << 4);
                        if (!sub.needsRebuild) {
                            --rebuildAllowance;
                            hasTriedRebuild = true;
                        }
                    }
                    if (hasTriedRebuild || Math.abs(coord.f_45578_ * coord.f_45579_) % 5 != cycles % 5 || !level.m_7726_().m_5563_(coord.f_45578_, coord.f_45579_)) continue;
                    LevelChunk c = level.m_6325_(coord.f_45578_, coord.f_45579_);
                    int currentChecksum = 0;
                    for (int iX = 0; iX < 16; ++iX) {
                        for (int iY = 0; iY < 16; ++iY) {
                            for (int iZ = 0; iZ < 16; ++iZ) {
                                BlockPos blockPos = new BlockPos((coord.f_45578_ << 4) + iX, (i << 4) + iY, (coord.f_45579_ << 4) + iZ);
                                BlockState blockState = c.m_8055_(blockPos);
                                currentChecksum += blockState.hashCode();
                            }
                        }
                    }
                    if (currentChecksum == sub.checksum) continue;
                    MainRegistry.LOGGER.debug("  Rebuilding SubChunk (checksum mismatch) at chunk: {}, yReg: {}", (Object)coord, (Object)i);
                    sub.rebuild((Level)level, coord.f_45578_ << 4, i << 4, coord.f_45579_ << 4);
                }
            }
            for (Map.Entry<ChunkPos, SubChunk[]> chunkEntry : system.radiation.entrySet()) {
                if (ChunkRadiationHandlerPRISM.getPrevChunkRadiation(chunkEntry.getValue()) <= 0.0f) continue;
                for (int i = 0; i < 16; ++i) {
                    SubChunk sub = chunkEntry.getValue()[i];
                    if (sub == null || sub.prevRadiation <= 0.0f || Float.isNaN(sub.prevRadiation) || Float.isInfinite(sub.prevRadiation)) continue;
                    float radSpread = 0.0f;
                    for (Direction dir : Direction.values()) {
                        radSpread += ChunkRadiationHandlerPRISM.spreadRadiation((Level)level, sub, i, chunkEntry.getKey(), chunkEntry.getValue(), system.radiation, dir);
                    }
                    sub.radiation += (sub.prevRadiation - radSpread) * 0.95f;
                    sub.radiation -= 1.0f;
                    sub.radiation = Mth.m_14036_((float)sub.radiation, (float)0.0f, (float)MAX_RADIATION);
                    if (!(sub.radiation > 0.0f)) continue;
                    MainRegistry.LOGGER.debug("  SubChunk at chunk: {}, yReg: {} has radiation: {}", (Object)chunkEntry.getKey(), (Object)i, (Object)Float.valueOf(sub.radiation));
                }
            }
            system.radiation.putAll(newAdditions);
            newAdditions.clear();
            MainRegistry.LOGGER.debug("Finished updating radiation system for level: {}", (Object)level.m_46472_().m_135782_());
        }
    }

    private static float spreadRadiation(Level level, SubChunk source, int y, ChunkPos origin, SubChunk[] chunk, ConcurrentHashMap<ChunkPos, SubChunk[]> map, Direction dir) {
        float spread = 0.1f;
        float amount = source.prevRadiation * spread;
        if (amount <= 1.0f) {
            return 0.0f;
        }
        if (dir.m_122434_().m_122479_()) {
            ChunkPos newPos = new ChunkPos(origin.f_45578_ + dir.m_122429_(), origin.f_45579_ + dir.m_122431_());
            if (!level.m_7726_().m_5563_(newPos.f_45578_, newPos.f_45579_)) {
                return amount;
            }
            SubChunk[] newChunk = map.get(newPos);
            if (newChunk == null) {
                newChunk = new SubChunk[16];
                newAdditions.put(newPos, newChunk);
            }
            if (newChunk[y] == null) {
                newChunk[y] = new SubChunk().rebuild(level, newPos.f_45578_ << 4, y << 4, newPos.f_45579_ << 4);
            }
            SubChunk to = newChunk[y];
            return ChunkRadiationHandlerPRISM.spreadRadiationTo(source, to, amount, dir);
        }
        if (dir == Direction.UP && y == 15) {
            return amount;
        }
        if (dir == Direction.DOWN && y == 0) {
            return amount;
        }
        if (chunk[y + dir.m_122430_()] == null) {
            chunk[y + dir.m_122430_()] = new SubChunk().rebuild(level, origin.f_45578_ << 4, y + dir.m_122430_() << 4, origin.f_45579_ << 4);
        }
        SubChunk to = chunk[y + dir.m_122430_()];
        return ChunkRadiationHandlerPRISM.spreadRadiationTo(source, to, amount, dir);
    }

    private static float spreadRadiationTo(SubChunk from, SubChunk to, float amount, Direction movement) {
        float resistance = from.getResistanceValue(movement.m_122424_()) + to.getResistanceValue(movement);
        double fun = Math.pow(Math.E, (double)(-resistance) / 10000.0);
        float toMove = (float)Math.min((double)amount * fun, (double)amount);
        to.radiation += toMove;
        return toMove;
    }

    private static float getPrevChunkRadiation(SubChunk[] chunk) {
        float rad = 0.0f;
        for (SubChunk sub : chunk) {
            if (sub == null) continue;
            rad += sub.prevRadiation;
        }
        return rad;
    }

    @Override
    public void clearSystem(Level level) {
        RadPerWorld system = this.perWorld.get(level);
        if (system != null) {
            system.radiation.clear();
        }
    }

    @Override
    public void onBlockUpdated(Level level, BlockPos pos) {
    }

    public static class RadPerWorld {
        public ConcurrentHashMap<ChunkPos, SubChunk[]> radiation = new ConcurrentHashMap();
    }

    public static class SubChunk {
        public float prevRadiation;
        public float radiation;
        public float[] xResist = new float[16];
        public float[] yResist = new float[16];
        public float[] zResist = new float[16];
        public boolean needsRebuild = false;
        public int checksum = 0;

        public SubChunk rebuild(Level level, int x, int y, int z) {
            long startTime = System.nanoTime();
            MainRegistry.LOGGER.debug("Starting rebuild of SubChunk at X: {}, Y: {}, Z: {}", (Object)x, (Object)y, (Object)z);
            this.needsRebuild = true;
            int cX = x >> 4;
            int cY = Mth.m_14045_((int)(y >> 4), (int)0, (int)15);
            int cZ = z >> 4;
            if (!level.m_7726_().m_5563_(cX, cZ)) {
                return this;
            }
            int tX = cX << 4;
            int tY = cY << 4;
            int tZ = cZ << 4;
            for (int i = 0; i < 16; ++i) {
                this.zResist[i] = 0.0f;
                this.yResist[i] = 0.0f;
                this.xResist[i] = 0.0f;
            }
            LevelChunk chunk = level.m_6325_(cX, cZ);
            this.checksum = 0;
            for (int iX = 0; iX < 16; ++iX) {
                for (int iY = 0; iY < 16; ++iY) {
                    for (int iZ = 0; iZ < 16; ++iZ) {
                        BlockPos blockPos = new BlockPos(tX + iX, tY + iY, tZ + iZ);
                        BlockState blockState = chunk.m_8055_(blockPos);
                        Block block = blockState.m_60734_();
                        if (blockState.m_60795_()) continue;
                        float resistance = Math.min(blockState.getExplosionResistance((BlockGetter)level, blockPos, null), 100.0f);
                        int n = iX;
                        this.xResist[n] = this.xResist[n] + resistance;
                        int n2 = iY;
                        this.yResist[n2] = this.yResist[n2] + resistance;
                        int n3 = iZ;
                        this.zResist[n3] = this.zResist[n3] + resistance;
                        this.checksum += blockState.hashCode();
                    }
                }
            }
            this.needsRebuild = false;
            long endTime = System.nanoTime();
            long duration = (endTime - startTime) / 1000000L;
            MainRegistry.LOGGER.debug("Finished rebuild of SubChunk at X: {}, Y: {}, Z: {}. Took {} ms.", (Object)x, (Object)y, (Object)z, (Object)duration);
            return this;
        }

        public float getResistanceValue(Direction movement) {
            if (movement == Direction.EAST) {
                return this.getResistanceFromArray(this.xResist, true);
            }
            if (movement == Direction.WEST) {
                return this.getResistanceFromArray(this.xResist, false);
            }
            if (movement == Direction.UP) {
                return this.getResistanceFromArray(this.yResist, true);
            }
            if (movement == Direction.DOWN) {
                return this.getResistanceFromArray(this.yResist, false);
            }
            if (movement == Direction.SOUTH) {
                return this.getResistanceFromArray(this.zResist, true);
            }
            if (movement == Direction.NORTH) {
                return this.getResistanceFromArray(this.zResist, false);
            }
            return 0.0f;
        }

        private float getResistanceFromArray(float[] resist, boolean reverse) {
            float res = 0.0f;
            for (int i = 1; i < 16; ++i) {
                int index = reverse ? 15 - i : i;
                res += resist[index] / 15.0f * (float)i;
            }
            return res;
        }
    }
}

