/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.util;

import com.hbm_m.sound.ModSounds;
import com.hbm_m.util.LegacyAnimator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class DoorDecl {
    private final Map<String, BakedModel> modelCache = new HashMap<String, BakedModel>();
    private BakedModel[] cachedModelParts = null;
    private String[] cachedPartNames = null;
    public static final DoorDecl LARGE_VEHICLE_DOOR = new DoorDecl(){

        @Override
        protected ResourceLocation getBlockId() {
            return new ResourceLocation("hbm_m", "large_vehicle_door");
        }

        @Override
        public String[] getPartNames() {
            return new String[]{"frame", "doorLeft", "doorRight"};
        }

        @Override
        public int getOpenTime() {
            return 60;
        }

        @Override
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if ("doorLeft".equals(partName)) {
                this.set(trans, 0.0f, 0.0f, 3.0f * this.getNormTime(openTicks));
            } else if ("doorRight".equals(partName)) {
                this.set(trans, 0.0f, 0.0f, -3.0f * this.getNormTime(openTicks));
            } else {
                super.getTranslation(partName, openTicks, child, trans);
            }
        }

        @Override
        public double[][] getClippingPlanes() {
            return new double[][]{{1.0, 0.0, 0.0, 3.5}, {-1.0, 0.0, 0.0, 3.5}};
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{0, 0, 0, -4, 6, 2}, {0, 0, 0, 4, 6, 2}};
        }

        @Override
        public int[] getDimensions() {
            return new int[]{5, 0, 0, 0, 3, 3};
        }

        @Override
        public List<AABB> getCollisionBounds(float progress, Direction facing) {
            double rightMovement;
            double rightOffset;
            ArrayList<AABB> bounds = new ArrayList<AABB>();
            if (progress >= 0.99f) {
                return bounds;
            }
            double leftMovement = (double)progress * 3.0;
            double leftDepth = Math.max(0.0, 1.0 - leftMovement);
            if (leftDepth > 0.05) {
                AABB leftDoor = new AABB(-3.0, 0.0, 0.0, 0.0, 6.0, leftDepth);
                bounds.add(this.rotateAABB(leftDoor, facing));
            }
            if (1.0 - (rightOffset = Math.min(1.0, rightMovement = (double)progress * 3.0)) > 0.05) {
                AABB rightDoor = new AABB(0.0, 0.0, rightOffset, 3.0, 6.0, 1.0);
                bounds.add(this.rotateAABB(rightDoor, facing));
            }
            return bounds;
        }

        private AABB rotateAABB(AABB aabb, Direction facing) {
            double minX = aabb.f_82288_;
            double minY = aabb.f_82289_;
            double minZ = aabb.f_82290_;
            double maxX = aabb.f_82291_;
            double maxY = aabb.f_82292_;
            double maxZ = aabb.f_82293_;
            return switch (facing) {
                case Direction.NORTH -> aabb;
                case Direction.SOUTH -> new AABB(-maxX, minY, -maxZ, -minX, maxY, -minZ);
                case Direction.WEST -> new AABB(-maxZ, minY, minX, -minZ, maxY, maxX);
                case Direction.EAST -> new AABB(minZ, minY, -maxX, maxZ, maxY, -minX);
                default -> aabb;
            };
        }

        @Override
        public SoundEvent getOpenSoundStart() {
            return null;
        }

        @Override
        public SoundEvent getOpenSoundEnd() {
            return (SoundEvent)ModSounds.GARAGE_STOP.get();
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return (SoundEvent)ModSounds.GARAGE_MOVE.get();
        }

        @Override
        public SoundEvent getCloseSoundStart() {
            return null;
        }

        @Override
        public SoundEvent getCloseSoundEnd() {
            return (SoundEvent)ModSounds.GARAGE_STOP.get();
        }

        @Override
        public SoundEvent getCloseSoundLoop() {
            return (SoundEvent)ModSounds.GARAGE_MOVE.get();
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }
    };

    public abstract int getOpenTime();

    public abstract int[][] getDoorOpenRanges();

    public abstract int[] getDimensions();

    protected abstract ResourceLocation getBlockId();

    public abstract List<AABB> getCollisionBounds(float var1, Direction var2);

    public String[] getPartNames() {
        if (this.cachedPartNames == null) {
            this.cachedPartNames = new String[]{"main"};
        }
        return this.cachedPartNames;
    }

    @Nullable
    public BakedModel[] getModelParts() {
        if (this.cachedModelParts != null) {
            return this.cachedModelParts;
        }
        ModelManager modelManager = Minecraft.m_91087_().m_91304_();
        String[] partNames = this.getPartNames();
        this.cachedModelParts = new BakedModel[partNames.length];
        for (int i = 0; i < partNames.length; ++i) {
            BakedModel model;
            String partName = partNames[i];
            ModelResourceLocation modelLocation = "main".equals(partName) ? new ModelResourceLocation(this.getBlockId(), "") : new ModelResourceLocation(this.getBlockId(), "part=" + partName);
            this.cachedModelParts[i] = model = modelManager.m_119422_(modelLocation);
            this.modelCache.put(partName, model);
        }
        return this.cachedModelParts;
    }

    @Nullable
    public BakedModel getModelPart(String partName) {
        if (this.modelCache.containsKey(partName)) {
            return this.modelCache.get(partName);
        }
        this.getModelParts();
        return this.modelCache.get(partName);
    }

    public ResourceLocation getTextureForPart(int skinIndex, String partName) {
        BakedModel model = this.getModelPart(partName);
        if (model != null && !model.m_213637_(null, null, null).isEmpty()) {
            return model.m_6160_().m_247685_();
        }
        return new ResourceLocation("minecraft", "textures/atlas/blocks.png");
    }

    public ResourceLocation getTextureForPart(String partName) {
        return this.getTextureForPart(0, partName);
    }

    public int getBlockOffset() {
        return 0;
    }

    public boolean remoteControllable() {
        return false;
    }

    public float getDoorRangeOpenTime(int currentTick, int rangeIndex) {
        return this.getNormTime(currentTick);
    }

    public boolean hasSkins() {
        return false;
    }

    public int getSkinCount() {
        return 0;
    }

    public boolean isLadder(boolean open) {
        return false;
    }

    public AABB getBlockBound(int x, int y, int z, boolean open, boolean forCollision) {
        if (open) {
            return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        return new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Nullable
    public SoundEvent getOpenSoundStart() {
        return null;
    }

    @Nullable
    public SoundEvent getOpenSoundEnd() {
        return null;
    }

    @Nullable
    public SoundEvent getOpenSoundLoop() {
        return null;
    }

    @Nullable
    public SoundEvent getCloseSoundStart() {
        return this.getOpenSoundStart();
    }

    @Nullable
    public SoundEvent getCloseSoundEnd() {
        return this.getOpenSoundEnd();
    }

    @Nullable
    public SoundEvent getCloseSoundLoop() {
        return this.getOpenSoundLoop();
    }

    @Nullable
    public SoundEvent getSoundLoop2() {
        return null;
    }

    public float getSoundVolume() {
        return 1.0f;
    }

    public double getRenderRadius() {
        return 8.0;
    }

    public Component getLockedMessage() {
        return Component.m_237115_((String)"door.locked");
    }

    public void doOffsetTransform(LegacyAnimator animator) {
    }

    public double[][] getClippingPlanes() {
        return new double[0][];
    }

    public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
        trans[0] = 0.0f;
        trans[1] = 0.0f;
        trans[2] = 0.0f;
    }

    public void getOrigin(String partName, float[] orig) {
        orig[0] = 0.0f;
        orig[1] = 0.0f;
        orig[2] = 0.0f;
    }

    public void getRotation(String partName, float openTicks, float[] rot) {
        rot[0] = 0.0f;
        rot[1] = 0.0f;
        rot[2] = 0.0f;
    }

    public boolean doesRender(String partName, boolean child) {
        return true;
    }

    public String[] getChildren(String partName) {
        return new String[0];
    }

    protected float getNormTime(float time) {
        return this.getNormTime(time, 0.0f, this.getOpenTime());
    }

    protected float getNormTime(float time, float min, float max) {
        if (max - min == 0.0f) {
            return 0.0f;
        }
        return Math.max(0.0f, Math.min(1.0f, (time - min) / (max - min)));
    }

    protected void set(float[] array, float x, float y, float z) {
        array[0] = x;
        array[1] = y;
        array[2] = z;
    }
}

