/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class LegacyAnimator {
    private final PoseStack poseStack;
    private final MultiBufferSource bufferSource;
    private final BlockRenderDispatcher blockRenderer;
    private final int packedLight;
    private final int packedOverlay;
    private double clipMin = Double.NEGATIVE_INFINITY;
    private double clipMax = Double.POSITIVE_INFINITY;

    public LegacyAnimator(PoseStack poseStack, MultiBufferSource bufferSource, BlockRenderDispatcher blockRenderer, int packedLight, int packedOverlay) {
        this.poseStack = poseStack;
        this.bufferSource = bufferSource;
        this.blockRenderer = blockRenderer;
        this.packedLight = packedLight;
        this.packedOverlay = packedOverlay;
    }

    public void setClippingRange(double min, double max) {
        this.clipMin = min;
        this.clipMax = max;
    }

    public void push() {
        this.poseStack.m_85836_();
    }

    public void pop() {
        this.poseStack.m_85849_();
    }

    public void translate(double x, double y, double z) {
        this.poseStack.m_85837_(x, y, z);
    }

    public void rotate(double angle, double x, double y, double z) {
        if (x == 1.0 && y == 0.0 && z == 0.0) {
            this.poseStack.m_252781_(Axis.f_252529_.m_252977_((float)angle));
        } else if (x == 0.0 && y == 1.0 && z == 0.0) {
            this.poseStack.m_252781_(Axis.f_252436_.m_252977_((float)angle));
        } else if (x == 0.0 && y == 0.0 && z == 1.0) {
            this.poseStack.m_252781_(Axis.f_252403_.m_252977_((float)angle));
        }
    }

    public void setupBlockTransform(Direction facing) {
        this.translate(0.5, 0.0, 0.5);
        this.rotate(90.0, 0.0, 1.0, 0.0);
        float directionalRotation = switch (facing) {
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> 270.0f;
            default -> 0.0f;
        };
        this.rotate(directionalRotation, 0.0, 1.0, 0.0);
    }

    public void renderPart(BakedModel modelPart) {
        if (modelPart == null) {
            return;
        }
        if (this.clipMin == Double.NEGATIVE_INFINITY && this.clipMax == Double.POSITIVE_INFINITY) {
            this.blockRenderer.m_110937_().renderModel(this.poseStack.m_85850_(), this.bufferSource.m_6299_(RenderType.m_110466_()), null, modelPart, 1.0f, 1.0f, 1.0f, this.packedLight, this.packedOverlay, ModelData.EMPTY, null);
            return;
        }
        this.renderPartWithAlphaClipping(modelPart);
    }

    private void renderPartWithAlphaClipping(BakedModel modelPart) {
        VertexConsumer consumer = this.bufferSource.m_6299_(RenderType.m_110466_());
        List quads = modelPart.getQuads(null, null, RandomSource.m_216327_(), ModelData.EMPTY, null);
        PoseStack.Pose pose = this.poseStack.m_85850_();
        for (BakedQuad quad : quads) {
            float alpha = this.calculateQuadAlpha(quad, pose);
            if (alpha < 0.01f) continue;
            consumer.putBulkData(pose, quad, 1.0f, 1.0f, 1.0f, alpha, this.packedLight, this.packedOverlay, false);
        }
    }

    private float calculateQuadAlpha(BakedQuad quad, PoseStack.Pose pose) {
        int[] vertexData = quad.m_111303_();
        float totalAlpha = 0.0f;
        for (int i = 0; i < 4; ++i) {
            int offset = i * 8;
            float x = Float.intBitsToFloat(vertexData[offset]);
            float y = Float.intBitsToFloat(vertexData[offset + 1]);
            float z = Float.intBitsToFloat(vertexData[offset + 2]);
            Vector3f transformed = new Vector3f(x, y, z);
            transformed.mulPosition((Matrix4fc)pose.m_252922_());
            float vertexAlpha = this.calculateVertexAlpha(transformed.z());
            totalAlpha += vertexAlpha;
        }
        return totalAlpha / 4.0f;
    }

    private float calculateVertexAlpha(float z) {
        double fadeDistance = 0.5;
        if ((double)z < this.clipMin) {
            double distance = this.clipMin - (double)z;
            return (float)Math.max(0.0, 1.0 - distance / fadeDistance);
        }
        if ((double)z > this.clipMax) {
            double distance = (double)z - this.clipMax;
            return (float)Math.max(0.0, 1.0 - distance / fadeDistance);
        }
        return 1.0f;
    }
}

