/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.util;

import com.hbm_m.item.ModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

public class TemplateCraftingCosts {
    private static final Map<Item, NonNullList<Ingredient>> TEMPLATE_COSTS = new HashMap<Item, NonNullList<Ingredient>>();
    private static final Map<Item, NonNullList<Ingredient>> STAMP_COSTS = new HashMap<Item, NonNullList<Ingredient>>();

    private static void registerTemplateCost(Item templateType, NonNullList<Ingredient> ingredients) {
        TEMPLATE_COSTS.put(templateType, ingredients);
    }

    private static void registerStampCost(Item stampType, NonNullList<Ingredient> ingredients) {
        STAMP_COSTS.put(stampType, ingredients);
    }

    public static NonNullList<Ingredient> getCostForTemplate(ItemStack recipeOutput) {
        return TEMPLATE_COSTS.get(ModItems.ASSEMBLY_TEMPLATE.get());
    }

    public static NonNullList<Ingredient> getCostForStamp(ItemStack stamp) {
        return STAMP_COSTS.get(stamp.m_41720_());
    }

    public static boolean isStamp(ItemStack stack) {
        return STAMP_COSTS.containsKey(stack.m_41720_());
    }

    static {
        TemplateCraftingCosts.registerTemplateCost((Item)ModItems.ASSEMBLY_TEMPLATE.get(), (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42516_}), Ingredient.m_204132_((TagKey)Tags.Items.DYES)}));
        NonNullList stoneFlatCost = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STAMP_STONE_FLAT.get()})});
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_STONE_PLATE.get(), (NonNullList<Ingredient>)stoneFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_STONE_WIRE.get(), (NonNullList<Ingredient>)stoneFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_STONE_CIRCUIT.get(), (NonNullList<Ingredient>)stoneFlatCost);
        NonNullList ironFlatCost = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STAMP_IRON_FLAT.get()})});
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_IRON_PLATE.get(), (NonNullList<Ingredient>)ironFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_IRON_WIRE.get(), (NonNullList<Ingredient>)ironFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_IRON_CIRCUIT.get(), (NonNullList<Ingredient>)ironFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_IRON_9.get(), (NonNullList<Ingredient>)ironFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_IRON_44.get(), (NonNullList<Ingredient>)ironFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_IRON_50.get(), (NonNullList<Ingredient>)ironFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_IRON_357.get(), (NonNullList<Ingredient>)ironFlatCost);
        NonNullList steelFlatCost = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STAMP_STEEL_FLAT.get()})});
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_STEEL_PLATE.get(), (NonNullList<Ingredient>)steelFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_STEEL_WIRE.get(), (NonNullList<Ingredient>)steelFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_STEEL_CIRCUIT.get(), (NonNullList<Ingredient>)steelFlatCost);
        NonNullList titaniumFlatCost = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STAMP_TITANIUM_FLAT.get()})});
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_TITANIUM_PLATE.get(), (NonNullList<Ingredient>)titaniumFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_TITANIUM_WIRE.get(), (NonNullList<Ingredient>)titaniumFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_TITANIUM_CIRCUIT.get(), (NonNullList<Ingredient>)titaniumFlatCost);
        NonNullList obsidianFlatCost = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STAMP_OBSIDIAN_FLAT.get()})});
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_OBSIDIAN_PLATE.get(), (NonNullList<Ingredient>)obsidianFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_OBSIDIAN_WIRE.get(), (NonNullList<Ingredient>)obsidianFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_OBSIDIAN_CIRCUIT.get(), (NonNullList<Ingredient>)obsidianFlatCost);
        NonNullList deshFlatCost = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STAMP_DESH_FLAT.get()})});
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_DESH_PLATE.get(), (NonNullList<Ingredient>)deshFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_DESH_WIRE.get(), (NonNullList<Ingredient>)deshFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_DESH_CIRCUIT.get(), (NonNullList<Ingredient>)deshFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_DESH_9.get(), (NonNullList<Ingredient>)deshFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_DESH_44.get(), (NonNullList<Ingredient>)deshFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_DESH_50.get(), (NonNullList<Ingredient>)deshFlatCost);
        TemplateCraftingCosts.registerStampCost((Item)ModItems.STAMP_DESH_357.get(), (NonNullList<Ingredient>)deshFlatCost);
    }
}

