/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.api.energy;

import com.hbm_m.api.energy.HbmForgeWrapper;
import com.hbm_m.api.energy.IEnergyProvider;
import com.hbm_m.api.energy.IEnergyReceiver;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.capability.ModCapabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConverterBlockEntity
extends BlockEntity
implements IEnergyReceiver,
IEnergyProvider {
    private long energy = 0L;
    private static final long[] TIERS = new long[]{1000L, 10000L, 50000L, 100000L, 1000000L, 100000000L, Integer.MAX_VALUE};
    private int tierIndex = 2;
    private long currentLimit = TIERS[this.tierIndex];
    private int ioMode = 0;
    private final HbmForgeWrapper forgeWrapper = new HbmForgeWrapper(this);
    private LazyOptional<IEnergyStorage> forgeCap = LazyOptional.of(() -> this.forgeWrapper);
    private final LazyOptional<IEnergyProvider> hbmProviderCap = LazyOptional.of(() -> this);
    private final LazyOptional<IEnergyReceiver> hbmReceiverCap = LazyOptional.of(() -> this);

    public ConverterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CONVERTER_BE.get(), pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.forgeCap.isPresent()) {
            this.forgeCap = LazyOptional.of(() -> this.forgeWrapper);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.forgeCap.invalidate();
    }

    public void cycleLimit() {
        this.tierIndex = (this.tierIndex + 1) % TIERS.length;
        this.currentLimit = TIERS[this.tierIndex];
        this.m_6596_();
    }

    public void cycleMode() {
        this.ioMode = (this.ioMode + 1) % 3;
        this.m_6596_();
    }

    public String getModeName() {
        return switch (this.ioMode) {
            case 1 -> "HBM -> FE (Export Only)";
            case 2 -> "FE -> HBM (Import Only)";
            default -> "Bi-Directional";
        };
    }

    public long getCurrentLimit() {
        return this.currentLimit;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ConverterBlockEntity be) {
        if (be.energy <= 0L) {
            return;
        }
        if (be.ioMode == 2) {
            return;
        }
        for (Direction dir : Direction.values()) {
            BlockEntity neighbor = level.m_7702_(pos.m_121945_(dir));
            if (neighbor == null) continue;
            neighbor.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_()).ifPresent(storage -> {
                long canExtract;
                int toPush;
                int accepted;
                if (storage.canReceive() && (accepted = storage.receiveEnergy(toPush = (int)Math.min(canExtract = Math.min(be.energy, be.currentLimit), Integer.MAX_VALUE), false)) > 0) {
                    be.energy -= (long)accepted;
                    be.m_6596_();
                }
            });
        }
    }

    @Override
    public boolean canExtract() {
        return (this.ioMode == 0 || this.ioMode == 2) && this.energy > 0L;
    }

    @Override
    public boolean canReceive() {
        return (this.ioMode == 0 || this.ioMode == 1) && this.energy < this.currentLimit;
    }

    @Override
    public long extractEnergy(long maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0L;
        }
        long limit = Math.min(maxExtract, this.currentLimit);
        long extracted = Math.min(this.energy, limit);
        if (!simulate && extracted > 0L) {
            this.energy -= extracted;
            this.m_6596_();
        }
        return extracted;
    }

    @Override
    public long receiveEnergy(long maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0L;
        }
        long space = this.currentLimit - this.energy;
        long limit = Math.min(maxReceive, this.currentLimit);
        long received = Math.min(space, limit);
        if (!simulate && received > 0L) {
            this.energy += received;
            this.m_6596_();
        }
        return received;
    }

    @Override
    public long getEnergyStored() {
        return this.energy;
    }

    @Override
    public void setEnergyStored(long energy) {
        this.energy = Math.min(energy, this.currentLimit);
        this.m_6596_();
    }

    @Override
    public long getMaxEnergyStored() {
        return this.currentLimit;
    }

    @Override
    public long getProvideSpeed() {
        return this.currentLimit;
    }

    @Override
    public long getReceiveSpeed() {
        return this.currentLimit;
    }

    @Override
    public IEnergyReceiver.Priority getPriority() {
        return IEnergyReceiver.Priority.NORMAL;
    }

    @Override
    public boolean canConnectEnergy(Direction side) {
        return true;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.forgeCap.cast();
        }
        if (cap == ModCapabilities.HBM_ENERGY_PROVIDER) {
            return this.hbmProviderCap.cast();
        }
        if (cap == ModCapabilities.HBM_ENERGY_RECEIVER) {
            return this.hbmReceiverCap.cast();
        }
        if (cap == ModCapabilities.HBM_ENERGY_CONNECTOR) {
            return this.hbmProviderCap.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128356_("energy", this.energy);
        tag.m_128405_("tierIndex", this.tierIndex);
        tag.m_128405_("ioMode", this.ioMode);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energy = tag.m_128454_("energy");
        if (tag.m_128441_("tierIndex")) {
            this.tierIndex = tag.m_128451_("tierIndex");
            if (this.tierIndex >= 0 && this.tierIndex < TIERS.length) {
                this.currentLimit = TIERS[this.tierIndex];
            }
        }
        if (tag.m_128441_("ioMode")) {
            this.ioMode = tag.m_128451_("ioMode");
        }
    }
}

