/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.api.energy;

import com.hbm_m.api.energy.IEnergyConnector;
import com.hbm_m.api.energy.IEnergyProvider;
import com.hbm_m.api.energy.IEnergyReceiver;
import com.hbm_m.api.energy.LongEnergyWrapper;
import com.hbm_m.capability.ModCapabilities;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyCapabilityProvider
implements ICapabilityProvider {
    private final LazyOptional<ItemEnergyStorage> storage = LazyOptional.of(() -> new ItemEnergyStorage(stack, capacity, maxReceive, maxExtract));

    public EnergyCapabilityProvider(ItemStack stack, long capacity, long maxReceive, long maxExtract) {
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.HBM_ENERGY_PROVIDER && this.storage.resolve().map(ItemEnergyStorage::canExtract).orElse(false).booleanValue()) {
            return this.storage.cast();
        }
        if (cap == ModCapabilities.HBM_ENERGY_RECEIVER && this.storage.resolve().map(ItemEnergyStorage::canReceive).orElse(false).booleanValue()) {
            return this.storage.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.storage.lazyMap(s -> new LongEnergyWrapper((IEnergyConnector)s, LongEnergyWrapper.BitMode.LOW)).cast();
        }
        return LazyOptional.empty();
    }

    private static class ItemEnergyStorage
    implements IEnergyProvider,
    IEnergyReceiver {
        private final ItemStack stack;
        private final long capacity;
        private final long maxReceive;
        private final long maxExtract;

        ItemEnergyStorage(ItemStack stack, long capacity, long maxReceive, long maxExtract) {
            this.stack = stack;
            this.capacity = capacity;
            this.maxReceive = maxReceive;
            this.maxExtract = maxExtract;
        }

        @Override
        public long getEnergyStored() {
            return this.stack.m_41784_().m_128454_("energy");
        }

        @Override
        public void setEnergyStored(long energy) {
            long clamped = Math.max(0L, Math.min(energy, this.capacity));
            this.stack.m_41784_().m_128356_("energy", clamped);
        }

        @Override
        public long getMaxEnergyStored() {
            return this.capacity;
        }

        @Override
        public long receiveEnergy(long maxReceive, boolean simulate) {
            if (!this.canReceive()) {
                return 0L;
            }
            long energyStored = this.getEnergyStored();
            long energyReceived = Math.min(this.capacity - energyStored, Math.min(this.maxReceive, maxReceive));
            if (!simulate && energyReceived > 0L) {
                this.setEnergyStored(energyStored + energyReceived);
            }
            return energyReceived;
        }

        @Override
        public long getReceiveSpeed() {
            return this.maxReceive;
        }

        @Override
        public IEnergyReceiver.Priority getPriority() {
            return IEnergyReceiver.Priority.NORMAL;
        }

        @Override
        public boolean canReceive() {
            return this.maxReceive > 0L && this.getEnergyStored() < this.capacity;
        }

        @Override
        public long extractEnergy(long maxExtract, boolean simulate) {
            if (!this.canExtract()) {
                return 0L;
            }
            long energyStored = this.getEnergyStored();
            long energyExtracted = Math.min(energyStored, Math.min(this.maxExtract, maxExtract));
            if (!simulate && energyExtracted > 0L) {
                this.setEnergyStored(energyStored - energyExtracted);
            }
            return energyExtracted;
        }

        @Override
        public long getProvideSpeed() {
            return this.maxExtract;
        }

        @Override
        public boolean canExtract() {
            return this.maxExtract > 0L && this.getEnergyStored() > 0L;
        }

        @Override
        public boolean canConnectEnergy(Direction side) {
            return true;
        }
    }
}

