/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.api.energy;

import com.hbm_m.api.energy.EnergyNetworkManager;
import com.hbm_m.api.energy.EnergyNode;
import com.hbm_m.api.energy.IEnergyProvider;
import com.hbm_m.api.energy.IEnergyReceiver;
import com.hbm_m.block.entity.machine.MachineBatteryBlockEntity;
import com.hbm_m.capability.ModCapabilities;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.slf4j.Logger;

public class EnergyNetwork {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final EnergyNetworkManager manager;
    private final Set<EnergyNode> nodes = new HashSet<EnergyNode>();
    private final UUID id = UUID.randomUUID();

    public EnergyNetwork(EnergyNetworkManager manager) {
        this.manager = manager;
    }

    public void tick(ServerLevel level) {
        int sizeBefore = this.nodes.size();
        this.nodes.removeIf(node -> !node.isValid(level) || node.getNetwork() != this);
        if (this.nodes.size() < sizeBefore) {
            this.verifyConnectivity();
        }
        if (this.nodes.size() < 2) {
            return;
        }
        HashSet<IEnergyProvider> generators = new HashSet<IEnergyProvider>();
        EnumMap<IEnergyReceiver.Priority, Set> consumersByPriority = new EnumMap<IEnergyReceiver.Priority, Set>(IEnergyReceiver.Priority.class);
        IdentityHashMap<IEnergyReceiver, Long> consumerDemand = new IdentityHashMap<IEnergyReceiver, Long>();
        ArrayList<BatteryInfo> batteries = new ArrayList<BatteryInfo>();
        long totalConsumption = 0L;
        for (EnergyNode node2 : this.nodes) {
            long needed;
            IEnergyReceiver consumer;
            BlockEntity be;
            if (!level.m_46749_(node2.getPos()) || (be = level.m_7702_(node2.getPos())) == null) continue;
            Optional providerCap = be.getCapability(ModCapabilities.HBM_ENERGY_PROVIDER).resolve();
            Optional receiverCap = be.getCapability(ModCapabilities.HBM_ENERGY_RECEIVER).resolve();
            boolean isProvider = providerCap.isPresent();
            boolean isReceiver = receiverCap.isPresent();
            if (isProvider && isReceiver) {
                long needed2;
                long available;
                int n;
                if (be instanceof MachineBatteryBlockEntity) {
                    MachineBatteryBlockEntity batteryBE = (MachineBatteryBlockEntity)be;
                    n = batteryBE.getCurrentMode();
                } else {
                    n = 0;
                }
                int mode = n;
                BatteryInfo batteryInfo = new BatteryInfo(node2.getPos(), (IEnergyReceiver)receiverCap.get(), (IEnergyProvider)providerCap.get(), mode);
                batteries.add(batteryInfo);
                if (batteryInfo.canOutput() && batteryInfo.provider.canExtract() && (available = Math.min(batteryInfo.provider.getEnergyStored(), batteryInfo.provider.getProvideSpeed())) > 0L) {
                    generators.add(batteryInfo.provider);
                }
                if (!batteryInfo.canInput() || !batteryInfo.receiver.canReceive() || (needed2 = Math.min(batteryInfo.receiver.getMaxEnergyStored() - batteryInfo.receiver.getEnergyStored(), batteryInfo.receiver.getReceiveSpeed())) <= 0L) continue;
                consumerDemand.put(batteryInfo.receiver, needed2);
                consumersByPriority.computeIfAbsent(batteryInfo.receiver.getPriority(), k -> new HashSet()).add(batteryInfo.receiver);
                totalConsumption += needed2;
                continue;
            }
            if (isProvider) {
                generators.add((IEnergyProvider)providerCap.get());
                continue;
            }
            if (!isReceiver || !(consumer = (IEnergyReceiver)receiverCap.get()).canReceive() || (needed = Math.min(consumer.getMaxEnergyStored() - consumer.getEnergyStored(), consumer.getReceiveSpeed())) <= 0L) continue;
            consumerDemand.put(consumer, needed);
            consumersByPriority.computeIfAbsent(consumer.getPriority(), k -> new HashSet()).add(consumer);
            totalConsumption += needed;
        }
        long totalGeneration = 0L;
        IdentityHashMap<IEnergyProvider, Long> generatorCapacity = new IdentityHashMap<IEnergyProvider, Long>();
        for (IEnergyProvider gen : generators) {
            long available;
            if (!gen.canExtract() || (available = Math.min(gen.getEnergyStored(), gen.getProvideSpeed())) <= 0L) continue;
            generatorCapacity.put(gen, available);
            totalGeneration += available;
        }
        long energyToDistribute = Math.min(totalGeneration, totalConsumption);
        long remainingGeneration = totalGeneration;
        if (energyToDistribute > 0L) {
            for (int i = IEnergyReceiver.Priority.values().length - 1; i >= 0; --i) {
                IEnergyReceiver.Priority priority = IEnergyReceiver.Priority.values()[i];
                Set currentGroup = (Set)consumersByPriority.get((Object)priority);
                if (currentGroup == null || currentGroup.isEmpty()) continue;
                if (energyToDistribute <= 0L) break;
                long groupDemand = 0L;
                for (IEnergyReceiver consumer : currentGroup) {
                    groupDemand += consumerDemand.getOrDefault(consumer, 0L).longValue();
                }
                if (groupDemand <= 0L) continue;
                long energyToGiveThisGroup = Math.min(energyToDistribute, groupDemand);
                long energyGiven = this.distributeProportionally(energyToGiveThisGroup, currentGroup, consumerDemand, generatorCapacity);
                energyToDistribute -= energyGiven;
                remainingGeneration -= energyGiven;
            }
        }
        this.balanceBatteries(batteries);
    }

    private long distributeProportionally(long amount, Set<IEnergyReceiver> consumers, Map<IEnergyReceiver, Long> consumerDemand, Map<IEnergyProvider, Long> providers) {
        if (amount <= 0L || consumers.isEmpty() || providers.isEmpty()) {
            return 0L;
        }
        long totalGroupDemand = 0L;
        for (IEnergyReceiver consumer : consumers) {
            totalGroupDemand += consumerDemand.getOrDefault(consumer, 0L).longValue();
        }
        if (totalGroupDemand <= 0L) {
            return 0L;
        }
        long totalEnergyGiven = 0L;
        for (IEnergyReceiver consumer : consumers) {
            long accepted;
            long demand = consumerDemand.getOrDefault(consumer, 0L);
            if (demand <= 0L) continue;
            double share = (double)demand / (double)totalGroupDemand;
            long energyForThis = (long)((double)amount * share);
            if (energyForThis == 0L && amount > 0L) {
                energyForThis = Math.min(amount, demand);
            }
            if (energyForThis <= 0L || (accepted = consumer.receiveEnergy(energyForThis, false)) <= 0L) continue;
            this.extractFromProviders(accepted, providers);
            totalEnergyGiven += accepted;
            amount -= accepted;
            consumerDemand.put(consumer, demand - accepted);
        }
        return totalEnergyGiven;
    }

    private void balanceBatteries(List<BatteryInfo> batteries) {
        EnumMap<IEnergyReceiver.Priority, List> batteriesByPriority = new EnumMap<IEnergyReceiver.Priority, List>(IEnergyReceiver.Priority.class);
        for (BatteryInfo battery : batteries) {
            if (battery.mode != 0) continue;
            batteriesByPriority.computeIfAbsent(battery.receiver.getPriority(), k -> new ArrayList()).add(battery);
        }
        for (List priorityGroup : batteriesByPriority.values()) {
            this.balanceSinglePriorityGroup(priorityGroup);
        }
    }

    private void balanceSinglePriorityGroup(List<BatteryInfo> balancingBatteries) {
        if (balancingBatteries.size() < 2) {
            return;
        }
        long totalEnergy = 0L;
        long totalCapacity = 0L;
        for (BatteryInfo battery : balancingBatteries) {
            totalEnergy += battery.provider.getEnergyStored();
            totalCapacity += battery.provider.getMaxEnergyStored();
        }
        if (totalCapacity <= 0L) {
            return;
        }
        double averagePercentage = (double)totalEnergy / (double)totalCapacity;
        IdentityHashMap<BatteryInfo, Long> givers = new IdentityHashMap<BatteryInfo, Long>();
        IdentityHashMap<BatteryInfo, Long> takers = new IdentityHashMap<BatteryInfo, Long>();
        long totalToGive = 0L;
        long totalToTake = 0L;
        long buffer = 100L;
        for (BatteryInfo battery : balancingBatteries) {
            long targetEnergy = (long)((double)battery.provider.getMaxEnergyStored() * averagePercentage);
            long currentEnergy = battery.provider.getEnergyStored();
            long diff = currentEnergy - targetEnergy;
            if (diff > buffer && battery.provider.canExtract()) {
                long canGive = Math.min(diff - buffer, battery.provider.getProvideSpeed());
                if ((canGive = Math.min(canGive, battery.provider.getEnergyStored())) <= 0L) continue;
                givers.put(battery, canGive);
                totalToGive += canGive;
                continue;
            }
            if (diff >= -buffer || !battery.receiver.canReceive()) continue;
            long canTake = Math.min(-diff - buffer, battery.receiver.getReceiveSpeed());
            if ((canTake = Math.min(canTake, battery.receiver.getMaxEnergyStored() - currentEnergy)) <= 0L) continue;
            takers.put(battery, canTake);
            totalToTake += canTake;
        }
        if (givers.isEmpty() || takers.isEmpty() || totalToGive <= 0L || totalToTake <= 0L) {
            return;
        }
        long totalToTransfer = Math.min(totalToGive, totalToTake);
        if (totalToTransfer <= 0L) {
            return;
        }
        long transferredSoFar = 0L;
        for (Map.Entry entry : takers.entrySet()) {
            if (transferredSoFar >= totalToTransfer) break;
            BatteryInfo taker = (BatteryInfo)entry.getKey();
            long need = (Long)entry.getValue();
            double share = (double)need / (double)totalToTake;
            long energyForThis = (long)((double)totalToTransfer * share);
            energyForThis = Math.min(energyForThis, need);
            if ((energyForThis = Math.min(energyForThis, totalToTransfer - transferredSoFar)) <= 0L) continue;
            long accepted = taker.receiver.receiveEnergy(energyForThis, false);
            transferredSoFar += accepted;
        }
        long extractedSoFar = 0L;
        long totalToExtract = transferredSoFar;
        for (Map.Entry entry : givers.entrySet()) {
            if (extractedSoFar >= totalToExtract) break;
            BatteryInfo giver = (BatteryInfo)entry.getKey();
            long offer = (Long)entry.getValue();
            double share = (double)offer / (double)totalToGive;
            long energyToExtract = (long)((double)totalToExtract * share);
            energyToExtract = Math.min(energyToExtract, offer);
            if ((energyToExtract = Math.min(energyToExtract, totalToExtract - extractedSoFar)) <= 0L) continue;
            long extracted = giver.provider.extractEnergy(energyToExtract, false);
            extractedSoFar += extracted;
        }
    }

    private void extractFromProviders(long amount, Map<IEnergyProvider, Long> providers) {
        if (amount <= 0L || providers.isEmpty()) {
            return;
        }
        long totalCapacity = providers.values().stream().mapToLong(Long::longValue).sum();
        if (totalCapacity <= 0L) {
            long amountPer = amount / (long)providers.size();
            long remaining = amount;
            for (IEnergyProvider provider : new ArrayList<IEnergyProvider>(providers.keySet())) {
                if (remaining <= 0L) break;
                long toExtract = Math.min(amountPer, remaining);
                if (toExtract <= 0L) {
                    toExtract = remaining;
                }
                long extracted = provider.extractEnergy(toExtract, false);
                remaining -= extracted;
                providers.computeIfPresent(provider, (p, cap) -> cap - extracted);
            }
            return;
        }
        long remaining = amount;
        ArrayList<Map.Entry<IEnergyProvider, Long>> providerList = new ArrayList<Map.Entry<IEnergyProvider, Long>>(providers.entrySet());
        for (Map.Entry entry : providerList) {
            if (remaining <= 0L) break;
            IEnergyProvider provider = (IEnergyProvider)entry.getKey();
            long capacity = (Long)entry.getValue();
            if (capacity <= 0L) continue;
            if (totalCapacity <= 0L) break;
            double share = (double)capacity / (double)totalCapacity;
            long toExtract = (long)((double)amount * share);
            toExtract = Math.min(remaining, toExtract);
            if ((toExtract = Math.min(capacity, toExtract)) <= 0L) continue;
            long extracted = provider.extractEnergy(toExtract, false);
            remaining -= extracted;
            totalCapacity -= extracted;
            entry.setValue(capacity - extracted);
        }
        if (remaining > 0L) {
            providerList.sort(Map.Entry.comparingByValue().reversed());
            for (Map.Entry entry : providerList) {
                if (remaining <= 0L) break;
                long capacity = (Long)entry.getValue();
                if (capacity <= 0L) continue;
                long toExtract = Math.min(remaining, capacity);
                long extracted = ((IEnergyProvider)entry.getKey()).extractEnergy(toExtract, false);
                remaining -= extracted;
                entry.setValue(capacity - extracted);
            }
        }
    }

    public void addNode(EnergyNode node) {
        if (this.nodes.add(node)) {
            node.setNetwork(this);
        }
    }

    public void removeNode(EnergyNode node) {
        if (!this.nodes.remove(node)) {
            return;
        }
        node.setNetwork(null);
        if (this.nodes.size() < 2) {
            for (EnergyNode remainingNode : this.nodes) {
                remainingNode.setNetwork(null);
            }
            this.nodes.clear();
            this.manager.removeNetwork(this);
        } else {
            this.verifyConnectivity();
        }
    }

    private void verifyConnectivity() {
        if (this.nodes.isEmpty()) {
            return;
        }
        HashSet<EnergyNode> allReachableNodes = new HashSet<EnergyNode>();
        LinkedList<EnergyNode> queue = new LinkedList<EnergyNode>();
        EnergyNode startNode = this.nodes.iterator().next();
        queue.add(startNode);
        allReachableNodes.add(startNode);
        while (!queue.isEmpty()) {
            EnergyNode current = (EnergyNode)queue.poll();
            for (Direction dir : Direction.values()) {
                EnergyNode neighbor = this.manager.getNode(current.getPos().m_121945_(dir));
                if (neighbor == null || !this.nodes.contains(neighbor) || !allReachableNodes.add(neighbor)) continue;
                queue.add(neighbor);
            }
        }
        if (allReachableNodes.size() < this.nodes.size()) {
            LOGGER.warn("[NETWORK] Network {} split detected! Rebuilding...", (Object)this.id);
            HashSet<EnergyNode> lostNodes = new HashSet<EnergyNode>(this.nodes);
            lostNodes.removeAll(allReachableNodes);
            this.nodes.removeAll(lostNodes);
            for (EnergyNode lostNode : lostNodes) {
                lostNode.setNetwork(null);
                this.manager.reAddNode(lostNode.getPos(), this);
            }
            if (this.nodes.size() < 2) {
                for (EnergyNode remainingNode : this.nodes) {
                    remainingNode.setNetwork(null);
                    this.manager.reAddNode(remainingNode.getPos(), this);
                }
                this.nodes.clear();
                this.manager.removeNetwork(this);
            }
        }
    }

    public void merge(EnergyNetwork other) {
        if (this == other) {
            return;
        }
        if (other.nodes.size() > this.nodes.size()) {
            other.merge(this);
            return;
        }
        for (EnergyNode node : other.nodes) {
            node.setNetwork(this);
            this.nodes.add(node);
        }
        other.nodes.clear();
        this.manager.removeNetwork(other);
    }

    public UUID getId() {
        return this.id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof EnergyNetwork)) return false;
        EnergyNetwork that = (EnergyNetwork)o;
        if (!this.id.equals(that.id)) return false;
        return true;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private static class BatteryInfo {
        final BlockPos pos;
        final IEnergyReceiver receiver;
        final IEnergyProvider provider;
        final int mode;

        BatteryInfo(BlockPos pos, IEnergyReceiver r, IEnergyProvider p, int mode) {
            this.pos = pos;
            this.receiver = r;
            this.provider = p;
            this.mode = mode;
        }

        boolean canInput() {
            return this.mode == 0 || this.mode == 1;
        }

        boolean canOutput() {
            return this.mode == 0 || this.mode == 2;
        }
    }
}

