/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.api.energy;

import com.google.common.collect.Sets;
import com.hbm_m.api.energy.EnergyNetwork;
import com.hbm_m.api.energy.EnergyNode;
import com.hbm_m.capability.ModCapabilities;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public class EnergyNetworkManager
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String DATA_NAME = "hbm_modernized_energy_networks";
    private final ServerLevel level;
    private final Long2ObjectMap<EnergyNode> allNodes = new Long2ObjectOpenHashMap();
    private final Set<EnergyNetwork> networks = Sets.newHashSet();

    public EnergyNetworkManager(ServerLevel level, CompoundTag nbt) {
        this(level);
        if (nbt.m_128441_("nodes")) {
            long[] nodePositions = nbt.m_128467_("nodes");
            LOGGER.info("[NETWORK] Loading {} nodes for dimension {}", (Object)nodePositions.length, (Object)level.m_46472_().m_135782_());
            for (long posLong : nodePositions) {
                BlockPos pos = BlockPos.m_122022_((long)posLong);
                this.allNodes.put(pos.m_121878_(), (Object)new EnergyNode(pos));
            }
        }
    }

    public EnergyNetworkManager(ServerLevel level) {
        this.level = level;
    }

    public static EnergyNetworkManager get(ServerLevel level) {
        return (EnergyNetworkManager)level.m_8895_().m_164861_(nbt -> new EnergyNetworkManager(level, (CompoundTag)nbt), () -> new EnergyNetworkManager(level), DATA_NAME);
    }

    public void rebuildAllNetworks() {
        LOGGER.info("[NETWORK] Starting full network rebuild for dimension {}...", (Object)this.level.m_46472_().m_135782_());
        this.networks.clear();
        for (EnergyNode node2 : this.allNodes.values()) {
            node2.setNetwork(null);
        }
        int totalNodes = this.allNodes.size();
        this.allNodes.values().removeIf(node -> !node.isValid(this.level));
        int validNodes = this.allNodes.size();
        LOGGER.info("[NETWORK] Pruned node list: {} total -> {} valid.", (Object)totalNodes, (Object)validNodes);
        HashSet<EnergyNode> processedNodes = new HashSet<EnergyNode>();
        for (EnergyNode startNode : this.allNodes.values()) {
            if (processedNodes.contains(startNode)) continue;
            EnergyNetwork newNetwork = new EnergyNetwork(this);
            this.networks.add(newNetwork);
            LinkedList<EnergyNode> queue = new LinkedList<EnergyNode>();
            queue.add(startNode);
            processedNodes.add(startNode);
            while (!queue.isEmpty()) {
                EnergyNode currentNode = (EnergyNode)queue.poll();
                newNetwork.addNode(currentNode);
                for (Direction dir : Direction.values()) {
                    EnergyNode neighbor = (EnergyNode)this.allNodes.get(currentNode.getPos().m_121945_(dir).m_121878_());
                    if (neighbor == null || processedNodes.contains(neighbor)) continue;
                    processedNodes.add(neighbor);
                    queue.add(neighbor);
                }
            }
        }
        LOGGER.info("[NETWORK] Rebuild completed. Found {} networks.", (Object)this.networks.size());
        this.m_77762_();
    }

    public void tick() {
        new HashSet<EnergyNetwork>(this.networks).forEach(network -> network.tick(this.level));
    }

    public void addNode(BlockPos pos) {
        this.addNode(pos, null);
    }

    private void addNode(BlockPos pos, @Nullable EnergyNetwork networkToAvoid) {
        EnergyNode existingNode;
        long posLong = pos.m_121878_();
        if (this.allNodes.containsKey(posLong) && (existingNode = (EnergyNode)this.allNodes.get(posLong)) != null && existingNode.getNetwork() != null) {
            return;
        }
        EnergyNode newNode = new EnergyNode(pos);
        if (!newNode.isValid(this.level)) {
            this.allNodes.remove(posLong);
            return;
        }
        this.allNodes.put(posLong, (Object)newNode);
        HashSet<EnergyNetwork> adjacentNetworks = new HashSet<EnergyNetwork>();
        for (Direction dir : Direction.values()) {
            BlockEntity be;
            BlockPos neighborPos = pos.m_121945_(dir);
            long neighborLong = neighborPos.m_121878_();
            EnergyNode neighbor = (EnergyNode)this.allNodes.get(neighborLong);
            if (neighbor == null && this.level.m_46749_(neighborPos) && (be = this.level.m_7702_(neighborPos)) != null) {
                boolean isEnergyBlock;
                boolean bl = isEnergyBlock = be.getCapability(ModCapabilities.HBM_ENERGY_PROVIDER).isPresent() || be.getCapability(ModCapabilities.HBM_ENERGY_RECEIVER).isPresent() || be.getCapability(ModCapabilities.HBM_ENERGY_CONNECTOR).isPresent();
                if (isEnergyBlock) {
                    this.addNode(neighborPos);
                    neighbor = (EnergyNode)this.allNodes.get(neighborLong);
                }
            }
            if (neighbor == null || neighbor.getNetwork() == null || neighbor.getNetwork() == networkToAvoid) continue;
            adjacentNetworks.add(neighbor.getNetwork());
        }
        if (adjacentNetworks.isEmpty()) {
            EnergyNetwork newNetwork = new EnergyNetwork(this);
            this.networks.add(newNetwork);
            newNetwork.addNode(newNode);
        } else {
            Iterator it = adjacentNetworks.iterator();
            EnergyNetwork main = (EnergyNetwork)it.next();
            main.addNode(newNode);
            while (it.hasNext()) {
                main.merge((EnergyNetwork)it.next());
            }
        }
        this.m_77762_();
    }

    public void removeNode(BlockPos pos) {
        long posLong = pos.m_121878_();
        EnergyNode node = (EnergyNode)this.allNodes.remove(posLong);
        if (node == null) {
            return;
        }
        EnergyNetwork network = node.getNetwork();
        if (network != null) {
            network.removeNode(node);
            LOGGER.debug("[NETWORK] Removed node {} from network {}", (Object)pos, (Object)network.getId());
        }
        this.m_77762_();
    }

    void reAddNode(BlockPos pos, @Nullable EnergyNetwork networkToAvoid) {
        EnergyNode node = (EnergyNode)this.allNodes.get(pos.m_121878_());
        if (node != null) {
            node.setNetwork(null);
        }
        this.allNodes.remove(pos.m_121878_());
        this.addNode(pos, networkToAvoid);
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        long[] nodePositions = this.allNodes.keySet().toLongArray();
        nbt.m_128388_("nodes", nodePositions);
        return nbt;
    }

    public boolean hasNode(BlockPos pos) {
        return this.allNodes.containsKey(pos.m_121878_());
    }

    public EnergyNode getNode(BlockPos pos) {
        return (EnergyNode)this.allNodes.get(pos.m_121878_());
    }

    void addNetwork(EnergyNetwork network) {
        this.networks.add(network);
    }

    void removeNetwork(EnergyNetwork network) {
        this.networks.remove(network);
    }
}

