/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.api.energy;

import com.hbm_m.api.energy.ConverterBlockEntity;
import net.minecraftforge.energy.IEnergyStorage;

public class HbmForgeWrapper
implements IEnergyStorage {
    private final ConverterBlockEntity tile;

    public HbmForgeWrapper(ConverterBlockEntity tile) {
        this.tile = tile;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        long space = this.tile.getMaxEnergyStored() - this.tile.getEnergyStored();
        long amount = Math.min((long)maxReceive, space);
        if (!simulate) {
            this.tile.setEnergyStored(this.tile.getEnergyStored() + amount);
        }
        return (int)Math.min(amount, Integer.MAX_VALUE);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        long amount = Math.min((long)maxExtract, this.tile.getEnergyStored());
        if (!simulate) {
            this.tile.setEnergyStored(this.tile.getEnergyStored() - amount);
        }
        return (int)Math.min(amount, Integer.MAX_VALUE);
    }

    public int getEnergyStored() {
        return (int)Math.min(this.tile.getEnergyStored(), Integer.MAX_VALUE);
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(this.tile.getMaxEnergyStored(), Integer.MAX_VALUE);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

