/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.api.energy;

import com.hbm_m.api.energy.IEnergyConnector;
import com.hbm_m.api.energy.IEnergyProvider;
import com.hbm_m.api.energy.IEnergyReceiver;
import net.minecraftforge.energy.IEnergyStorage;

public class LongEnergyWrapper
implements IEnergyStorage {
    private final IEnergyConnector handler;
    private final BitMode mode;

    public LongEnergyWrapper(IEnergyConnector handler, BitMode mode) {
        this.handler = handler;
        this.mode = mode;
    }

    private static int getLow(long val) {
        return (int)(val & 0xFFFFFFFFL);
    }

    private static int getHigh(long val) {
        return (int)(val >> 32);
    }

    private static long pack(int high, int low) {
        return (long)high << 32 | (long)low & 0xFFFFFFFFL;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        IEnergyReceiver receiver;
        IEnergyConnector iEnergyConnector = this.handler;
        if (!(iEnergyConnector instanceof IEnergyReceiver) || !(receiver = (IEnergyReceiver)iEnergyConnector).canReceive()) {
            return 0;
        }
        long currentEnergy = receiver.getEnergyStored();
        long maxEnergy = receiver.getMaxEnergyStored();
        if (this.mode == BitMode.LOW) {
            long toReceive = Math.min((long)maxReceive, maxEnergy - currentEnergy);
            long received = receiver.receiveEnergy(toReceive, simulate);
            return (int)Math.min(received, Integer.MAX_VALUE);
        }
        int currentHigh = LongEnergyWrapper.getHigh(currentEnergy);
        int maxHigh = LongEnergyWrapper.getHigh(maxEnergy);
        int currentLow = LongEnergyWrapper.getLow(currentEnergy);
        int canReceive = Math.min(maxReceive, maxHigh - currentHigh);
        if (canReceive <= 0) {
            return 0;
        }
        if (!simulate) {
            long newEnergy = LongEnergyWrapper.pack(currentHigh + canReceive, currentLow);
            receiver.setEnergyStored(newEnergy);
        }
        return canReceive;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        IEnergyProvider provider;
        IEnergyConnector iEnergyConnector = this.handler;
        if (!(iEnergyConnector instanceof IEnergyProvider) || !(provider = (IEnergyProvider)iEnergyConnector).canExtract()) {
            return 0;
        }
        long currentEnergy = provider.getEnergyStored();
        if (this.mode == BitMode.LOW) {
            long toExtract = Math.min((long)maxExtract, currentEnergy);
            long extracted = provider.extractEnergy(toExtract, simulate);
            return (int)Math.min(extracted, Integer.MAX_VALUE);
        }
        int currentHigh = LongEnergyWrapper.getHigh(currentEnergy);
        int currentLow = LongEnergyWrapper.getLow(currentEnergy);
        int canExtract = Math.min(maxExtract, currentHigh);
        if (canExtract <= 0) {
            return 0;
        }
        if (!simulate) {
            long newEnergy = LongEnergyWrapper.pack(currentHigh - canExtract, currentLow);
            provider.setEnergyStored(newEnergy);
        }
        return canExtract;
    }

    public int getEnergyStored() {
        long energy = 0L;
        IEnergyConnector iEnergyConnector = this.handler;
        if (iEnergyConnector instanceof IEnergyProvider) {
            IEnergyProvider p = (IEnergyProvider)iEnergyConnector;
            energy = p.getEnergyStored();
        } else {
            iEnergyConnector = this.handler;
            if (iEnergyConnector instanceof IEnergyReceiver) {
                IEnergyReceiver r = (IEnergyReceiver)iEnergyConnector;
                energy = r.getEnergyStored();
            }
        }
        return this.mode == BitMode.LOW ? LongEnergyWrapper.getLow(energy) : LongEnergyWrapper.getHigh(energy);
    }

    public int getMaxEnergyStored() {
        long maxEnergy = 0L;
        IEnergyConnector iEnergyConnector = this.handler;
        if (iEnergyConnector instanceof IEnergyProvider) {
            IEnergyProvider p = (IEnergyProvider)iEnergyConnector;
            maxEnergy = p.getMaxEnergyStored();
        } else {
            iEnergyConnector = this.handler;
            if (iEnergyConnector instanceof IEnergyReceiver) {
                IEnergyReceiver r = (IEnergyReceiver)iEnergyConnector;
                maxEnergy = r.getMaxEnergyStored();
            }
        }
        return this.mode == BitMode.LOW ? LongEnergyWrapper.getLow(maxEnergy) : LongEnergyWrapper.getHigh(maxEnergy);
    }

    public boolean canExtract() {
        IEnergyProvider p;
        IEnergyConnector iEnergyConnector = this.handler;
        return iEnergyConnector instanceof IEnergyProvider && (p = (IEnergyProvider)iEnergyConnector).canExtract();
    }

    public boolean canReceive() {
        IEnergyReceiver r;
        IEnergyConnector iEnergyConnector = this.handler;
        return iEnergyConnector instanceof IEnergyReceiver && (r = (IEnergyReceiver)iEnergyConnector).canReceive();
    }

    public static enum BitMode {
        LOW,
        HIGH;

    }
}

