/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.armormod.client;

import com.hbm_m.armormod.item.ItemArmorMod;
import com.hbm_m.armormod.util.ArmorModificationHelper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ArmorTooltipHandler {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.###");

    public static Optional<Component> getRadResistanceTooltip(ItemStack stack) {
        float absoluteProtection = ArmorModificationHelper.getTotalAbsoluteRadProtection(stack);
        if (absoluteProtection > 0.0f) {
            MutableComponent tooltipLine = Component.m_237110_((String)"tooltip.hbm_m.rad_protection.value", (Object[])new Object[]{DECIMAL_FORMAT.format(absoluteProtection)}).m_130940_(ChatFormatting.YELLOW);
            return Optional.of(tooltipLine);
        }
        return Optional.empty();
    }

    public static Optional<List<Component>> getModificationsTooltip(ItemStack stack, boolean isAlwaysVisible) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128425_("hbm_armor_mods", 10)) {
            return Optional.empty();
        }
        CompoundTag modsCompound = stack.m_41783_().m_128469_("hbm_armor_mods");
        if (modsCompound.m_128456_()) {
            return Optional.empty();
        }
        if (!isAlwaysVisible && !Screen.m_96638_()) {
            return Optional.of(List.of(Component.m_237115_((String)"tooltip.hbm_m.hold_shift_for_details").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC})));
        }
        ArrayList<MutableComponent> modsTooltipLines = new ArrayList<MutableComponent>();
        for (int i = 0; i < 9; ++i) {
            Item item;
            ItemStack modStack;
            String key = "mod_slot_" + i;
            if (!modsCompound.m_128441_(key) || (modStack = ItemStack.m_41712_((CompoundTag)modsCompound.m_128469_(key))).m_41619_() || !((item = modStack.m_41720_()) instanceof ItemArmorMod)) continue;
            ItemArmorMod mod = (ItemArmorMod)item;
            MutableComponent modLine = modStack.m_41786_().m_6881_().m_130940_(ChatFormatting.AQUA);
            List<Component> effectLines = mod.getEffectTooltipLines();
            if (!effectLines.isEmpty()) {
                MutableComponent effectsComponent = Component.m_237113_((String)" (").m_130940_(ChatFormatting.GRAY);
                boolean firstEffect = true;
                for (Component effectLine : effectLines) {
                    if (!firstEffect) {
                        effectsComponent.m_130946_(", ");
                    }
                    effectsComponent.m_7220_((Component)effectLine.m_6881_());
                    firstEffect = false;
                }
                effectsComponent.m_130946_(")");
                modLine.m_7220_((Component)effectsComponent);
            }
            modsTooltipLines.add(Component.m_237113_((String)"  ").m_7220_((Component)modLine));
        }
        if (!modsTooltipLines.isEmpty()) {
            ArrayList<MutableComponent> result = new ArrayList<MutableComponent>();
            result.add(Component.m_237115_((String)"tooltip.hbm_m.mods").m_130940_(ChatFormatting.GOLD));
            result.addAll(modsTooltipLines);
            result.add(Component.m_237119_());
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

