/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.armormod.util;

import com.google.common.collect.Multimap;
import com.hbm_m.armormod.item.ItemArmorMod;
import com.hbm_m.armormod.item.ItemModRadProtection;
import com.hbm_m.datagen.ModItemTagProvider;
import com.hbm_m.hazard.HazardSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ArmorModificationHelper {
    public static final String MOD_COMPOUND_KEY = "hbm_armor_mods";
    public static final String MOD_SLOT_KEY_PREFIX = "mod_slot_";
    public static final String MODIFIER_MARKER_KEY = "hbm_mod_attribute";
    public static final Map<Integer, UUID> MODIFIER_UUIDS = Map.of(0, UUID.fromString("8d6e5c77-133e-4056-9c80-a9e42a1a0b65"), 1, UUID.fromString("b1b7ee0e-1d14-4400-8037-f7f2e02f21ca"), 2, UUID.fromString("30b50d2a-4858-4e5b-88d4-3e3612224238"), 3, UUID.fromString("426ee0d0-7587-4697-aaef-4772ab202e78"));

    public static void loadModsIntoTable(ItemStack armorStack, IItemHandler tableInventory) {
        for (int i = 0; i < tableInventory.getSlots(); ++i) {
            tableInventory.extractItem(i, tableInventory.getStackInSlot(i).m_41613_(), false);
        }
        if (!armorStack.m_41782_() || !armorStack.m_41783_().m_128441_(MOD_COMPOUND_KEY)) {
            return;
        }
        CompoundTag mods = armorStack.m_41783_().m_128469_(MOD_COMPOUND_KEY);
        for (int i = 0; i < 9; ++i) {
            String key = MOD_SLOT_KEY_PREFIX + i;
            if (!mods.m_128441_(key)) continue;
            ItemStack modStack = ItemStack.m_41712_((CompoundTag)mods.m_128469_(key));
            tableInventory.insertItem(i, modStack, false);
        }
    }

    public static void saveTableToArmor(ItemStack armorStack, IItemHandler tableInventory, Player player) {
        Item item = armorStack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return;
        }
        ArmorItem armorItem = (ArmorItem)item;
        CompoundTag mainTag = armorStack.m_41784_();
        CompoundTag modsCompound = new CompoundTag();
        for (int i = 0; i < 9; ++i) {
            ItemStack modStack = tableInventory.getStackInSlot(i);
            if (modStack.m_41619_()) continue;
            modsCompound.m_128365_(MOD_SLOT_KEY_PREFIX + i, (Tag)modStack.m_41739_(new CompoundTag()));
        }
        if (modsCompound.m_128456_()) {
            mainTag.m_128473_(MOD_COMPOUND_KEY);
        } else {
            mainTag.m_128365_(MOD_COMPOUND_KEY, (Tag)modsCompound);
        }
        ListTag preservedModifiers = new ListTag();
        if (mainTag.m_128425_("AttributeModifiers", 9)) {
            ListTag currentModifiers = mainTag.m_128437_("AttributeModifiers", 10);
            for (Tag tag : currentModifiers) {
                CompoundTag compoundTag;
                if (!(tag instanceof CompoundTag) || (compoundTag = (CompoundTag)tag).m_128471_(MODIFIER_MARKER_KEY)) continue;
                preservedModifiers.add((Object)tag.m_6426_());
            }
        } else {
            Multimap defaultModifiers = armorItem.m_7167_(armorItem.m_40402_());
            for (Map.Entry entry : defaultModifiers.entries()) {
                CompoundTag modifierTag = ((AttributeModifier)entry.getValue()).m_22219_();
                modifierTag.m_128359_("AttributeName", ForgeRegistries.ATTRIBUTES.getKey((Object)((Attribute)entry.getKey())).toString());
                modifierTag.m_128359_("Slot", armorItem.m_40402_().m_20751_());
                preservedModifiers.add((Object)modifierTag);
            }
        }
        for (int i = 0; i < 9; ++i) {
            Multimap<Attribute, AttributeModifier> modModifiers;
            boolean isCompatible;
            ItemStack modStack = tableInventory.getStackInSlot(i);
            Item modifierTag = modStack.m_41720_();
            if (!(modifierTag instanceof ItemArmorMod)) continue;
            ItemArmorMod mod = (ItemArmorMod)modifierTag;
            switch (armorItem.m_266204_()) {
                case HELMET: {
                    boolean bl = modStack.m_204117_(ModItemTagProvider.REQUIRES_HELMET);
                    break;
                }
                case CHESTPLATE: {
                    boolean bl = modStack.m_204117_(ModItemTagProvider.REQUIRES_CHESTPLATE);
                    break;
                }
                case LEGGINGS: {
                    boolean bl = modStack.m_204117_(ModItemTagProvider.REQUIRES_LEGGINGS);
                    break;
                }
                case BOOTS: {
                    boolean bl = modStack.m_204117_(ModItemTagProvider.REQUIRES_BOOTS);
                    break;
                }
                default: {
                    boolean bl = isCompatible = false;
                }
            }
            if (!isCompatible || (modModifiers = mod.getModifiers(armorStack)) == null) continue;
            for (Map.Entry entry : modModifiers.entries()) {
                CompoundTag modifierTag2 = ((AttributeModifier)entry.getValue()).m_22219_();
                modifierTag2.m_128359_("AttributeName", ForgeRegistries.ATTRIBUTES.getKey((Object)((Attribute)entry.getKey())).toString());
                modifierTag2.m_128359_("Slot", armorItem.m_40402_().m_20751_());
                modifierTag2.m_128379_(MODIFIER_MARKER_KEY, true);
                preservedModifiers.add((Object)modifierTag2);
            }
        }
        mainTag.m_128365_("AttributeModifiers", (Tag)preservedModifiers);
        if (mainTag.m_128456_()) {
            armorStack.m_41751_(null);
        }
    }

    public static List<ItemStack> getModsFromArmor(ItemStack armorStack) {
        if (!armorStack.m_41782_() || !armorStack.m_41783_().m_128425_(MOD_COMPOUND_KEY, 10)) {
            return Collections.emptyList();
        }
        CompoundTag modsCompound = armorStack.m_41783_().m_128469_(MOD_COMPOUND_KEY);
        if (modsCompound.m_128456_()) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> modsList = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            ItemStack modStack;
            String key = MOD_SLOT_KEY_PREFIX + i;
            if (!modsCompound.m_128441_(key) || (modStack = ItemStack.m_41712_((CompoundTag)modsCompound.m_128469_(key))).m_41619_()) continue;
            modsList.add(modStack);
        }
        return modsList;
    }

    public static float getTotalAbsoluteRadProtection(ItemStack armorStack) {
        if (!(armorStack.m_41720_() instanceof ArmorItem)) {
            return 0.0f;
        }
        float totalProtection = HazardSystem.getArmorProtection(armorStack);
        List<ItemStack> mods = ArmorModificationHelper.getModsFromArmor(armorStack);
        for (ItemStack modStack : mods) {
            Item item = modStack.m_41720_();
            if (!(item instanceof ItemModRadProtection)) continue;
            ItemModRadProtection radMod = (ItemModRadProtection)item;
            totalProtection += radMod.getProtectionValue();
        }
        return totalProtection;
    }

    public static float convertAbsoluteToPercent(float absoluteValue) {
        if (absoluteValue <= 0.0f) {
            return 0.0f;
        }
        return (float)(1.0 - Math.exp(-2.35 * (double)absoluteValue));
    }
}

