/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class DecoSteelBlock
extends Block {
    public static final BooleanProperty CONNECTED_NORTH = BooleanProperty.m_61465_((String)"connected_north");
    public static final BooleanProperty CONNECTED_SOUTH = BooleanProperty.m_61465_((String)"connected_south");
    public static final BooleanProperty CONNECTED_EAST = BooleanProperty.m_61465_((String)"connected_east");
    public static final BooleanProperty CONNECTED_WEST = BooleanProperty.m_61465_((String)"connected_west");
    public static final DirectionProperty SIDE_FACING = DirectionProperty.m_61546_((String)"side_facing", (Predicate)Direction.Plane.HORIZONTAL);

    public DecoSteelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CONNECTED_NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTED_SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTED_EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTED_WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SIDE_FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CONNECTED_NORTH, CONNECTED_SOUTH, CONNECTED_EAST, CONNECTED_WEST, SIDE_FACING});
    }

    private boolean isSameBlock(BlockState other) {
        return other != null && other.m_60734_() == this;
    }

    private boolean isSpecialMiddleBlock(BlockState state) {
        return false;
    }

    private boolean checkMiddleBlock(LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        int mz;
        int my;
        int mx = (pos1.m_123341_() + pos2.m_123341_()) / 2;
        BlockPos middlePos = new BlockPos(mx, my = (pos1.m_123342_() + pos2.m_123342_()) / 2, mz = (pos1.m_123343_() + pos2.m_123343_()) / 2);
        BlockState middleState = world.m_8055_(middlePos);
        return middleState != null && this.isSpecialMiddleBlock(middleState);
    }

    private boolean isConnected(LevelAccessor world, BlockPos currentPos, BlockPos checkPos) {
        BlockState other = world.m_8055_(checkPos);
        if (this.isSameBlock(other)) {
            return true;
        }
        if (this.checkMiddleBlock(world, currentPos, checkPos)) {
            return this.isSameBlock(other);
        }
        return false;
    }

    private Direction determineSideFacing(BlockState state) {
        int connections = 0;
        if (((Boolean)state.m_61143_((Property)CONNECTED_NORTH)).booleanValue()) {
            ++connections;
        }
        if (((Boolean)state.m_61143_((Property)CONNECTED_EAST)).booleanValue()) {
            ++connections;
        }
        if (((Boolean)state.m_61143_((Property)CONNECTED_SOUTH)).booleanValue()) {
            ++connections;
        }
        if (((Boolean)state.m_61143_((Property)CONNECTED_WEST)).booleanValue()) {
            ++connections;
        }
        if (connections <= 1) {
            if (((Boolean)state.m_61143_((Property)CONNECTED_NORTH)).booleanValue()) {
                return Direction.NORTH;
            }
            if (((Boolean)state.m_61143_((Property)CONNECTED_EAST)).booleanValue()) {
                return Direction.EAST;
            }
            if (((Boolean)state.m_61143_((Property)CONNECTED_SOUTH)).booleanValue()) {
                return Direction.SOUTH;
            }
            if (((Boolean)state.m_61143_((Property)CONNECTED_WEST)).booleanValue()) {
                return Direction.WEST;
            }
            return Direction.NORTH;
        }
        if (((Boolean)state.m_61143_((Property)CONNECTED_NORTH)).booleanValue()) {
            return Direction.NORTH;
        }
        return Direction.EAST;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CONNECTED_NORTH, (Comparable)Boolean.valueOf(this.isConnected((LevelAccessor)level, pos, pos.m_122012_())))).m_61124_((Property)CONNECTED_SOUTH, (Comparable)Boolean.valueOf(this.isConnected((LevelAccessor)level, pos, pos.m_122019_())))).m_61124_((Property)CONNECTED_EAST, (Comparable)Boolean.valueOf(this.isConnected((LevelAccessor)level, pos, pos.m_122029_())))).m_61124_((Property)CONNECTED_WEST, (Comparable)Boolean.valueOf(this.isConnected((LevelAccessor)level, pos, pos.m_122024_())));
        return (BlockState)state.m_61124_((Property)SIDE_FACING, (Comparable)this.determineSideFacing(state));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        boolean connected = this.isConnected(world, currentPos, facingPos);
        switch (facing) {
            case NORTH: {
                state = (BlockState)state.m_61124_((Property)CONNECTED_NORTH, (Comparable)Boolean.valueOf(connected));
                break;
            }
            case SOUTH: {
                state = (BlockState)state.m_61124_((Property)CONNECTED_SOUTH, (Comparable)Boolean.valueOf(connected));
                break;
            }
            case EAST: {
                state = (BlockState)state.m_61124_((Property)CONNECTED_EAST, (Comparable)Boolean.valueOf(connected));
                break;
            }
            case WEST: {
                state = (BlockState)state.m_61124_((Property)CONNECTED_WEST, (Comparable)Boolean.valueOf(connected));
            }
        }
        state = (BlockState)state.m_61124_((Property)SIDE_FACING, (Comparable)this.determineSideFacing(state));
        return state;
    }
}

