/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.DoorBlockEntity;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.multiblock.IMultiblockController;
import com.hbm_m.multiblock.MultiblockStructureHelper;
import com.hbm_m.multiblock.PartRole;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DoorBlock
extends BaseEntityBlock
implements IMultiblockController {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<PartRole> PART_ROLE = EnumProperty.m_61587_((String)"part_role", PartRole.class);
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    private final Map<Direction, VoxelShape> shapeCache = new EnumMap<Direction, VoxelShape>(Direction.class);
    private final String doorDeclId;
    private final MultiblockStructureHelper structureHelper;

    public DoorBlock(BlockBehaviour.Properties properties, String doorDeclId) {
        super(properties);
        this.doorDeclId = doorDeclId;
        Map<BlockPos, Supplier<BlockState>> structureMap = DoorBlock.createStructureForDoor(doorDeclId);
        this.structureHelper = new MultiblockStructureHelper(structureMap, () -> ((Block)ModBlocks.UNIVERSAL_MACHINE_PART.get()).m_49966_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART_ROLE, (Comparable)((Object)PartRole.DEFAULT))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    private static Map<BlockPos, Supplier<BlockState>> createStructureForDoor(String doorDeclId) {
        HashMap<BlockPos, Supplier<BlockState>> structureMap = new HashMap<BlockPos, Supplier<BlockState>>();
        Supplier<BlockState> phantomSupplier = () -> ((Block)ModBlocks.UNIVERSAL_MACHINE_PART.get()).m_49966_();
        int[] dimensions = DoorBlock.getDoorDimensions(doorDeclId);
        int offsetX = dimensions[0];
        int offsetY = dimensions[1];
        int offsetZ = dimensions[2];
        int sizeX = dimensions[3];
        int sizeY = dimensions[4];
        int sizeZ = dimensions[5];
        for (int x = offsetX; x <= offsetX + sizeX; ++x) {
            for (int y = offsetY; y <= offsetY + sizeY; ++y) {
                for (int z = offsetZ; z <= offsetZ + sizeZ; ++z) {
                    structureMap.put(new BlockPos(x, y, z), phantomSupplier);
                }
            }
        }
        return structureMap;
    }

    public static int[] getDoorDimensions(String doorDeclId) {
        int[] nArray;
        switch (doorDeclId) {
            case "large_vehicle_door": {
                int[] nArray2 = new int[6];
                nArray2[0] = -3;
                nArray2[1] = 0;
                nArray2[2] = 0;
                nArray2[3] = 6;
                nArray2[4] = 5;
                nArray = nArray2;
                nArray2[5] = 0;
                break;
            }
            case "round_airlock_door": {
                int[] nArray3 = new int[6];
                nArray3[0] = -1;
                nArray3[1] = 0;
                nArray3[2] = 0;
                nArray3[3] = 3;
                nArray3[4] = 3;
                nArray = nArray3;
                nArray3[5] = 0;
                break;
            }
            case "transition_seal": {
                int[] nArray4 = new int[6];
                nArray4[0] = -12;
                nArray4[1] = 0;
                nArray4[2] = 0;
                nArray4[3] = 25;
                nArray4[4] = 23;
                nArray = nArray4;
                nArray4[5] = 0;
                break;
            }
            case "fire_door": {
                int[] nArray5 = new int[6];
                nArray5[0] = -1;
                nArray5[1] = 0;
                nArray5[2] = 0;
                nArray5[3] = 3;
                nArray5[4] = 2;
                nArray = nArray5;
                nArray5[5] = 0;
                break;
            }
            case "sliding_blast_door": {
                int[] nArray6 = new int[6];
                nArray6[0] = -3;
                nArray6[1] = 0;
                nArray6[2] = 0;
                nArray6[3] = 6;
                nArray6[4] = 3;
                nArray = nArray6;
                nArray6[5] = 0;
                break;
            }
            case "sliding_seal_door": {
                int[] nArray7 = new int[6];
                nArray7[0] = 0;
                nArray7[1] = 0;
                nArray7[2] = 0;
                nArray7[3] = 0;
                nArray7[4] = 1;
                nArray = nArray7;
                nArray7[5] = 0;
                break;
            }
            case "secure_access_door": {
                int[] nArray8 = new int[6];
                nArray8[0] = -2;
                nArray8[1] = 0;
                nArray8[2] = 0;
                nArray8[3] = 4;
                nArray8[4] = 4;
                nArray = nArray8;
                nArray8[5] = 0;
                break;
            }
            case "qe_sliding_door": {
                int[] nArray9 = new int[6];
                nArray9[0] = 0;
                nArray9[1] = 0;
                nArray9[2] = 0;
                nArray9[3] = 1;
                nArray9[4] = 1;
                nArray = nArray9;
                nArray9[5] = 0;
                break;
            }
            case "qe_containment_door": {
                int[] nArray10 = new int[6];
                nArray10[0] = -1;
                nArray10[1] = 0;
                nArray10[2] = 0;
                nArray10[3] = 2;
                nArray10[4] = 2;
                nArray = nArray10;
                nArray10[5] = 0;
                break;
            }
            case "water_door": {
                int[] nArray11 = new int[6];
                nArray11[0] = -1;
                nArray11[1] = 0;
                nArray11[2] = 0;
                nArray11[3] = 2;
                nArray11[4] = 2;
                nArray = nArray11;
                nArray11[5] = 0;
                break;
            }
            case "silo_hatch": {
                int[] nArray12 = new int[6];
                nArray12[0] = -2;
                nArray12[1] = 0;
                nArray12[2] = -2;
                nArray12[3] = 4;
                nArray12[4] = 0;
                nArray = nArray12;
                nArray12[5] = 4;
                break;
            }
            case "silo_hatch_large": {
                int[] nArray13 = new int[6];
                nArray13[0] = -3;
                nArray13[1] = 0;
                nArray13[2] = -3;
                nArray13[3] = 6;
                nArray13[4] = 0;
                nArray = nArray13;
                nArray13[5] = 6;
                break;
            }
            default: {
                int[] nArray14 = new int[6];
                nArray14[0] = 0;
                nArray14[1] = 0;
                nArray14[2] = 0;
                nArray14[3] = 0;
                nArray14[4] = 1;
                nArray = nArray14;
                nArray14[5] = 0;
            }
        }
        return nArray;
    }

    @Override
    public MultiblockStructureHelper getStructureHelper() {
        return this.structureHelper;
    }

    @Override
    public PartRole getPartRole(BlockPos localOffset) {
        return PartRole.DEFAULT;
    }

    public String getDoorDeclId() {
        return this.doorDeclId;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DoorBlockEntity(pos, state, this.doorDeclId);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.f_46443_) {
            return null;
        }
        return DoorBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.DOOR_ENTITY.get()), (world, pos, blockState, blockEntity) -> DoorBlockEntity.serverTick(world, pos, blockState, blockEntity));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        DoorBlockEntity doorBE;
        DoorBlockEntity controller;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof DoorBlockEntity && (controller = (doorBE = (DoorBlockEntity)be).getController()) != null) {
            if (controller.isLocked()) {
                player.m_5661_((Component)Component.m_237115_((String)"door.locked"), true);
                return InteractionResult.FAIL;
            }
            if (controller.isMoving()) {
                return InteractionResult.CONSUME;
            }
            controller.toggle();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapeCache.computeIfAbsent((Direction)pState.m_61143_((Property)FACING), facing -> this.getStructureHelper().generateShapeFromParts((Direction)facing));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PART_ROLE, OPEN});
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.f_46443_ && !oldState.m_60713_((Block)this)) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            this.structureHelper.placeStructure(level, pos, facing, this);
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof DoorBlockEntity) {
                DoorBlockEntity doorBE = (DoorBlockEntity)be;
                doorBE.setControllerPos(pos);
                doorBE.onStructureFormed();
            }
        }
        super.m_6807_(state, level, pos, oldState, isMoving);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_()) && !level.f_46443_) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            this.structureHelper.destroyStructure(level, pos, facing);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }
}

