/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block;

import com.hbm_m.armormod.util.ArmorModificationHelper;
import com.hbm_m.block.entity.GeigerCounterBlockEntity;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.network.ModPacketHandler;
import com.hbm_m.network.sounds.GeigerSoundPacket;
import com.hbm_m.radiation.PlayerHandler;
import com.hbm_m.sound.ModSounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;

public class GeigerCounterBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public GeigerCounterBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(@Nonnull BlockState pState, @Nonnull BlockGetter pLevel, @Nonnull BlockPos pPos, @Nonnull CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pPos, @Nonnull BlockState pState) {
        return new GeigerCounterBlockEntity(pPos, pState);
    }

    public InteractionResult m_6227_(@Nonnull BlockState pState, @Nonnull Level pLevel, @Nonnull BlockPos pPos, @Nonnull Player pPlayer, @Nonnull InteractionHand pHand, @Nonnull BlockHitResult pHit) {
        if (!pLevel.m_5776_()) {
            SoundEvent soundEvent;
            float chunkRad = 0.0f;
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof GeigerCounterBlockEntity) {
                GeigerCounterBlockEntity geiger = (GeigerCounterBlockEntity)blockEntity;
                chunkRad = geiger.getLastMeasuredRads();
            }
            float invRad = PlayerHandler.getInventoryRadiation(pPlayer);
            float totalEnvironmentRad = chunkRad + invRad;
            float playerRads = PlayerHandler.getPlayerRads(pPlayer);
            float totalAbsoluteProtection = 0.0f;
            for (ItemStack armorStack : pPlayer.m_6168_()) {
                totalAbsoluteProtection += ArmorModificationHelper.getTotalAbsoluteRadProtection(armorStack);
            }
            float protectionPercent = ArmorModificationHelper.convertAbsoluteToPercent(totalAbsoluteProtection);
            String chunkRadStr = GeigerCounterBlock.getRadColor(chunkRad) + String.format("%.1f RAD/s", Float.valueOf(chunkRad));
            String envRadStr = GeigerCounterBlock.getRadColor(totalEnvironmentRad) + String.format("%.1f RAD/s\n", Float.valueOf(totalEnvironmentRad));
            String playerRadStr = GeigerCounterBlock.getRadColor(playerRads) + String.format("%.1f RAD", Float.valueOf(playerRads));
            String protectionPercentStr = String.format("%.2f%%", Float.valueOf(protectionPercent * 100.0f));
            String protectionAbsoluteStr = String.format("%.3f", Float.valueOf(totalAbsoluteProtection));
            String titleString = "\n\u00a76===== \u2622 " + Component.m_237115_((String)"item.hbm_m.meter.geiger_counter.name").getString() + " \u2622 =====\n";
            MutableComponent message = Component.m_237110_((String)"item.hbm_m.meter.title_format", (Object[])new Object[]{titleString});
            message.m_7220_((Component)Component.m_237110_((String)"item.hbm_m.meter.chunk_rads", (Object[])new Object[]{chunkRadStr}));
            message.m_7220_((Component)Component.m_237110_((String)"item.hbm_m.meter.env_rads", (Object[])new Object[]{envRadStr}));
            message.m_7220_((Component)Component.m_237110_((String)"item.hbm_m.meter.player_rads", (Object[])new Object[]{playerRadStr}));
            message.m_7220_((Component)Component.m_237110_((String)"item.hbm_m.meter.protection", (Object[])new Object[]{protectionPercentStr, protectionAbsoluteStr}));
            pPlayer.m_213846_((Component)message);
            if (ModSounds.TOOL_TECH_BOOP.isPresent() && (soundEvent = (SoundEvent)ModSounds.TOOL_TECH_BOOP.get()) != null) {
                ResourceLocation soundLocation = soundEvent.m_11660_();
                if (pPlayer instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                    ModPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new GeigerSoundPacket(soundLocation, 1.0f, 1.0f));
                }
            }
        }
        return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
    }

    private static String getRadColor(float rads) {
        if (rads < 0.01f) {
            return "\u00a7a";
        }
        if (rads < 1.0f) {
            return "\u00a7e";
        }
        if (rads < 10.0f) {
            return "\u00a76";
        }
        if (rads < 100.0f) {
            return "\u00a7c";
        }
        if (rads < 1000.0f) {
            return "\u00a74";
        }
        return "\u00a77";
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level pLevel, @Nonnull BlockState pState, @Nonnull BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        return GeigerCounterBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.GEIGER_COUNTER_BE.get()), (level, pos, state, blockEntity) -> blockEntity.tick(level, pos, state));
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public RenderShape m_7514_(@Nonnull BlockState pState) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(@Nonnull BlockState pState) {
        return true;
    }

    public int m_6782_(@Nonnull BlockState pState, @Nonnull Level pLevel, @Nonnull BlockPos pPos) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof GeigerCounterBlockEntity) {
            GeigerCounterBlockEntity geiger = (GeigerCounterBlockEntity)blockEntity;
            return Math.min(15, (int)Math.ceil(geiger.getLastMeasuredRads()));
        }
        return 0;
    }
}

