/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block;

import com.google.common.collect.ImmutableMap;
import com.hbm_m.api.energy.EnergyNetworkManager;
import com.hbm_m.block.SwitchBlock;
import com.hbm_m.block.entity.WireBlockEntity;
import com.hbm_m.block.machine.MachineBatteryBlock;
import com.hbm_m.capability.ModCapabilities;
import com.mojang.logging.LogUtils;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.slf4j.Logger;

public class WireBlock
extends BaseEntityBlock {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final Map<Direction, BooleanProperty> PROPERTIES_MAP = ImmutableMap.of((Object)Direction.NORTH, (Object)NORTH, (Object)Direction.SOUTH, (Object)SOUTH, (Object)Direction.WEST, (Object)WEST, (Object)Direction.EAST, (Object)EAST, (Object)Direction.UP, (Object)UP, (Object)Direction.DOWN, (Object)DOWN);
    private static final VoxelShape CORE_SHAPE = Block.m_49796_((double)5.5, (double)5.5, (double)5.5, (double)10.5, (double)10.5, (double)10.5);
    private static final Map<Direction, VoxelShape> ARM_SHAPES = ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)5.5, (double)5.5, (double)0.0, (double)10.5, (double)10.5, (double)5.5), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)5.5, (double)5.5, (double)10.5, (double)10.5, (double)10.5, (double)16.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)0.0, (double)5.5, (double)5.5, (double)5.5, (double)10.5, (double)10.5), (Object)Direction.EAST, (Object)Block.m_49796_((double)10.5, (double)5.5, (double)5.5, (double)16.0, (double)10.5, (double)10.5), (Object)Direction.UP, (Object)Block.m_49796_((double)5.5, (double)10.5, (double)5.5, (double)10.5, (double)16.0, (double)10.5), (Object)Direction.DOWN, (Object)Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)5.5, (double)10.5));

    public WireBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape shape = CORE_SHAPE;
        for (Direction dir : Direction.values()) {
            if (!((Boolean)pState.m_61143_((Property)PROPERTIES_MAP.get(dir))).booleanValue()) continue;
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)ARM_SHAPES.get(dir));
        }
        return shape;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getConnectionState((LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BooleanProperty property = WireBlock.getProperty(facing);
        boolean canConnect = this.canVisuallyConnectTo(level, facingPos, facing.m_122424_(), facingState);
        return (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(canConnect));
    }

    private BlockState getConnectionState(LevelAccessor level, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.canVisuallyConnectTo(level, pos.m_121945_(Direction.DOWN), Direction.UP, level.m_8055_(pos.m_121945_(Direction.DOWN)))))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.canVisuallyConnectTo(level, pos.m_121945_(Direction.UP), Direction.DOWN, level.m_8055_(pos.m_121945_(Direction.UP)))))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canVisuallyConnectTo(level, pos.m_121945_(Direction.NORTH), Direction.SOUTH, level.m_8055_(pos.m_121945_(Direction.NORTH)))))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canVisuallyConnectTo(level, pos.m_121945_(Direction.SOUTH), Direction.NORTH, level.m_8055_(pos.m_121945_(Direction.SOUTH)))))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canVisuallyConnectTo(level, pos.m_121945_(Direction.WEST), Direction.EAST, level.m_8055_(pos.m_121945_(Direction.WEST)))))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canVisuallyConnectTo(level, pos.m_121945_(Direction.EAST), Direction.WEST, level.m_8055_(pos.m_121945_(Direction.EAST)))));
    }

    private boolean canVisuallyConnectTo(LevelAccessor world, BlockPos neighborPos, Direction sideFromNeighbor, BlockState neighborState) {
        if (neighborState.m_60713_((Block)this)) {
            return true;
        }
        Block block = neighborState.m_60734_();
        if (block instanceof SwitchBlock || block instanceof MachineBatteryBlock) {
            return true;
        }
        BlockEntity be = world.m_7702_(neighborPos);
        if (be == null) {
            return false;
        }
        LazyOptional hbmCap = be.getCapability(ModCapabilities.HBM_ENERGY_CONNECTOR, sideFromNeighbor);
        if (hbmCap.isPresent()) {
            return hbmCap.resolve().map(c -> c.canConnectEnergy(sideFromNeighbor)).orElse(false);
        }
        if (be.getCapability(ModCapabilities.HBM_ENERGY_PROVIDER, sideFromNeighbor).isPresent()) {
            return true;
        }
        if (be.getCapability(ModCapabilities.HBM_ENERGY_RECEIVER, sideFromNeighbor).isPresent()) {
            return true;
        }
        return be.getCapability(ForgeCapabilities.ENERGY, sideFromNeighbor).isPresent();
    }

    public static BooleanProperty getProperty(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
        };
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.f_46443_ && !oldState.m_60713_((Block)this)) {
            LOGGER.info("[WIRE] Block placed at {}, adding to network immediately", (Object)pos);
            EnergyNetworkManager.get((ServerLevel)level).addNode(pos);
        }
        super.m_6807_(state, level, pos, oldState, isMoving);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.f_46443_ && !state.m_60713_(newState.m_60734_())) {
            LOGGER.info("[WIRE] Block removed at {}, removing from network", (Object)pos);
            EnergyNetworkManager.get((ServerLevel)level).removeNode(pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : (lvl, pos, st, be) -> {
            if (be instanceof WireBlockEntity) {
                WireBlockEntity wire = (WireBlockEntity)be;
                WireBlockEntity.tick(lvl, pos, st, wire);
            }
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WireBlockEntity(pos, state);
    }
}

