/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity;

import com.hbm_m.block.AnvilBlock;
import com.hbm_m.block.AnvilTier;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.item.ModBatteryItem;
import com.hbm_m.menu.AnvilMenu;
import com.hbm_m.recipe.AnvilRecipe;
import com.hbm_m.recipe.AnvilRecipeManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            if (slot == 0 || slot == 1) {
                AnvilBlockEntity.this.updateCrafting();
            }
            AnvilBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return slot != 2;
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    @Nullable
    private ResourceLocation selectedRecipeId;

    public AnvilBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ANVIL_BE.get(), pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        if (this.selectedRecipeId != null) {
            tag.m_128359_("SelectedRecipe", this.selectedRecipeId.toString());
        }
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.selectedRecipeId = tag.m_128441_("SelectedRecipe") ? ResourceLocation.parse((String)tag.m_128461_("SelectedRecipe")) : null;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.hbm_m.anvil_block");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new AnvilMenu(containerId, playerInventory, this);
    }

    public void openGui(ServerPlayer player) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)this, (BlockPos)this.f_58858_);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public AnvilTier getTier() {
        BlockState state = this.m_58900_();
        Block block = state.m_60734_();
        if (block instanceof AnvilBlock) {
            AnvilBlock block2 = (AnvilBlock)block;
            return block2.getTier();
        }
        return AnvilTier.IRON;
    }

    public Optional<ResourceLocation> getSelectedRecipeId() {
        return Optional.ofNullable(this.selectedRecipeId);
    }

    public void setSelectedRecipeId(@Nullable ResourceLocation recipeId) {
        if (recipeId == null && this.selectedRecipeId != null || recipeId != null && !recipeId.equals((Object)this.selectedRecipeId)) {
            this.selectedRecipeId = recipeId;
            this.setChangedAndNotify();
            this.updateCrafting();
        }
    }

    public void updateCrafting() {
        ItemStack currentOutput;
        ItemStack slotB;
        Level level = this.m_58904_();
        if (level == null) {
            return;
        }
        ItemStack slotA = this.itemHandler.getStackInSlot(0);
        Optional<AnvilRecipe> recipeOpt = this.resolveCombineRecipe(level, slotA, slotB = this.itemHandler.getStackInSlot(1));
        ItemStack result = recipeOpt.map(recipe -> recipe.m_8043_(level.m_9598_()).m_41777_()).orElse(ItemStack.f_41583_);
        if (!ItemStack.m_41728_((ItemStack)result, (ItemStack)(currentOutput = this.itemHandler.getStackInSlot(2)))) {
            this.itemHandler.setStackInSlot(2, result);
            this.setChangedAndNotify();
        }
    }

    private boolean canCraftRecipe(AnvilRecipe recipe, ItemStack slotA, ItemStack slotB) {
        if (!this.hasMatchingInputs(slotA, slotB, recipe)) {
            return false;
        }
        return recipe.canCraftOn(this.getTier());
    }

    private boolean matchesInput(ItemStack actual, ItemStack required) {
        if (required.m_41619_()) {
            return actual.m_41619_();
        }
        return this.matchesIngredient(actual, required) && actual.m_41613_() >= required.m_41613_();
    }

    private boolean hasMatchingInputs(ItemStack slotA, ItemStack slotB, AnvilRecipe recipe) {
        return this.resolveOrientation(slotA, slotB, recipe) != InputOrientation.NONE;
    }

    private InputOrientation resolveOrientation(ItemStack slotA, ItemStack slotB, AnvilRecipe recipe) {
        if (this.matchesPair(slotA, slotB, recipe.getInputA(), recipe.getInputB())) {
            return InputOrientation.NORMAL;
        }
        if (this.matchesPair(slotA, slotB, recipe.getInputB(), recipe.getInputA())) {
            return InputOrientation.SWAPPED;
        }
        return InputOrientation.NONE;
    }

    private InputOrientation chooseBestOrientation(ItemStack slotA, ItemStack slotB, AnvilRecipe recipe) {
        InputOrientation resolved = this.resolveOrientation(slotA, slotB, recipe);
        if (resolved != InputOrientation.NONE) {
            return resolved;
        }
        int normalConflicts = this.conflictValue(slotA, recipe.getInputA()) + this.conflictValue(slotB, recipe.getInputB());
        int swappedConflicts = this.conflictValue(slotA, recipe.getInputB()) + this.conflictValue(slotB, recipe.getInputA());
        return swappedConflicts < normalConflicts ? InputOrientation.SWAPPED : InputOrientation.NORMAL;
    }

    private int conflictValue(ItemStack actual, ItemStack required) {
        if (required.m_41619_()) {
            return actual.m_41619_() ? 0 : 1;
        }
        if (actual.m_41619_()) {
            return 1;
        }
        return this.matchesIngredient(actual, required) ? 0 : 1;
    }

    private boolean matchesPair(ItemStack first, ItemStack second, ItemStack requiredFirst, ItemStack requiredSecond) {
        return this.matchesInput(first, requiredFirst) && this.matchesInput(second, requiredSecond);
    }

    private int computeMaxCrafts(ItemStack slotA, ItemStack slotB, AnvilRecipe recipe, InputOrientation orientation) {
        ItemStack firstRequired = orientation == InputOrientation.NORMAL ? recipe.getInputA() : recipe.getInputB();
        ItemStack secondRequired = orientation == InputOrientation.NORMAL ? recipe.getInputB() : recipe.getInputA();
        return Math.min(this.computeMaxCrafts(slotA, firstRequired), this.computeMaxCrafts(slotB, secondRequired));
    }

    private void shrinkSlotInput(ItemStack slotA, ItemStack slotB, AnvilRecipe recipe, InputOrientation orientation, int craftCount) {
        boolean shouldConsumeSlotB;
        boolean isNormal = orientation == InputOrientation.NORMAL;
        ItemStack reqForSlotA = isNormal ? recipe.getInputA() : recipe.getInputB();
        ItemStack reqForSlotB = isNormal ? recipe.getInputB() : recipe.getInputA();
        boolean shouldConsumeSlotA = isNormal ? recipe.consumesA() : recipe.consumesB();
        boolean bl = shouldConsumeSlotB = isNormal ? recipe.consumesB() : recipe.consumesA();
        if (shouldConsumeSlotA) {
            slotA.m_41774_(reqForSlotA.m_41613_() * craftCount);
        }
        if (shouldConsumeSlotB) {
            slotB.m_41774_(reqForSlotB.m_41613_() * craftCount);
        }
    }

    private boolean populateInputsForOrientation(ServerPlayer player, AnvilRecipe recipe, InputOrientation orientation) {
        boolean changed = false;
        changed |= this.fillSlotFromPlayer(player, 0, this.requiredForSlot(recipe, orientation, 0));
        return changed |= this.fillSlotFromPlayer(player, 1, this.requiredForSlot(recipe, orientation, 1));
    }

    private ItemStack requiredForSlot(AnvilRecipe recipe, InputOrientation orientation, int slotIndex) {
        boolean normal;
        boolean bl = normal = orientation == InputOrientation.NORMAL;
        if (slotIndex == 0) {
            return normal ? recipe.getInputA() : recipe.getInputB();
        }
        return normal ? recipe.getInputB() : recipe.getInputA();
    }

    private boolean fillSlotFromPlayer(ServerPlayer player, int slotIndex, ItemStack required) {
        int have;
        if (required.m_41619_()) {
            ItemStack currentStack = this.itemHandler.getStackInSlot(slotIndex);
            if (currentStack.m_41619_()) {
                return false;
            }
            ItemStack toReturn = currentStack.m_41777_();
            this.itemHandler.setStackInSlot(slotIndex, ItemStack.f_41583_);
            if (!player.m_150109_().m_36054_(toReturn)) {
                player.m_36176_(toReturn, false);
            }
            return true;
        }
        ItemStack current = this.itemHandler.getStackInSlot(slotIndex);
        boolean changed = false;
        if (!current.m_41619_() && !this.matchesIngredient(current, required)) {
            ItemStack toReturn = current.m_41777_();
            this.itemHandler.setStackInSlot(slotIndex, ItemStack.f_41583_);
            if (!player.m_150109_().m_36054_(toReturn)) {
                player.m_36176_(toReturn, false);
            }
            changed = true;
        }
        current = this.itemHandler.getStackInSlot(slotIndex);
        int slotLimit = Math.min(this.itemHandler.getSlotLimit(slotIndex), required.m_41741_());
        if (slotLimit <= 0) {
            return changed;
        }
        int n = have = current.m_41619_() ? 0 : current.m_41613_();
        if (have >= slotLimit) {
            return changed;
        }
        int missing = slotLimit - have;
        int pulled = this.moveMatchingItemsFromInventory((Player)player, required, missing, extracted -> {
            ItemStack remainder = this.itemHandler.insertItem(slotIndex, extracted, false);
            if (!remainder.m_41619_() && !player.m_150109_().m_36054_(remainder)) {
                player.m_36176_(remainder, false);
            }
        });
        if (pulled > 0) {
            changed = true;
        }
        return changed;
    }

    public boolean consumeMaterials(Player player, boolean craftMax, @Nullable EnergyTransferTracker tracker) {
        int craftCount;
        ItemStack slotB;
        Level level = this.m_58904_();
        if (level == null || level.m_5776_()) {
            return false;
        }
        ItemStack slotA = this.itemHandler.getStackInSlot(0);
        Optional<AnvilRecipe> recipeOpt = this.resolveCombineRecipe(level, slotA, slotB = this.itemHandler.getStackInSlot(1));
        if (recipeOpt.isEmpty()) {
            return false;
        }
        AnvilRecipe recipe = recipeOpt.get();
        InputOrientation orientation = this.resolveOrientation(slotA, slotB, recipe);
        if (orientation == InputOrientation.NONE) {
            return false;
        }
        int n = craftCount = craftMax ? 64 : 1;
        if (craftMax) {
            craftCount = Math.min(craftCount, this.computeMaxCrafts(slotA, slotB, recipe, orientation));
        }
        if (craftCount <= 0) {
            return false;
        }
        for (ItemStack required : recipe.getInventoryInputs()) {
            if (required.m_41619_()) continue;
            int available = this.countItemInInventory(player, required);
            craftCount = Math.min(craftCount, available / required.m_41613_());
        }
        if (craftCount <= 0) {
            return false;
        }
        this.shrinkSlotInput(slotA, slotB, recipe, orientation, craftCount);
        for (ItemStack required : recipe.getInventoryInputs()) {
            if (required.m_41619_()) continue;
            this.removeItemFromInventory(player, required, required.m_41613_() * craftCount, tracker);
        }
        player.m_150109_().m_6596_();
        this.setChangedAndNotify();
        return true;
    }

    public void handleCombineOutputTaken(Player player, ItemStack outputStack) {
        ItemStack slotBCopy;
        Level level = this.m_58904_();
        if (level == null || level.m_5776_()) {
            return;
        }
        ItemStack slotACopy = this.itemHandler.getStackInSlot(0).m_41777_();
        Optional<AnvilRecipe> recipeOpt = this.resolveCombineRecipe(level, slotACopy, slotBCopy = this.itemHandler.getStackInSlot(1).m_41777_());
        if (recipeOpt.isEmpty()) {
            this.consumeMaterials(player, false, null);
            this.updateCrafting();
            return;
        }
        AnvilRecipe recipe = recipeOpt.get();
        InputOrientation orientation = this.resolveOrientation(slotACopy, slotBCopy, recipe);
        if (orientation == InputOrientation.NONE) {
            this.consumeMaterials(player, false, null);
            this.updateCrafting();
            return;
        }
        EnergyTransferTracker tracker = new EnergyTransferTracker();
        this.collectEnergyFromSlots(tracker, slotACopy, slotBCopy, recipe, orientation, 1);
        boolean crafted = this.consumeMaterials(player, false, tracker);
        if (crafted && !outputStack.m_41619_()) {
            this.applyEnergyToOutputs(List.of(outputStack), tracker.getTotalEnergy());
        }
        this.updateCrafting();
    }

    public boolean craft(Player player, boolean craftMax) {
        Level level = this.m_58904_();
        if (level == null || level.m_5776_()) {
            return false;
        }
        Optional<AnvilRecipe> recipeOpt = this.resolveSelectedInventoryRecipe(level);
        if (recipeOpt.isEmpty()) {
            return false;
        }
        AnvilRecipe recipe = recipeOpt.get();
        int maxCrafts = this.computeInventoryCraftLimit(player, recipe);
        if (maxCrafts <= 0) {
            return false;
        }
        int craftCount = Math.min(craftMax ? 64 : 1, maxCrafts);
        if (craftCount <= 0) {
            return false;
        }
        EnergyTransferTracker tracker = new EnergyTransferTracker();
        this.consumeInventory(player, recipe, craftCount, tracker);
        List<ItemStack> produced = this.rollOutputs(level, recipe, craftCount);
        this.applyEnergyToOutputs(produced, tracker.getTotalEnergy());
        if (!produced.isEmpty()) {
            this.giveStacksToPlayer(player, produced);
        }
        this.setChangedAndNotify();
        this.updateCrafting();
        return true;
    }

    public void populateInputsFromPlayer(ServerPlayer player, AnvilRecipe recipe) {
        ItemStack slotB;
        if (player == null || recipe == null) {
            return;
        }
        Level level = this.m_58904_();
        if (level == null || level.m_5776_()) {
            return;
        }
        ItemStack slotA = this.itemHandler.getStackInSlot(0);
        InputOrientation orientation = this.chooseBestOrientation(slotA, slotB = this.itemHandler.getStackInSlot(1), recipe);
        boolean changed = this.populateInputsForOrientation(player, recipe, orientation);
        if (!changed) {
            InputOrientation fallback = orientation == InputOrientation.NORMAL ? InputOrientation.SWAPPED : InputOrientation.NORMAL;
            changed = this.populateInputsForOrientation(player, recipe, fallback);
        }
        if (changed) {
            player.m_150109_().m_6596_();
            this.setChangedAndNotify();
            this.updateCrafting();
        }
    }

    private Optional<AnvilRecipe> resolveCombineRecipe(Level level, ItemStack slotA, ItemStack slotB) {
        Optional<AnvilRecipe> selected = this.resolveSelectedRecipe(level).filter(AnvilRecipe::usesMachineInputs).filter(recipe -> this.canCraftRecipe((AnvilRecipe)recipe, slotA, slotB));
        if (selected.isPresent()) {
            return selected;
        }
        return AnvilRecipeManager.findRecipe(level, slotA, slotB, this.getTier()).filter(AnvilRecipe::usesMachineInputs).filter(recipe -> this.canCraftRecipe((AnvilRecipe)recipe, slotA, slotB));
    }

    private Optional<AnvilRecipe> resolveSelectedRecipe(Level level) {
        if (this.selectedRecipeId == null) {
            return Optional.empty();
        }
        Optional<AnvilRecipe> selected = AnvilRecipeManager.getRecipe(level, this.selectedRecipeId);
        if (selected.isEmpty() || !selected.get().canCraftOn(this.getTier())) {
            this.clearSelectedRecipeId();
            return Optional.empty();
        }
        return selected;
    }

    private Optional<AnvilRecipe> resolveSelectedInventoryRecipe(Level level) {
        return this.resolveSelectedRecipe(level).filter(recipe -> !recipe.usesMachineInputs());
    }

    private void setChangedAndNotify() {
        this.m_6596_();
        Level level = this.m_58904_();
        if (level != null && !level.m_5776_()) {
            BlockState state = level.m_8055_(this.f_58858_);
            level.m_7260_(this.f_58858_, state, state, 2);
        }
    }

    private void clearSelectedRecipeId() {
        if (this.selectedRecipeId != null) {
            this.selectedRecipeId = null;
            this.setChangedAndNotify();
        }
    }

    private int computeMaxCrafts(ItemStack available, ItemStack required) {
        if (required.m_41619_() || required.m_41613_() <= 0) {
            return Integer.MAX_VALUE;
        }
        if (available.m_41619_()) {
            return 0;
        }
        return available.m_41613_() / required.m_41613_();
    }

    private int countItemInInventory(Player player, ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack invStack = player.m_150109_().m_8020_(i);
            if (!this.matchesIngredient(invStack, stack)) continue;
            count += invStack.m_41613_();
        }
        return count;
    }

    private int removeItemFromInventory(Player player, ItemStack stack, int amount, @Nullable EnergyTransferTracker tracker) {
        if (stack.m_41619_() || amount <= 0) {
            return 0;
        }
        int remaining = amount;
        int removed = 0;
        for (int i = 0; i < player.m_150109_().m_6643_() && remaining > 0; ++i) {
            ItemStack invStack = player.m_150109_().m_8020_(i);
            if (!this.matchesIngredient(invStack, stack)) continue;
            int toRemove = Math.min(remaining, invStack.m_41613_());
            if (tracker != null && this.isBattery(invStack)) {
                long energyPerItem = ModBatteryItem.getEnergy(invStack);
                tracker.add(energyPerItem * (long)toRemove);
            }
            invStack.m_41774_(toRemove);
            remaining -= toRemove;
            removed += toRemove;
        }
        if (removed > 0) {
            player.m_150109_().m_6596_();
        }
        return removed;
    }

    private int computeInventoryCraftLimit(Player player, AnvilRecipe recipe) {
        List<ItemStack> requirements = recipe.getInventoryInputs();
        if (requirements.isEmpty()) {
            return 0;
        }
        int limit = Integer.MAX_VALUE;
        for (ItemStack required : requirements) {
            if (required.m_41619_()) continue;
            int available = this.countItemInInventory(player, required);
            limit = Math.min(limit, available / required.m_41613_());
        }
        return limit;
    }

    private void consumeInventory(Player player, AnvilRecipe recipe, int craftCount, @Nullable EnergyTransferTracker tracker) {
        for (ItemStack required : recipe.getInventoryInputs()) {
            if (required.m_41619_()) continue;
            this.removeItemFromInventory(player, required, required.m_41613_() * craftCount, tracker);
        }
    }

    private List<ItemStack> rollOutputs(Level level, AnvilRecipe recipe, int craftCount) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        RandomSource random = level.f_46441_;
        for (int i = 0; i < craftCount; ++i) {
            for (AnvilRecipe.ResultEntry entry : recipe.getOutputs()) {
                if (!(entry.chance() >= 1.0f) && !(random.m_188501_() <= entry.chance())) continue;
                ItemStack stack = entry.stack().m_41777_();
                this.mergeStack(result, stack);
            }
        }
        return result;
    }

    private void mergeStack(List<ItemStack> stacks, ItemStack addition) {
        if (addition.m_41619_()) {
            return;
        }
        for (ItemStack existing : stacks) {
            if (!ItemStack.m_150942_((ItemStack)existing, (ItemStack)addition)) continue;
            existing.m_41769_(addition.m_41613_());
            return;
        }
        stacks.add(addition.m_41777_());
    }

    private void giveStacksToPlayer(Player player, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (player.m_150109_().m_36054_(stack)) continue;
            player.m_36176_(stack, false);
        }
        player.m_150109_().m_6596_();
    }

    private void collectEnergyFromSlots(@Nullable EnergyTransferTracker tracker, ItemStack slotA, ItemStack slotB, AnvilRecipe recipe, InputOrientation orientation, int craftCount) {
        if (tracker == null) {
            return;
        }
        ItemStack firstRequired = orientation == InputOrientation.NORMAL ? recipe.getInputA() : recipe.getInputB();
        ItemStack secondRequired = orientation == InputOrientation.NORMAL ? recipe.getInputB() : recipe.getInputA();
        tracker.add(this.extractEnergyFromStack(slotA, firstRequired.m_41613_() * craftCount));
        tracker.add(this.extractEnergyFromStack(slotB, secondRequired.m_41613_() * craftCount));
    }

    private long extractEnergyFromStack(ItemStack stack, int itemCount) {
        if (!this.isBattery(stack) || itemCount <= 0) {
            return 0L;
        }
        int copies = Math.min(itemCount, Math.max(1, stack.m_41613_()));
        long energyPerItem = ModBatteryItem.getEnergy(stack);
        return energyPerItem * (long)copies;
    }

    private void applyEnergyToOutputs(List<ItemStack> outputs, long totalEnergy) {
        if (totalEnergy <= 0L || outputs.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> batteryOutputs = new ArrayList<ItemStack>();
        for (ItemStack stack : outputs) {
            if (!this.isBattery(stack)) continue;
            batteryOutputs.add(stack);
        }
        if (batteryOutputs.isEmpty()) {
            return;
        }
        long remaining = totalEnergy;
        for (ItemStack stack : batteryOutputs) {
            long current;
            if (remaining <= 0L) break;
            ModBatteryItem battery = (ModBatteryItem)stack.m_41720_();
            long capacity = battery.getCapacity();
            long space = Math.max(0L, capacity - (current = ModBatteryItem.getEnergy(stack)));
            if (space <= 0L) continue;
            long toInsert = Math.min(space, remaining);
            this.addEnergyToBattery(stack, toInsert);
            remaining -= toInsert;
        }
    }

    private void addEnergyToBattery(ItemStack stack, long delta) {
        if (delta <= 0L || !this.isBattery(stack)) {
            return;
        }
        ModBatteryItem battery = (ModBatteryItem)stack.m_41720_();
        long current = ModBatteryItem.getEnergy(stack);
        long newEnergy = Math.min(battery.getCapacity(), current + delta);
        ModBatteryItem.setEnergy(stack, newEnergy);
    }

    private boolean isBattery(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() instanceof ModBatteryItem;
    }

    private boolean matchesIngredient(ItemStack actual, ItemStack required) {
        if (required.m_41619_()) {
            return actual.m_41619_();
        }
        if (actual.m_41619_()) {
            return false;
        }
        if (required.m_41782_()) {
            return ItemStack.m_150942_((ItemStack)actual, (ItemStack)required);
        }
        return actual.m_150930_(required.m_41720_());
    }

    private int moveMatchingItemsFromInventory(Player player, ItemStack template, int amount, Consumer<ItemStack> consumer) {
        if (player == null || template.m_41619_() || amount <= 0) {
            return 0;
        }
        Inventory inventory = player.m_150109_();
        int remaining = amount;
        for (int i = 0; i < inventory.m_6643_() && remaining > 0; ++i) {
            int toExtract;
            ItemStack extracted;
            ItemStack invStack = inventory.m_8020_(i);
            if (!this.matchesIngredient(invStack, template) || (extracted = invStack.m_41620_(toExtract = Math.min(remaining, invStack.m_41613_()))).m_41619_()) continue;
            remaining -= extracted.m_41613_();
            consumer.accept(extracted);
        }
        if (remaining < amount) {
            inventory.m_6596_();
        }
        return amount - remaining;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    private static enum InputOrientation {
        NORMAL,
        SWAPPED,
        NONE;

    }

    private static final class EnergyTransferTracker {
        private long totalEnergy = 0L;

        private EnergyTransferTracker() {
        }

        void add(long energy) {
            if (energy > 0L) {
                this.totalEnergy += energy;
            }
        }

        long getTotalEnergy() {
            return this.totalEnergy;
        }
    }
}

