/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity;

import com.hbm_m.block.BlastFurnaceBlock;
import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.item.ModItems;
import com.hbm_m.menu.BlastFurnaceMenu;
import com.hbm_m.recipe.BlastFurnaceRecipe;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlastFurnaceBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int FUEL_SLOT = 0;
    private static final int INPUT_SLOT_TOP = 1;
    private static final int INPUT_SLOT_BOTTOM = 2;
    private static final int OUTPUT_SLOT = 3;
    private static final int PROCESS_TIME = 400;
    private static final int MAX_FUEL = 12800;
    private final ItemStackHandler itemHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            BlastFurnaceBlockEntity.this.m_6596_();
            if (BlastFurnaceBlockEntity.this.f_58857_ != null && !BlastFurnaceBlockEntity.this.f_58857_.m_5776_()) {
                BlastFurnaceBlockEntity.this.f_58857_.m_7260_(BlastFurnaceBlockEntity.this.m_58899_(), BlastFurnaceBlockEntity.this.m_58900_(), BlastFurnaceBlockEntity.this.m_58900_(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 3) {
                return false;
            }
            if (slot == 0) {
                return BlastFurnaceBlockEntity.isFuel(stack);
            }
            return true;
        }
    };
    private final Map<Direction, LazyOptional<IItemHandler>> sidedItemHandlers = new EnumMap<Direction, LazyOptional<IItemHandler>>(Direction.class);
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final ContainerData data;
    private int progress;
    private int fuel;
    private int sideUpper = Direction.UP.m_122411_();
    private int sideLower = Direction.UP.m_122411_();
    private int sideFuel = Direction.UP.m_122411_();
    private static final int DATA_COUNT = 7;
    private static final int DATA_INDEX_PROGRESS = 0;
    private static final int DATA_INDEX_MAX_PROGRESS = 1;
    private static final int DATA_INDEX_FUEL = 2;
    private static final int DATA_INDEX_MAX_FUEL = 3;
    private static final int DATA_INDEX_SIDE_UPPER = 4;
    private static final int DATA_INDEX_SIDE_LOWER = 5;
    private static final int DATA_INDEX_SIDE_FUEL = 6;

    public BlastFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BLAST_FURNACE_BE.get(), pos, state);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> BlastFurnaceBlockEntity.this.progress;
                    case 1 -> 400;
                    case 2 -> BlastFurnaceBlockEntity.this.fuel;
                    case 3 -> 12800;
                    case 4 -> BlastFurnaceBlockEntity.this.sideUpper;
                    case 5 -> BlastFurnaceBlockEntity.this.sideLower;
                    case 6 -> BlastFurnaceBlockEntity.this.sideFuel;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        BlastFurnaceBlockEntity.this.progress = value;
                        break;
                    }
                    case 2: {
                        BlastFurnaceBlockEntity.this.fuel = value;
                        break;
                    }
                    case 4: {
                        BlastFurnaceBlockEntity.this.sideUpper = value;
                        break;
                    }
                    case 5: {
                        BlastFurnaceBlockEntity.this.sideLower = value;
                        break;
                    }
                    case 6: {
                        BlastFurnaceBlockEntity.this.sideFuel = value;
                        break;
                    }
                }
            }

            public int m_6499_() {
                return 7;
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.sidedItemHandlers.getOrDefault(side, this.lazyItemHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.sidedItemHandlers.clear();
        for (Direction direction : Direction.values()) {
            this.sidedItemHandlers.put(direction, (LazyOptional<IItemHandler>)LazyOptional.of(() -> new DirectionalItemHandler(direction)));
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.sidedItemHandlers.values().forEach(LazyOptional::invalidate);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.hbm_m.blast_furnace");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new BlastFurnaceMenu(containerId, playerInventory, this, this.data);
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("blast_furnace.progress", this.progress);
        tag.m_128405_("blast_furnace.fuel", this.fuel);
        tag.m_128405_("blast_furnace.side_upper", this.sideUpper);
        tag.m_128405_("blast_furnace.side_lower", this.sideLower);
        tag.m_128405_("blast_furnace.side_fuel", this.sideFuel);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.progress = tag.m_128451_("blast_furnace.progress");
        this.fuel = tag.m_128451_("blast_furnace.fuel");
        this.sideUpper = tag.m_128451_("blast_furnace.side_upper");
        this.sideLower = tag.m_128451_("blast_furnace.side_lower");
        this.sideFuel = tag.m_128451_("blast_furnace.side_fuel");
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        boolean canProcess;
        if (level.m_5776_()) {
            return;
        }
        boolean dirty = false;
        boolean wasBurning = this.isBurning();
        if (this.fuel < 12800 && this.tryConsumeFuelItem()) {
            dirty = true;
        }
        boolean bl = canProcess = this.hasRecipe() && this.fuel > 0;
        if (canProcess) {
            this.fuel = Math.max(0, this.fuel - 1);
            this.progress += this.getProgressPerTick();
            if (this.progress >= 400) {
                this.craftItem();
                this.progress -= 400;
            }
            dirty = true;
        } else if (this.progress != 0) {
            this.progress = 0;
            dirty = true;
        }
        if (wasBurning != this.isBurning()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlastFurnaceBlock.LIT, (Comparable)Boolean.valueOf(this.isBurning())), 3);
            dirty = true;
        }
        if (dirty) {
            this.m_6596_();
        }
    }

    private int getProgressPerTick() {
        return this.hasExtension() ? 3 : 1;
    }

    private boolean hasExtension() {
        if (this.f_58857_ == null) {
            return false;
        }
        BlockState above = this.f_58857_.m_8055_(this.f_58858_.m_7494_());
        return above.m_60713_((Block)ModBlocks.BLAST_FURNACE_EXTENSION.get());
    }

    private boolean tryConsumeFuelItem() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.m_41619_()) {
            return false;
        }
        int value = BlastFurnaceBlockEntity.getFuelValue(stack);
        if (value <= 0) {
            return false;
        }
        int newFuelLevel = Math.min(12800, this.fuel + value);
        if (newFuelLevel == this.fuel) {
            return false;
        }
        this.fuel = newFuelLevel;
        ItemStack remainder = stack.getCraftingRemainingItem();
        stack.m_41774_(1);
        if (stack.m_41619_()) {
            this.itemHandler.setStackInSlot(0, remainder);
        }
        return true;
    }

    private boolean hasRecipe() {
        Optional<BlastFurnaceRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty() || this.f_58857_ == null) {
            return false;
        }
        ItemStack result = recipe.get().m_8043_(this.f_58857_.m_9598_());
        return !result.m_41619_() && this.canAcceptResult(result);
    }

    private boolean canAcceptResult(ItemStack result) {
        ItemStack currentOutput = this.itemHandler.getStackInSlot(3);
        if (currentOutput.m_41619_()) {
            return true;
        }
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)currentOutput, (ItemStack)result)) {
            return false;
        }
        return currentOutput.m_41613_() + result.m_41613_() <= currentOutput.m_41741_();
    }

    private Optional<BlastFurnaceRecipe> getCurrentRecipe() {
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)BlastFurnaceRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private void craftItem() {
        Optional<BlastFurnaceRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty() || this.f_58857_ == null) {
            return;
        }
        ItemStack result = recipe.get().m_8043_(this.f_58857_.m_9598_()).m_41777_();
        this.itemHandler.extractItem(1, 1, false);
        this.itemHandler.extractItem(2, 1, false);
        ItemStack output = this.itemHandler.getStackInSlot(3);
        if (output.m_41619_()) {
            this.itemHandler.setStackInSlot(3, result);
        } else {
            output.m_41769_(result.m_41613_());
            this.itemHandler.setStackInSlot(3, output);
        }
    }

    private boolean isBurning() {
        return this.fuel > 0;
    }

    public static boolean isFuel(ItemStack stack) {
        return BlastFurnaceBlockEntity.getFuelValue(stack) > 0;
    }

    private static int getFuelValue(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item == Items.f_42448_) {
            return 12800;
        }
        if (item == Items.f_42413_ || item == Items.f_42414_) {
            return 200;
        }
        if (item == Items.f_42200_) {
            return 2000;
        }
        if (item == Items.f_42585_) {
            return 1000;
        }
        if (item == Items.f_42593_) {
            return 300;
        }
        if (item == ModItems.LIGNITE.get()) {
            return 150;
        }
        return 0;
    }

    public void cycleSide(int slot) {
        switch (slot) {
            case 0: {
                this.sideUpper = BlastFurnaceBlockEntity.nextDirection(this.sideUpper);
                break;
            }
            case 1: {
                this.sideLower = BlastFurnaceBlockEntity.nextDirection(this.sideLower);
                break;
            }
            case 2: {
                this.sideFuel = BlastFurnaceBlockEntity.nextDirection(this.sideFuel);
                break;
            }
            default: {
                return;
            }
        }
        this.markSidesChanged();
    }

    public Direction getConfiguredDirection(int slot) {
        return Direction.m_122376_((int)(switch (slot) {
            case 0 -> this.sideUpper;
            case 1 -> this.sideLower;
            case 2 -> this.sideFuel;
            default -> Direction.UP.m_122411_();
        }));
    }

    private static int nextDirection(int current) {
        int next = (current + 1) % Direction.values().length;
        return next < 0 ? 0 : next;
    }

    private void markSidesChanged() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    private boolean canInsertFromDirection(int slot, Direction direction) {
        if (direction == null) {
            return true;
        }
        return switch (slot) {
            case 1 -> BlastFurnaceBlockEntity.matches(direction, this.sideUpper);
            case 2 -> BlastFurnaceBlockEntity.matches(direction, this.sideLower);
            case 0 -> BlastFurnaceBlockEntity.matches(direction, this.sideFuel);
            default -> false;
        };
    }

    private static boolean matches(Direction direction, int stored) {
        return direction.m_122411_() == stored;
    }

    private boolean canExtractFromDirection(int slot) {
        return slot == 3;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    private class DirectionalItemHandler
    implements IItemHandler {
        private final Direction direction;

        private DirectionalItemHandler(Direction direction) {
            this.direction = direction;
        }

        public int getSlots() {
            return BlastFurnaceBlockEntity.this.itemHandler.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return BlastFurnaceBlockEntity.this.itemHandler.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (!BlastFurnaceBlockEntity.this.canInsertFromDirection(slot, this.direction) || !BlastFurnaceBlockEntity.this.itemHandler.isItemValid(slot, stack)) {
                return stack;
            }
            return BlastFurnaceBlockEntity.this.itemHandler.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!BlastFurnaceBlockEntity.this.canExtractFromDirection(slot)) {
                return ItemStack.f_41583_;
            }
            return BlastFurnaceBlockEntity.this.itemHandler.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return BlastFurnaceBlockEntity.this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return BlastFurnaceBlockEntity.this.itemHandler.isItemValid(slot, stack) && BlastFurnaceBlockEntity.this.canInsertFromDirection(slot, this.direction);
        }
    }
}

