/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity;

import com.hbm_m.client.loader.ColladaAnimationParser;
import com.hbm_m.client.model.DoorBakedModel;
import com.hbm_m.client.render.LegacyAnimator;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.sound.ModSounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class DoorDecl {
    private final Map<String, BakedModel> modelCache = new HashMap<String, BakedModel>();
    private BakedModel[] cachedModelParts = null;
    private String[] cachedPartNames = null;
    private Map<String, AABB> cachedPartAABBs = new HashMap<String, AABB>();
    public static final DoorDecl LARGE_VEHICLE_DOOR = new DoorDecl(){

        @Override
        public ResourceLocation getBlockId() {
            return ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"large_vehicle_door");
        }

        @Override
        public int getOpenTime() {
            return 60;
        }

        @Override
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if ("doorLeft".equals(partName)) {
                this.set(trans, 0.0f, 0.0f, 3.0f * this.getNormTime(openTicks));
            } else if ("doorRight".equals(partName)) {
                this.set(trans, 0.0f, 0.0f, -3.0f * this.getNormTime(openTicks));
            } else {
                super.getTranslation(partName, openTicks, child, trans);
            }
        }

        @Override
        public double[][] getClippingPlanes() {
            return new double[][]{{1.0, 0.0, 0.0, 3.5}, {-1.0, 0.0, 0.0, 3.5}};
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{0, 0, 0, -4, 6, 2}, {0, 0, 0, 4, 6, 2}};
        }

        @Override
        public List<AABB> getCollisionBounds(float progress, Direction facing) {
            double rightMinX;
            ArrayList<AABB> bounds = new ArrayList<AABB>();
            if (progress >= 0.99f) {
                return bounds;
            }
            int[] d = this.getDimensions();
            double minX = d[0];
            double minY = d[1];
            double minZ = d[2];
            double maxX = d[0] + d[3];
            double maxY = d[1] + d[4];
            double maxZ = d[2] + (d[5] == 0 ? 1 : d[5]);
            double totalWidth = (maxX += 1.0) - minX;
            double half = totalWidth / 2.0;
            double centerX = minX + half;
            double move = Math.min((double)progress, 1.0) * half;
            double leftMaxX = centerX - move;
            if (leftMaxX > minX + 0.05) {
                AABB leftDoor = new AABB(minX, minY, minZ, leftMaxX, maxY, maxZ);
                bounds.add(1.rotateAABB(leftDoor, facing));
            }
            if ((rightMinX = centerX + move) < maxX - 0.05) {
                AABB rightDoor = new AABB(rightMinX, minY, minZ, maxX, maxY, maxZ);
                bounds.add(1.rotateAABB(rightDoor, facing));
            }
            return bounds;
        }

        @Override
        public SoundEvent getOpenSoundEnd() {
            return (SoundEvent)ModSounds.GARAGE_STOP.get();
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return (SoundEvent)ModSounds.GARAGE_MOVE.get();
        }

        @Override
        public SoundEvent getCloseSoundEnd() {
            return (SoundEvent)ModSounds.GARAGE_STOP.get();
        }

        @Override
        public SoundEvent getCloseSoundLoop() {
            return (SoundEvent)ModSounds.GARAGE_MOVE.get();
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }
    };
    public static final DoorDecl ROUND_AIRLOCK_DOOR = new DoorDecl(){

        @Override
        public ResourceLocation getBlockId() {
            return ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"round_airlock_door");
        }

        @Override
        public int getOpenTime() {
            return 60;
        }

        @Override
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if ("doorLeft".equals(partName)) {
                this.set(trans, 0.0f, 0.0f, 1.5f * this.getNormTime(openTicks));
            } else if ("doorRight".equals(partName)) {
                this.set(trans, 0.0f, 0.0f, -1.5f * this.getNormTime(openTicks));
            } else {
                super.getTranslation(partName, openTicks, child, trans);
            }
        }

        @Override
        public double[][] getClippingPlanes() {
            return new double[][]{{0.0, 0.0, 1.0, 2.0001}, {0.0, 0.0, -1.0, 2.0001}};
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{0, 0, 0, -2, 4, 2}, {0, 0, 0, 3, 4, 2}};
        }

        @Override
        public List<AABB> getCollisionBounds(float progress, Direction facing) {
            double rightMinX;
            ArrayList<AABB> bounds = new ArrayList<AABB>();
            if (progress >= 0.99f) {
                return bounds;
            }
            int[] d = this.getDimensions();
            double ox = d[0];
            double oy = d[1];
            double oz = d[2];
            double sx = d[3];
            double sy = d[4];
            double sz = d[5];
            double half = sx / 2.0;
            double move = Math.min((double)progress, 1.0) * half;
            double leftMaxX = Math.max(ox, ox + half - move);
            if (leftMaxX - ox > 0.05) {
                AABB leftDoor = new AABB(ox, oy, oz, leftMaxX, oy + sy, oz + sz + 1.0);
                bounds.add(2.rotateAABB(leftDoor, facing));
            }
            if (ox + sx - (rightMinX = Math.min(ox + sx, ox + half + move)) > 0.05) {
                AABB rightDoor = new AABB(rightMinX, oy, oz, ox + sx, oy + sy, oz + sz + 1.0);
                bounds.add(2.rotateAABB(rightDoor, facing));
            }
            return bounds;
        }

        @Override
        public SoundEvent getOpenSoundEnd() {
            return (SoundEvent)ModSounds.GARAGE_STOP.get();
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return (SoundEvent)ModSounds.GARAGE_MOVE.get();
        }

        @Override
        public SoundEvent getCloseSoundEnd() {
            return (SoundEvent)ModSounds.GARAGE_STOP.get();
        }

        @Override
        public SoundEvent getCloseSoundLoop() {
            return (SoundEvent)ModSounds.GARAGE_MOVE.get();
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }
    };
    public static final DoorDecl TRANSITION_SEAL = new DoorDecl(){
        private Map<String, List<ColladaAnimationParser.AnimationChannel>> animations = Collections.emptyMap();
        private boolean animationsInitialized = false;

        @Override
        public ResourceLocation getBlockId() {
            return ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"transition_seal");
        }

        @Override
        public int getOpenTime() {
            return 480;
        }

        private void initializeAnimations() {
            if (this.animationsInitialized) {
                return;
            }
            this.animationsInitialized = true;
            try {
                if (Minecraft.m_91087_() == null) {
                    this.animations = Collections.emptyMap();
                    return;
                }
                ResourceManager rm = Minecraft.m_91087_().m_91098_();
                Resource resource = rm.m_213713_(ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"models/block/sliding_blast_door.dae")).orElse(null);
                if (resource == null) {
                    MainRegistry.LOGGER.error("DoorDecl: missing sliding_blast_door.dae for {}", (Object)this.getBlockId());
                    this.animations = Collections.emptyMap();
                } else {
                    this.animations = ColladaAnimationParser.parse(resource.m_215507_());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.animations = Collections.emptyMap();
            }
        }

        @Override
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            this.initializeAnimations();
            if (!this.animations.containsKey(partName)) {
                super.getTranslation(partName, openTicks, child, trans);
                return;
            }
            float progress = this.getNormTime(openTicks);
            float time = progress * ((float)this.getOpenTime() / 20.0f);
            for (ColladaAnimationParser.AnimationChannel channel : this.animations.get(partName)) {
                if (!channel.property.startsWith("location")) continue;
                float value = channel.getValue(time);
                if (channel.property.endsWith(".X")) {
                    trans[0] = value;
                    continue;
                }
                if (channel.property.endsWith(".Y")) {
                    trans[1] = value;
                    continue;
                }
                if (!channel.property.endsWith(".Z")) continue;
                trans[2] = value;
            }
        }

        @Override
        public void getRotation(String partName, float openTicks, float[] rot) {
            this.initializeAnimations();
            if (!this.animations.containsKey(partName)) {
                super.getRotation(partName, openTicks, rot);
                return;
            }
            float progress = this.getNormTime(openTicks);
            float time = progress * ((float)this.getOpenTime() / 20.0f);
            for (ColladaAnimationParser.AnimationChannel channel : this.animations.get(partName)) {
                if (!channel.property.startsWith("rotation")) continue;
                float value = (float)Math.toDegrees(channel.getValue(time));
                if (channel.property.endsWith(".X")) {
                    rot[0] = value;
                    continue;
                }
                if (channel.property.endsWith(".Y")) {
                    rot[1] = value;
                    continue;
                }
                if (!channel.property.endsWith(".Z")) continue;
                rot[2] = value;
            }
        }

        @Override
        public void doOffsetTransform(LegacyAnimator animator) {
            animator.translate(0.0, 0.0, 0.5);
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{-9, 2, 0, 20, 20, 1}};
        }

        @Override
        public List<AABB> getCollisionBounds(float progress, Direction facing) {
            ArrayList<AABB> bounds = new ArrayList<AABB>();
            if (progress >= 0.99f) {
                return bounds;
            }
            double movement = (double)progress * 3.5;
            AABB door = new AABB(-9.0, 0.0, 0.0, 11.0, Math.max(0.5, 20.0 - movement), 1.0);
            bounds.add(3.rotateAABB(door, facing));
            return bounds;
        }

        @Override
        public SoundEvent getOpenSoundStart() {
            return (SoundEvent)ModSounds.TRANSITION_SEAL_OPEN.get();
        }

        @Override
        public float getSoundVolume() {
            return 6.0f;
        }
    };
    public static final DoorDecl FIRE_DOOR = new DoorDecl(){

        @Override
        public ResourceLocation getBlockId() {
            return ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"fire_door");
        }

        @Override
        public int getOpenTime() {
            return 160;
        }

        @Override
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if ("door".equals(partName) || !"frame".equals(partName)) {
                this.set(trans, 0.0f, 3.0f * this.getNormTime(openTicks), 0.0f);
            } else {
                this.set(trans, 0.0f, 0.0f, 0.0f);
            }
        }

        @Override
        public double[][] getClippingPlanes() {
            return new double[][]{{0.0, -1.0, 0.0, 3.0001}};
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{-1, 0, 0, 3, 4, 1}};
        }

        @Override
        public List<AABB> getCollisionBounds(float progress, Direction facing) {
            ArrayList<AABB> bounds = new ArrayList<AABB>();
            if (progress >= 0.99f) {
                return bounds;
            }
            double movement = (double)progress * 3.0;
            AABB door = new AABB(-1.0, 0.0, 0.0, 2.0, Math.max(0.1, 4.0 - movement), 1.0);
            bounds.add(4.rotateAABB(door, facing));
            return bounds;
        }

        @Override
        public SoundEvent getOpenSoundEnd() {
            return (SoundEvent)ModSounds.WGH_STOP.get();
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return (SoundEvent)ModSounds.WGH_START.get();
        }

        @Override
        public SoundEvent getSoundLoop2() {
            return (SoundEvent)ModSounds.ALARM_6.get();
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }
    };
    public static final DoorDecl SLIDE_DOOR = new DoorDecl(){
        private volatile Map<String, List<ColladaAnimationParser.AnimationChannel>> animations = null;
        private final Object animationLock = new Object();
        private volatile Float cachedAnimationDuration = null;

        @Override
        public ResourceLocation getBlockId() {
            return ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"sliding_blast_door");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, List<ColladaAnimationParser.AnimationChannel>> getAnimations() {
            if (this.animations == null) {
                Object object = this.animationLock;
                synchronized (object) {
                    if (this.animations == null) {
                        try {
                            ResourceManager rm = Minecraft.m_91087_().m_91098_();
                            Resource resource = (Resource)rm.m_213713_(ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"models/block/sliding_blast_door.dae")).orElseThrow();
                            this.animations = ColladaAnimationParser.parse(resource.m_215507_());
                            float maxTime = 0.0f;
                            for (List<ColladaAnimationParser.AnimationChannel> channels : this.animations.values()) {
                                for (ColladaAnimationParser.AnimationChannel channel : channels) {
                                    if (channel.times == null || channel.times.length <= 0) continue;
                                    maxTime = Math.max(maxTime, channel.times[channel.times.length - 1]);
                                }
                            }
                            this.cachedAnimationDuration = Float.valueOf(maxTime > 0.0f ? maxTime : 1.25f);
                            MainRegistry.LOGGER.info("Loaded animations for SLIDE_DOOR: {} parts, duration: {}s", (Object)this.animations.size(), (Object)this.cachedAnimationDuration);
                        }
                        catch (Exception e) {
                            MainRegistry.LOGGER.error("Failed to load SLIDE_DOOR animations", (Throwable)e);
                            this.animations = Collections.emptyMap();
                            this.cachedAnimationDuration = Float.valueOf(1.25f);
                        }
                    }
                }
            }
            return this.animations;
        }

        @Override
        public int getOpenTime() {
            Map<String, List<ColladaAnimationParser.AnimationChannel>> anims = this.getAnimations();
            if (this.cachedAnimationDuration != null && this.cachedAnimationDuration.floatValue() > 0.0f) {
                return Math.round(this.cachedAnimationDuration.floatValue() * 20.0f);
            }
            return 25;
        }

        @Override
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            Map<String, List<ColladaAnimationParser.AnimationChannel>> anims = this.getAnimations();
            trans[0] = 0.0f;
            trans[1] = 0.0f;
            trans[2] = 0.0f;
            if (anims.isEmpty() || !anims.containsKey(partName)) {
                return;
            }
            float progress = this.getNormTime(openTicks);
            float time = progress * this.cachedAnimationDuration.floatValue();
            for (ColladaAnimationParser.AnimationChannel channel : anims.get(partName)) {
                if ("transform".equals(channel.property)) {
                    float[] translation = channel.getTranslationFromMatrix(time);
                    trans[0] = translation[0];
                    trans[1] = translation[1];
                    trans[2] = translation[2];
                    MainRegistry.LOGGER.debug("Part {} at time {}: translation = [{}, {}, {}]", new Object[]{partName, Float.valueOf(time), Float.valueOf(trans[0]), Float.valueOf(trans[1]), Float.valueOf(trans[2])});
                    return;
                }
                if (!channel.property.startsWith("location")) continue;
                float value = channel.getValue(time);
                if (channel.property.endsWith(".X")) {
                    trans[0] = value;
                    continue;
                }
                if (channel.property.endsWith(".Y")) {
                    trans[1] = value;
                    continue;
                }
                if (!channel.property.endsWith(".Z")) continue;
                trans[2] = value;
            }
        }

        @Override
        public void doOffsetTransform(LegacyAnimator animator) {
            animator.rotate(-90.0f, 0.0f, 1.0f, 0.0f);
        }

        @Override
        public double[][] getClippingPlanes() {
            return new double[][]{{-1.0, 0.0, 0.0, 3.50001}, {1.0, 0.0, 0.0, 3.50001}};
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{-2, 0, 0, 4, 5, 1}};
        }

        @Override
        public boolean hasSkins() {
            return true;
        }

        @Override
        public int getSkinCount() {
            return 3;
        }

        @Override
        public List<AABB> getCollisionBounds(float progress, Direction facing) {
            ArrayList<AABB> bounds = new ArrayList<AABB>();
            if (progress >= 0.99f) {
                return bounds;
            }
            double movement = (double)progress * 1.5;
            if (movement < 1.0) {
                AABB door = new AABB(-2.0, 0.0, 0.0, 3.0, 5.0, 1.0 - movement);
                bounds.add(5.rotateAABB(door, facing));
            }
            return bounds;
        }

        @Override
        public SoundEvent getOpenSoundEnd() {
            return (SoundEvent)ModSounds.SLIDING_DOOR_OPENED.get();
        }

        @Override
        public SoundEvent getCloseSoundEnd() {
            return (SoundEvent)ModSounds.SLIDING_DOOR_SHUT.get();
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return (SoundEvent)ModSounds.SLIDING_DOOR_OPENING.get();
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }
    };
    public static final DoorDecl SLIDING_SEAL_DOOR = new DoorDecl(){

        @Override
        public ResourceLocation getBlockId() {
            return ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"sliding_seal_door");
        }

        @Override
        public int getOpenTime() {
            return 20;
        }

        @Override
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if (partName.startsWith("door")) {
                this.set(trans, 0.0f, 0.0f, this.getNormTime(openTicks));
            } else {
                this.set(trans, 0.0f, 0.0f, 0.0f);
            }
        }

        @Override
        public double[][] getClippingPlanes() {
            return new double[][]{{0.0, 0.0, -1.0, 0.5001}};
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{0, 0, 0, 1, 2, 2}};
        }

        @Override
        public List<AABB> getCollisionBounds(float progress, Direction facing) {
            ArrayList<AABB> bounds = new ArrayList<AABB>();
            if (progress >= 0.99f) {
                return bounds;
            }
            double movement = (double)progress * 1.0;
            if (movement < 1.0) {
                AABB door = new AABB(0.0, 0.0, 0.75, 1.0, 2.0, 1.0);
                bounds.add(6.rotateAABB(door, facing));
            }
            return bounds;
        }

        @Override
        public SoundEvent getOpenSoundEnd() {
            return (SoundEvent)ModSounds.SLIDING_DOOR_OPENED.get();
        }

        @Override
        public SoundEvent getOpenSoundStart() {
            return (SoundEvent)ModSounds.SLIDING_DOOR_OPENING.get();
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }
    };
    public static final DoorDecl SECURE_ACCESS_DOOR = new DoorDecl(){

        @Override
        public ResourceLocation getBlockId() {
            return ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"secure_access_door");
        }

        @Override
        public int getOpenTime() {
            return 120;
        }

        @Override
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if (!partName.equals("base")) {
                this.set(trans, 0.0f, 3.5f * this.getNormTime(openTicks), 0.0f);
            } else {
                super.getTranslation(partName, openTicks, child, trans);
            }
        }

        @Override
        public void doOffsetTransform(LegacyAnimator animator) {
            animator.rotate(90.0f, 0.0f, 1.0f, 0.0f);
        }

        @Override
        public double[][] getClippingPlanes() {
            return new double[][]{{0.0, -1.0, 0.0, 5.0}};
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{-2, 1, 0, 4, 5, 1}};
        }

        @Override
        public List<AABB> getCollisionBounds(float progress, Direction facing) {
            ArrayList<AABB> bounds = new ArrayList<AABB>();
            if (progress >= 0.99f) {
                return bounds;
            }
            double movement = (double)progress * 3.5;
            AABB door = new AABB(-2.0, 0.0, 0.0, 3.0, Math.max(0.0625, 5.0 - movement), 1.0);
            bounds.add(7.rotateAABB(door, facing));
            return bounds;
        }

        @Override
        public SoundEvent getCloseSoundLoop() {
            return (SoundEvent)ModSounds.GARAGE_MOVE.get();
        }

        @Override
        public SoundEvent getCloseSoundEnd() {
            return (SoundEvent)ModSounds.GARAGE_STOP.get();
        }

        @Override
        public SoundEvent getOpenSoundEnd() {
            return (SoundEvent)ModSounds.GARAGE_STOP.get();
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return (SoundEvent)ModSounds.GARAGE_MOVE.get();
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }
    };
    public static final DoorDecl QE_SLIDING = new DoorDecl(){

        @Override
        public ResourceLocation getBlockId() {
            return ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"qe_sliding_door");
        }

        @Override
        public int getOpenTime() {
            return 10;
        }

        @Override
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if (partName.startsWith("left")) {
                this.set(trans, 0.0f, 0.0f, 0.99f * this.getNormTime(openTicks));
            } else if (partName.startsWith("right")) {
                this.set(trans, 0.0f, 0.0f, -0.99f * this.getNormTime(openTicks));
            }
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{0, 0, 0, 2, 2, 2}};
        }

        @Override
        public List<AABB> getCollisionBounds(float progress, Direction facing) {
            ArrayList<AABB> bounds = new ArrayList<AABB>();
            if (progress >= 0.99f) {
                return bounds;
            }
            double movement = (double)progress * 0.99;
            if (movement < 0.99) {
                AABB door = new AABB(0.0, 0.0, 0.8125, 2.0, 2.0, 1.0);
                bounds.add(8.rotateAABB(door, facing));
            }
            return bounds;
        }

        @Override
        public SoundEvent getOpenSoundEnd() {
            return (SoundEvent)ModSounds.SLIDING_DOOR_OPENED.get();
        }

        @Override
        public SoundEvent getCloseSoundEnd() {
            return (SoundEvent)ModSounds.SLIDING_DOOR_SHUT.get();
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return (SoundEvent)ModSounds.SLIDING_DOOR_OPENING.get();
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }
    };
    public static final DoorDecl QE_CONTAINMENT = new DoorDecl(){

        @Override
        public ResourceLocation getBlockId() {
            return ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"qe_containment_door");
        }

        @Override
        public ResourceLocation getTextureForPart(int skinIndex, String partName) {
            if ("decal".equals(partName)) {
                return ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"block/qe_containment_decal");
            }
            return ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"block/qe_containment_door");
        }

        @Override
        public int getOpenTime() {
            return 160;
        }

        @Override
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if ("door".equals(partName) || "decal".equals(partName)) {
                this.set(trans, 0.0f, 3.0f * this.getNormTime(openTicks), 0.0f);
            } else {
                super.getTranslation(partName, openTicks, child, trans);
            }
        }

        @Override
        public double[][] getClippingPlanes() {
            return new double[][]{{0.0, -1.0, 0.0, 3.0001}};
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{-1, 0, 0, 3, 3, 1}};
        }

        @Override
        public List<AABB> getCollisionBounds(float progress, Direction facing) {
            ArrayList<AABB> bounds = new ArrayList<AABB>();
            if (progress >= 0.99f) {
                return bounds;
            }
            double movement = (double)progress * 3.0;
            AABB door = new AABB(-1.0, 0.0, 0.5, 2.0, Math.max(0.1, 3.0 - movement), 1.0);
            bounds.add(9.rotateAABB(door, facing));
            return bounds;
        }

        @Override
        public SoundEvent getOpenSoundEnd() {
            return (SoundEvent)ModSounds.WGH_STOP.get();
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return (SoundEvent)ModSounds.WGH_START.get();
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }
    };
    public static final DoorDecl WATER_DOOR = new DoorDecl(){

        @Override
        public ResourceLocation getBlockId() {
            return ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"water_door");
        }

        @Override
        public int getOpenTime() {
            return 60;
        }

        @Override
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if ("bolt".equals(partName)) {
                float boltProgress = Math.min(1.0f, openTicks / 30.0f);
                this.set(trans, 0.0f, 0.0f, 0.4f * this.smoothstep(boltProgress));
            } else {
                this.set(trans, 0.0f, 0.0f, 0.0f);
            }
        }

        @Override
        public void getOrigin(String partName, float[] orig) {
            if ("door".equals(partName) || "bolt".equals(partName)) {
                this.set(orig, 0.125f, 1.5f, 1.18f);
                return;
            }
            if ("spinny_upper".equals(partName)) {
                this.set(orig, 0.041499f, 2.43569f, -0.587849f);
                return;
            }
            if ("spinny_lower".equals(partName)) {
                this.set(orig, 0.041499f, 0.571054f, -0.587849f);
                return;
            }
            super.getOrigin(partName, orig);
        }

        @Override
        public void getRotation(String partName, float openTicks, float[] rot) {
            if (partName.startsWith("spinny")) {
                float spinnyProgress = Math.min(1.0f, openTicks / 30.0f);
                this.set(rot, this.smoothstep(spinnyProgress) * 360.0f, 0.0f, 0.0f);
                return;
            }
            if ("door".equals(partName) || "bolt".equals(partName)) {
                float doorProgress = Math.max(0.0f, Math.min(1.0f, (openTicks - 30.0f) / 30.0f));
                this.set(rot, 0.0f, this.smoothstep(doorProgress) * -134.0f, 0.0f);
                return;
            }
            super.getRotation(partName, openTicks, rot);
        }

        @Override
        public boolean doesRender(String partName, boolean child) {
            return child || !partName.startsWith("spinny");
        }

        @Override
        public String[] getChildren(String partName) {
            if ("door".equals(partName)) {
                return new String[]{"spinny_lower", "spinny_upper"};
            }
            return super.getChildren(partName);
        }

        @Override
        public float getDoorRangeOpenTime(int ticks, int idx) {
            return this.getNormTime(ticks, 35.0f, 40.0f);
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{1, 0, 0, -3, 3, 2}};
        }

        @Override
        public List<AABB> getCollisionBounds(float progress, Direction facing) {
            ArrayList<AABB> bounds = new ArrayList<AABB>();
            if (progress >= 0.99f) {
                return bounds;
            }
            AABB door = new AABB(0.0, 0.0, 0.75, 1.0, 3.0, 1.0);
            bounds.add(10.rotateAABB(door, facing));
            return bounds;
        }

        private float smoothstep(float t) {
            return t * t * (3.0f - 2.0f * t);
        }

        @Override
        public SoundEvent getOpenSoundEnd() {
            return (SoundEvent)ModSounds.WGH_STOP.get();
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return (SoundEvent)ModSounds.WGH_START.get();
        }

        @Override
        public SoundEvent getOpenSoundStart() {
            return (SoundEvent)ModSounds.LEVER_1.get();
        }

        @Override
        public SoundEvent getCloseSoundEnd() {
            return (SoundEvent)ModSounds.LEVER_1.get();
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }
    };
    public static final DoorDecl SILO_HATCH = new DoorDecl(){

        @Override
        public ResourceLocation getBlockId() {
            return ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"silo_hatch");
        }

        @Override
        public int getOpenTime() {
            return 60;
        }

        @Override
        public boolean remoteControllable() {
            return true;
        }

        @Override
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if ("Hatch".equals(partName)) {
                float smoothTime = this.smoothstep(this.getNormTime(openTicks, 0.0f, 10.0f));
                this.set(trans, 0.0f, 0.25f * smoothTime, 0.0f);
            } else {
                this.set(trans, 0.0f, 0.0f, 0.0f);
            }
        }

        @Override
        public void getOrigin(String partName, float[] orig) {
            if ("Hatch".equals(partName)) {
                this.set(orig, 0.0f, 0.875f, -1.875f);
            } else {
                this.set(orig, 0.0f, 0.0f, 0.0f);
            }
        }

        @Override
        public void getRotation(String partName, float openTicks, float[] rot) {
            if ("Hatch".equals(partName)) {
                float smoothTime = this.smoothstep(this.getNormTime(openTicks, 20.0f, 100.0f));
                this.set(rot, smoothTime * -240.0f, 0.0f, 0.0f);
            } else {
                super.getRotation(partName, openTicks, rot);
            }
        }

        @Override
        public float getDoorRangeOpenTime(int ticks, int idx) {
            return this.getNormTime(ticks, 0.0f, 20.0f);
        }

        @Override
        public int getBlockOffset() {
            return 2;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{1, 0, 1, -3, 3, 0}, {0, 0, 1, -3, 3, 0}, {-1, 0, 1, -3, 3, 0}};
        }

        @Override
        public List<AABB> getCollisionBounds(float progress, Direction facing) {
            ArrayList<AABB> bounds = new ArrayList<AABB>();
            if (progress >= 0.99f) {
                return bounds;
            }
            if ((double)progress < 0.5) {
                AABB hatch = new AABB(-1.0, 2.0, -1.0, 2.0, 3.0, 2.0);
                bounds.add(11.rotateAABB(hatch, facing));
            }
            return bounds;
        }

        private float smoothstep(float t) {
            return t * t * (3.0f - 2.0f * t);
        }

        @Override
        public SoundEvent getOpenSoundEnd() {
            return (SoundEvent)ModSounds.WGH_STOP.get();
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return (SoundEvent)ModSounds.WGH_START.get();
        }

        @Override
        public SoundEvent getCloseSoundEnd() {
            return (SoundEvent)ModSounds.WGH_STOP.get();
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }
    };
    public static final DoorDecl SILO_HATCH_LARGE = new DoorDecl(){

        @Override
        public ResourceLocation getBlockId() {
            return ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"silo_hatch_large");
        }

        @Override
        public int getOpenTime() {
            return 60;
        }

        @Override
        public boolean remoteControllable() {
            return true;
        }

        @Override
        public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
            if ("Hatch".equals(partName)) {
                float smoothTime = this.smoothstep(this.getNormTime(openTicks, 0.0f, 10.0f));
                this.set(trans, 0.0f, 0.25f * smoothTime, 0.0f);
            } else {
                this.set(trans, 0.0f, 0.0f, 0.0f);
            }
        }

        @Override
        public void getOrigin(String partName, float[] orig) {
            if ("Hatch".equals(partName)) {
                this.set(orig, 0.0f, 0.875f, -2.875f);
            } else {
                this.set(orig, 0.0f, 0.0f, 0.0f);
            }
        }

        @Override
        public void getRotation(String partName, float openTicks, float[] rot) {
            if ("Hatch".equals(partName)) {
                float smoothTime = this.smoothstep(this.getNormTime(openTicks, 20.0f, 100.0f));
                this.set(rot, smoothTime * -240.0f, 0.0f, 0.0f);
            } else {
                super.getRotation(partName, openTicks, rot);
            }
        }

        @Override
        public float getDoorRangeOpenTime(int ticks, int idx) {
            return this.getNormTime(ticks, 0.0f, 20.0f);
        }

        @Override
        public int getBlockOffset() {
            return 3;
        }

        @Override
        public int[][] getDoorOpenRanges() {
            return new int[][]{{2, 0, 1, -3, 3, 0}, {1, 0, 2, -5, 3, 0}, {0, 0, 2, -5, 3, 0}, {-1, 0, 2, -5, 3, 0}, {-2, 0, 1, -3, 3, 0}};
        }

        @Override
        public List<AABB> getCollisionBounds(float progress, Direction facing) {
            ArrayList<AABB> bounds = new ArrayList<AABB>();
            if (progress >= 0.99f) {
                return bounds;
            }
            if ((double)progress < 0.5) {
                AABB hatch = new AABB(-2.0, 3.0, -2.0, 3.0, 4.0, 3.0);
                bounds.add(12.rotateAABB(hatch, facing));
            }
            return bounds;
        }

        private float smoothstep(float t) {
            return t * t * (3.0f - 2.0f * t);
        }

        @Override
        public SoundEvent getOpenSoundEnd() {
            return (SoundEvent)ModSounds.WGH_STOP.get();
        }

        @Override
        public SoundEvent getOpenSoundLoop() {
            return (SoundEvent)ModSounds.WGH_START.get();
        }

        @Override
        public SoundEvent getCloseSoundEnd() {
            return (SoundEvent)ModSounds.WGH_STOP.get();
        }

        @Override
        public float getSoundVolume() {
            return 2.0f;
        }
    };

    public abstract int getOpenTime();

    public abstract int[][] getDoorOpenRanges();

    public int[] getDimensions() {
        int[] nArray;
        switch (this.getBlockId().m_135815_()) {
            case "large_vehicle_door": {
                int[] nArray2 = new int[6];
                nArray2[0] = -3;
                nArray2[1] = 0;
                nArray2[2] = 0;
                nArray2[3] = 6;
                nArray2[4] = 5;
                nArray = nArray2;
                nArray2[5] = 0;
                break;
            }
            case "round_airlock_door": {
                int[] nArray3 = new int[6];
                nArray3[0] = -1;
                nArray3[1] = 0;
                nArray3[2] = 0;
                nArray3[3] = 3;
                nArray3[4] = 3;
                nArray = nArray3;
                nArray3[5] = 0;
                break;
            }
            case "transition_seal": {
                int[] nArray4 = new int[6];
                nArray4[0] = -12;
                nArray4[1] = 0;
                nArray4[2] = 0;
                nArray4[3] = 25;
                nArray4[4] = 23;
                nArray = nArray4;
                nArray4[5] = 0;
                break;
            }
            case "fire_door": {
                int[] nArray5 = new int[6];
                nArray5[0] = -1;
                nArray5[1] = 0;
                nArray5[2] = 0;
                nArray5[3] = 3;
                nArray5[4] = 2;
                nArray = nArray5;
                nArray5[5] = 0;
                break;
            }
            case "sliding_blast_door": {
                int[] nArray6 = new int[6];
                nArray6[0] = -3;
                nArray6[1] = 0;
                nArray6[2] = 0;
                nArray6[3] = 6;
                nArray6[4] = 3;
                nArray = nArray6;
                nArray6[5] = 0;
                break;
            }
            case "sliding_seal_door": {
                int[] nArray7 = new int[6];
                nArray7[0] = 0;
                nArray7[1] = 0;
                nArray7[2] = 0;
                nArray7[3] = 0;
                nArray7[4] = 1;
                nArray = nArray7;
                nArray7[5] = 0;
                break;
            }
            case "secure_access_door": {
                int[] nArray8 = new int[6];
                nArray8[0] = -2;
                nArray8[1] = 0;
                nArray8[2] = 0;
                nArray8[3] = 4;
                nArray8[4] = 4;
                nArray = nArray8;
                nArray8[5] = 0;
                break;
            }
            case "qe_sliding_door": {
                int[] nArray9 = new int[6];
                nArray9[0] = 0;
                nArray9[1] = 0;
                nArray9[2] = 0;
                nArray9[3] = 1;
                nArray9[4] = 1;
                nArray = nArray9;
                nArray9[5] = 0;
                break;
            }
            case "qe_containment_door": {
                int[] nArray10 = new int[6];
                nArray10[0] = -1;
                nArray10[1] = 0;
                nArray10[2] = 0;
                nArray10[3] = 2;
                nArray10[4] = 2;
                nArray = nArray10;
                nArray10[5] = 0;
                break;
            }
            case "water_door": {
                int[] nArray11 = new int[6];
                nArray11[0] = -1;
                nArray11[1] = 0;
                nArray11[2] = 0;
                nArray11[3] = 2;
                nArray11[4] = 2;
                nArray = nArray11;
                nArray11[5] = 0;
                break;
            }
            case "silo_hatch": {
                int[] nArray12 = new int[6];
                nArray12[0] = -2;
                nArray12[1] = 0;
                nArray12[2] = -2;
                nArray12[3] = 4;
                nArray12[4] = 0;
                nArray = nArray12;
                nArray12[5] = 4;
                break;
            }
            case "silo_hatch_large": {
                int[] nArray13 = new int[6];
                nArray13[0] = -3;
                nArray13[1] = 0;
                nArray13[2] = -3;
                nArray13[3] = 6;
                nArray13[4] = 0;
                nArray = nArray13;
                nArray13[5] = 6;
                break;
            }
            default: {
                int[] nArray14 = new int[6];
                nArray14[0] = 0;
                nArray14[1] = 0;
                nArray14[2] = 0;
                nArray14[3] = 0;
                nArray14[4] = 1;
                nArray = nArray14;
                nArray14[5] = 0;
            }
        }
        return nArray;
    }

    public abstract ResourceLocation getBlockId();

    public abstract List<AABB> getCollisionBounds(float var1, Direction var2);

    public void setPartsFromModel(String[] partNames, Map<String, BakedModel> parts) {
        this.cachedPartNames = partNames;
        this.modelCache.putAll(parts);
        this.cachedModelParts = new BakedModel[partNames.length];
        for (int i = 0; i < partNames.length; ++i) {
            this.cachedModelParts[i] = parts.get(partNames[i]);
        }
        MainRegistry.LOGGER.debug("DoorDecl: Set {} parts from DoorBakedModel for door {}", (Object)partNames.length, (Object)this.getBlockId());
    }

    public String[] getPartNames() {
        if (this.cachedPartNames == null) {
            MainRegistry.LOGGER.warn("DoorDecl.getPartNames() called before model loaded for {}, using fallback", (Object)this.getBlockId());
            return new String[]{"frame", "door"};
        }
        return this.cachedPartNames;
    }

    @Nullable
    public BakedModel[] getModelParts() {
        if (this.cachedModelParts != null) {
            return this.cachedModelParts;
        }
        try {
            ModelManager modelManager = Minecraft.m_91087_().m_91304_();
            ModelResourceLocation modelLocation = new ModelResourceLocation(this.getBlockId(), "");
            BakedModel baseModel = modelManager.m_119422_(modelLocation);
            if (baseModel instanceof DoorBakedModel) {
                DoorBakedModel doorModel = (DoorBakedModel)baseModel;
                String[] partNames = this.getPartNames();
                this.cachedModelParts = new BakedModel[partNames.length];
                for (int i = 0; i < partNames.length; ++i) {
                    BakedModel partModel;
                    String partName = partNames[i];
                    this.cachedModelParts[i] = partModel = doorModel.getPart(partName);
                    this.modelCache.put(partName, partModel);
                }
                return this.cachedModelParts;
            }
            MainRegistry.LOGGER.error("Expected DoorBakedModel but got: {}", (Object)(baseModel != null ? baseModel.getClass().getSimpleName() : "null"));
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Error loading door model parts", (Throwable)e);
        }
        return null;
    }

    public void setPartAABBs(Map<String, AABB> aabbs) {
        this.cachedPartAABBs = new HashMap<String, AABB>(aabbs);
    }

    @Nullable
    public AABB getPartAABB(String partName) {
        return this.cachedPartAABBs.get(partName);
    }

    public Map<String, AABB> getAllPartAABBs() {
        return Collections.unmodifiableMap(this.cachedPartAABBs);
    }

    public boolean hasPartAABBs() {
        return !this.cachedPartAABBs.isEmpty();
    }

    @Nullable
    public BakedModel getModelPart(String partName) {
        if (this.modelCache.containsKey(partName)) {
            return this.modelCache.get(partName);
        }
        try {
            DoorBakedModel doorModel;
            BakedModel partModel;
            ModelManager modelManager = Minecraft.m_91087_().m_91304_();
            ModelResourceLocation modelLocation = new ModelResourceLocation(this.getBlockId(), "");
            BakedModel baseModel = modelManager.m_119422_(modelLocation);
            if (baseModel instanceof DoorBakedModel && (partModel = (doorModel = (DoorBakedModel)baseModel).getPart(partName)) != null) {
                this.modelCache.put(partName, partModel);
                return partModel;
            }
            MainRegistry.LOGGER.warn("Could not find part '{}' in door model", (Object)partName);
            return null;
        }
        catch (Exception e) {
            MainRegistry.LOGGER.error("Error loading door part model for '{}'", (Object)partName, (Object)e);
            return null;
        }
    }

    public ResourceLocation getTextureForPart(int skinIndex, String partName) {
        BakedModel model = this.getModelPart(partName);
        if (model != null && !model.m_213637_(null, null, null).isEmpty()) {
            return model.m_6160_().m_247685_();
        }
        return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/atlas/blocks.png");
    }

    public ResourceLocation getTextureForPart(String partName) {
        return this.getTextureForPart(0, partName);
    }

    public int getBlockOffset() {
        return 0;
    }

    public boolean remoteControllable() {
        return false;
    }

    public float getDoorRangeOpenTime(int currentTick, int rangeIndex) {
        return this.getNormTime(currentTick);
    }

    public boolean hasSkins() {
        return false;
    }

    public int getSkinCount() {
        return 0;
    }

    public boolean isLadder(boolean open) {
        return false;
    }

    public AABB getBlockBound(int x, int y, int z, boolean open, boolean forCollision) {
        if (open) {
            return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        return new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Nullable
    public SoundEvent getOpenSoundStart() {
        return null;
    }

    @Nullable
    public SoundEvent getOpenSoundEnd() {
        return null;
    }

    @Nullable
    public SoundEvent getOpenSoundLoop() {
        return null;
    }

    @Nullable
    public SoundEvent getCloseSoundStart() {
        return this.getOpenSoundStart();
    }

    @Nullable
    public SoundEvent getCloseSoundEnd() {
        return this.getOpenSoundEnd();
    }

    @Nullable
    public SoundEvent getCloseSoundLoop() {
        return this.getOpenSoundLoop();
    }

    @Nullable
    public SoundEvent getSoundLoop2() {
        return null;
    }

    public float getSoundVolume() {
        return 1.0f;
    }

    public double getRenderRadius() {
        return 8.0;
    }

    public Component getLockedMessage() {
        return Component.m_237115_((String)"door.locked");
    }

    public void doOffsetTransform(LegacyAnimator animator) {
    }

    public double[][] getClippingPlanes() {
        return new double[0][];
    }

    public void getTranslation(String partName, float openTicks, boolean child, float[] trans) {
        trans[0] = 0.0f;
        trans[1] = 0.0f;
        trans[2] = 0.0f;
    }

    public void getOrigin(String partName, float[] orig) {
        orig[0] = 0.0f;
        orig[1] = 0.0f;
        orig[2] = 0.0f;
    }

    public void getRotation(String partName, float openTicks, float[] rot) {
        rot[0] = 0.0f;
        rot[1] = 0.0f;
        rot[2] = 0.0f;
    }

    public boolean doesRender(String partName, boolean child) {
        return true;
    }

    public String[] getChildren(String partName) {
        return new String[0];
    }

    protected float getNormTime(float time) {
        return this.getNormTime(time, 0.0f, this.getOpenTime());
    }

    protected float getNormTime(float time, float min, float max) {
        if (max - min == 0.0f) {
            return 0.0f;
        }
        return Math.max(0.0f, Math.min(1.0f, (time - min) / (max - min)));
    }

    protected void set(float[] array, float x, float y, float z) {
        array[0] = x;
        array[1] = y;
        array[2] = z;
    }

    protected double[] getDoorCenter() {
        int[] dims = this.getDimensions();
        int offsetX = dims[0];
        int offsetZ = dims[2];
        int sizeX = dims[3];
        int sizeZ = dims[5];
        double centerX = (double)(offsetX + (offsetX + sizeX)) / 2.0;
        double centerZ = (double)(offsetZ + (offsetZ + sizeZ)) / 2.0;
        return new double[]{centerX, centerZ};
    }

    protected static AABB rotateAABB(AABB bb, Direction facing) {
        double[][] pts = new double[][]{{bb.f_82288_, bb.f_82290_}, {bb.f_82291_, bb.f_82290_}, {bb.f_82288_, bb.f_82293_}, {bb.f_82291_, bb.f_82293_}};
        double minX = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (double[] p : pts) {
            double rx;
            double x = p[0];
            double z = p[1];
            double rz = switch (facing) {
                case Direction.SOUTH -> {
                    rx = -x;
                    yield -z;
                }
                case Direction.WEST -> {
                    rx = z;
                    yield -x;
                }
                case Direction.EAST -> {
                    rx = -z;
                    yield x;
                }
                default -> {
                    rx = x;
                    yield z;
                }
            };
            if (rx < minX) {
                minX = rx;
            }
            if (rx > maxX) {
                maxX = rx;
            }
            if (rz < minZ) {
                minZ = rz;
            }
            if (!(rz > maxZ)) continue;
            maxZ = rz;
        }
        return new AABB(minX, bb.f_82289_, minZ, maxX, bb.f_82292_, maxZ);
    }

    public List<AABB> getLocalDynamicBoxes(float progress) {
        int[] d = this.getDimensions();
        double ox = d[0];
        double oy = d[1];
        double oz = d[2];
        int sx = d[3];
        int sy = d[4];
        int sz = d[5];
        double minX = ox;
        double maxX = ox + (double)sx + 1.0;
        double minY = oy;
        double maxY = oy + (double)sy + 1.0;
        double minZ = oz;
        double maxZ = oz + (double)(sz == 0 ? 1 : sz + 1);
        double totalWidth = maxX - minX;
        double half = totalWidth / 2.0;
        double centerX = minX + half;
        double move = (double)Math.min(Math.max(progress, 0.0f), 1.0f) * half;
        double cutLeft = centerX - move;
        double cutRight = centerX + move;
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        for (double x = minX; x < maxX; x += 1.0) {
            double rightPartMinX;
            double cellMinX = x;
            double cellMaxX = x + 1.0;
            double leftPartMaxX = Math.min(cellMaxX, cutLeft);
            if (leftPartMaxX - cellMinX > 1.0E-6) {
                boxes.add(new AABB(cellMinX, minY, minZ, leftPartMaxX, maxY, maxZ));
            }
            if (!(cellMaxX - (rightPartMinX = Math.max(cellMinX, cutRight)) > 1.0E-6)) continue;
            boxes.add(new AABB(rightPartMinX, minY, minZ, cellMaxX, maxY, maxZ));
        }
        return boxes;
    }
}

