/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity;

import com.hbm_m.block.entity.DoorDecl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DoorDeclRegistry {
    private static final Map<String, DoorDecl> REGISTRY = new HashMap<String, DoorDecl>();

    public static void register(String id, DoorDecl decl) {
        REGISTRY.put(id, decl);
    }

    public static Map<String, DoorDecl> getAll() {
        return Collections.unmodifiableMap(REGISTRY);
    }

    public static boolean contains(String id) {
        return REGISTRY.containsKey(id);
    }

    public static DoorDecl getById(String id) {
        return REGISTRY.getOrDefault(id, DoorDecl.LARGE_VEHICLE_DOOR);
    }

    public static void init() {
        DoorDeclRegistry.register("large_vehicle_door", DoorDecl.LARGE_VEHICLE_DOOR);
        DoorDeclRegistry.register("round_airlock_door", DoorDecl.ROUND_AIRLOCK_DOOR);
        DoorDeclRegistry.register("transition_seal", DoorDecl.TRANSITION_SEAL);
        DoorDeclRegistry.register("fire_door", DoorDecl.FIRE_DOOR);
        DoorDeclRegistry.register("sliding_blast_door", DoorDecl.SLIDE_DOOR);
        DoorDeclRegistry.register("sliding_seal_door", DoorDecl.SLIDING_SEAL_DOOR);
        DoorDeclRegistry.register("secure_access_door", DoorDecl.SECURE_ACCESS_DOOR);
        DoorDeclRegistry.register("qe_sliding_door", DoorDecl.QE_SLIDING);
        DoorDeclRegistry.register("qe_containment_door", DoorDecl.QE_CONTAINMENT);
        DoorDeclRegistry.register("water_door", DoorDecl.WATER_DOOR);
        DoorDeclRegistry.register("silo_hatch", DoorDecl.SILO_HATCH);
        DoorDeclRegistry.register("silo_hatch_large", DoorDecl.SILO_HATCH_LARGE);
    }
}

