/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity;

import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.sound.ModSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class MineBlockEntity
extends BlockEntity {
    private static final double DETECTION_RADIUS = 10.0;
    private static final int SOUND_COOLDOWN = 18000;
    private int soundCooldown = 0;
    private boolean hasPlayedWarning = false;

    public MineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MINE_BLOCK_ENTITY.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T blockEntity) {
        if (!(blockEntity instanceof MineBlockEntity)) {
            return;
        }
        MineBlockEntity mine = (MineBlockEntity)blockEntity;
        if (level == null || level.f_46443_) {
            return;
        }
        AABB searchArea = new AABB(blockPos).m_82400_(10.0);
        List entities = level.m_6443_(LivingEntity.class, searchArea, e -> {
            Player player;
            return !(e instanceof Player && (player = (Player)e).m_7500_());
        });
        if (!entities.isEmpty()) {
            if (mine.soundCooldown == 0) {
                mine.playWarningSound(level, blockPos);
                mine.soundCooldown = 18000;
                mine.hasPlayedWarning = true;
            }
        } else {
            mine.hasPlayedWarning = false;
        }
        if (mine.soundCooldown > 0) {
            --mine.soundCooldown;
        }
        for (LivingEntity entityInRange : entities) {
            double distance = entityInRange.m_20275_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
            if (!(distance < 1.2)) continue;
            level.m_255391_(null, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, 3.5f, true, Level.ExplosionInteraction.NONE);
            level.m_7471_(blockPos, false);
            break;
        }
    }

    private void playWarningSound(Level level, BlockPos blockPos) {
        if (level != null && ModSounds.GRENADE_TRIGGER.isPresent()) {
            level.m_6263_(null, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, (SoundEvent)ModSounds.GRENADE_TRIGGER.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("SoundCooldown", this.soundCooldown);
        tag.m_128379_("HasPlayedWarning", this.hasPlayedWarning);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.soundCooldown = tag.m_128451_("SoundCooldown");
        this.hasPlayedWarning = tag.m_128471_("HasPlayedWarning");
    }
}

