/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity;

import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.sound.ModSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class MineNukeBlockEntity
extends BlockEntity {
    private static final double DETECTION_RADIUS = 5.0;
    private static final int SOUND_COOLDOWN = 60;
    private int soundCooldown = 0;
    private boolean hasPlayedWarning = false;

    public MineNukeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MINE_NUKE_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(BlockEntity entity) {
        if (!(entity instanceof MineNukeBlockEntity)) {
            return;
        }
        MineNukeBlockEntity mine = (MineNukeBlockEntity)entity;
        if (mine.m_58904_() == null || mine.m_58904_().f_46443_) {
            return;
        }
        AABB searchArea = new AABB(mine.m_58899_()).m_82400_(5.0);
        List entities = mine.m_58904_().m_6443_(LivingEntity.class, searchArea, e -> {
            Player player;
            return !(e instanceof Player && (player = (Player)e).m_7500_());
        });
        if (!entities.isEmpty()) {
            if (mine.soundCooldown == 0) {
                mine.playWarningSound();
                mine.soundCooldown = 60;
                mine.hasPlayedWarning = true;
            }
        } else {
            mine.hasPlayedWarning = false;
        }
        if (mine.soundCooldown > 0) {
            --mine.soundCooldown;
        }
        for (LivingEntity entityInRange : entities) {
            double distance = entityInRange.m_20275_((double)mine.m_58899_().m_123341_() + 0.5, (double)mine.m_58899_().m_123342_() + 0.5, (double)mine.m_58899_().m_123343_() + 0.5);
            if (!(distance < 1.2)) continue;
            Level level = mine.m_58904_();
            BlockPos pos = mine.m_58899_();
            level.m_255391_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 8.0f, true, Level.ExplosionInteraction.TNT);
            level.m_7471_(pos, false);
            break;
        }
    }

    private void playWarningSound() {
        if (this.f_58857_ != null && ModSounds.GRENADE_TRIGGER.isPresent()) {
            this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, (SoundEvent)ModSounds.GRENADE_TRIGGER.get(), SoundSource.BLOCKS, 3.0f, 3.0f);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("SoundCooldown", this.soundCooldown);
        tag.m_128379_("HasPlayedWarning", this.hasPlayedWarning);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.soundCooldown = tag.m_128451_("SoundCooldown");
        this.hasPlayedWarning = tag.m_128471_("HasPlayedWarning");
    }
}

