/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity;

import com.hbm_m.api.energy.EnergyNetworkManager;
import com.hbm_m.api.energy.IEnergyConnector;
import com.hbm_m.block.SwitchBlock;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.capability.ModCapabilities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class SwitchBlockEntity
extends BlockEntity
implements IEnergyConnector {
    private final LazyOptional<IEnergyConnector> hbmConnector = LazyOptional.of(() -> this);

    public SwitchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SWITCH_BE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SwitchBlockEntity entity) {
        ServerLevel serverLevel;
        EnergyNetworkManager manager;
        if (level.f_46443_) {
            return;
        }
        if (((Boolean)state.m_61143_((Property)SwitchBlock.POWERED)).booleanValue() && !(manager = EnergyNetworkManager.get(serverLevel = (ServerLevel)level)).hasNode(pos)) {
            manager.addNode(pos);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.HBM_ENERGY_CONNECTOR && this.isValidSide(side)) {
            return this.hbmConnector.cast();
        }
        return super.getCapability(cap, side);
    }

    private boolean isValidSide(@Nullable Direction side) {
        BlockState state = this.m_58900_();
        if (!(state.m_60734_() instanceof SwitchBlock)) {
            return false;
        }
        if (!((Boolean)state.m_61143_((Property)SwitchBlock.POWERED)).booleanValue()) {
            return false;
        }
        if (side == null) {
            return true;
        }
        Direction facing = (Direction)state.m_61143_((Property)SwitchBlock.FACING);
        return side == facing || side == facing.m_122424_();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.hbmConnector.invalidate();
    }

    @Override
    public boolean canConnectEnergy(Direction side) {
        return this.isValidSide(side);
    }

    public void m_142339_(Level pLevel) {
        super.m_142339_(pLevel);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            EnergyNetworkManager.get((ServerLevel)this.f_58857_).removeNode(this.m_58899_());
        }
        this.hbmConnector.invalidate();
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            EnergyNetworkManager.get((ServerLevel)this.f_58857_).removeNode(this.m_58899_());
        }
    }
}

