/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity.machine;

import com.hbm_m.api.energy.EnergyNetworkManager;
import com.hbm_m.api.energy.IEnergyConnector;
import com.hbm_m.api.energy.IEnergyProvider;
import com.hbm_m.api.energy.IEnergyReceiver;
import com.hbm_m.api.energy.PackedEnergyCapabilityProvider;
import com.hbm_m.capability.ModCapabilities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMachineBlockEntity
extends BlockEntity
implements MenuProvider,
IEnergyProvider,
IEnergyReceiver {
    protected final ItemStackHandler inventory;
    protected LazyOptional<IItemHandler> itemHandler = LazyOptional.empty();
    protected long energy = 0L;
    protected final long capacity;
    protected final long maxReceive;
    protected final long maxExtract;
    private long lastEnergy = 0L;
    private long energyDelta = 0L;
    protected boolean networkInitialized = false;
    private final LazyOptional<IEnergyProvider> hbmProvider = LazyOptional.of(() -> this);
    private final LazyOptional<IEnergyReceiver> hbmReceiver = LazyOptional.of(() -> this);
    private final LazyOptional<IEnergyConnector> hbmConnector = LazyOptional.of(() -> this);
    private final PackedEnergyCapabilityProvider feCapabilityProvider;

    public BaseMachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize, long capacity, long receiveRate) {
        this(type, pos, state, inventorySize, capacity, receiveRate, 0L);
    }

    public BaseMachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize, long capacity, long maxReceive, long maxExtract) {
        super(type, pos, state);
        this.inventory = this.createInventoryHandler(inventorySize);
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.feCapabilityProvider = new PackedEnergyCapabilityProvider(this);
    }

    protected ItemStackHandler createInventoryHandler(int size) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                BaseMachineBlockEntity.this.m_6596_();
                if (BaseMachineBlockEntity.this.isCriticalSlot(slot)) {
                    BaseMachineBlockEntity.this.sendUpdateToClient();
                }
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return BaseMachineBlockEntity.this.isItemValidForSlot(slot, stack);
            }
        };
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    protected abstract Component getDefaultName();

    protected abstract boolean isItemValidForSlot(int var1, ItemStack var2);

    protected boolean isCriticalSlot(int slot) {
        return false;
    }

    @Override
    public long getEnergyStored() {
        return this.energy;
    }

    @Override
    public long getMaxEnergyStored() {
        return this.capacity;
    }

    @Override
    public void setEnergyStored(long energy) {
        this.energy = Math.max(0L, Math.min(this.capacity, energy));
        this.m_6596_();
    }

    @Override
    public long getProvideSpeed() {
        return this.maxExtract;
    }

    @Override
    public long getReceiveSpeed() {
        return this.maxReceive;
    }

    @Override
    public IEnergyReceiver.Priority getPriority() {
        return IEnergyReceiver.Priority.NORMAL;
    }

    @Override
    public boolean canConnectEnergy(Direction side) {
        return true;
    }

    @Override
    public long extractEnergy(long maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0L;
        }
        long energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate && energyExtracted > 0L) {
            this.setEnergyStored(this.energy - energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public boolean canExtract() {
        return this.maxExtract > 0L && this.energy > 0L;
    }

    @Override
    public long receiveEnergy(long maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0L;
        }
        long energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate && energyReceived > 0L) {
            this.setEnergyStored(this.energy + energyReceived);
        }
        return energyReceived;
    }

    @Override
    public boolean canReceive() {
        return this.maxReceive > 0L && this.energy < this.capacity;
    }

    protected void updateEnergyDelta(long currentEnergy) {
        this.energyDelta = currentEnergy - this.lastEnergy;
        this.lastEnergy = currentEnergy;
    }

    public long getEnergyDelta() {
        return this.energyDelta;
    }

    public NonNullList<ItemStack> getGhostItems() {
        return NonNullList.m_122779_();
    }

    public static NonNullList<ItemStack> createGhostItemsFromIngredients(List<Ingredient> ingredients) {
        NonNullList ghostItems = NonNullList.m_122779_();
        for (Ingredient ingredient : ingredients) {
            ItemStack[] matchingStacks = ingredient.m_43908_();
            if (matchingStacks.length <= 0) continue;
            ghostItems.add((Object)matchingStacks[0].m_41777_());
        }
        return ghostItems;
    }

    protected void setupFluidCapability() {
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128356_("energy", this.energy);
        tag.m_128356_("lastEnergy", this.lastEnergy);
        tag.m_128356_("energyDelta", this.energyDelta);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("inventory"));
        this.energy = tag.m_128454_("energy");
        this.lastEnergy = tag.m_128454_("lastEnergy");
        this.energyDelta = tag.m_128454_("energyDelta");
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    protected void sendUpdateToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && !this.m_58901_()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.HBM_ENERGY_PROVIDER) {
            return this.hbmProvider.cast();
        }
        if (cap == ModCapabilities.HBM_ENERGY_RECEIVER) {
            return this.hbmReceiver.cast();
        }
        if (cap == ModCapabilities.HBM_ENERGY_CONNECTOR) {
            return this.hbmConnector.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        LazyOptional<T> feCap = this.feCapabilityProvider.getCapability(cap, side);
        if (feCap.isPresent()) {
            return feCap;
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.itemHandler = LazyOptional.of(() -> this.inventory);
        this.setupFluidCapability();
    }

    protected void ensureNetworkInitialized() {
        if (!this.networkInitialized && this.f_58857_ != null && !this.f_58857_.f_46443_) {
            EnergyNetworkManager.get((ServerLevel)this.f_58857_).addNode(this.m_58899_());
            this.networkInitialized = true;
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
        this.hbmProvider.invalidate();
        this.hbmReceiver.invalidate();
        this.hbmConnector.invalidate();
        this.feCapabilityProvider.invalidate();
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            EnergyNetworkManager.get((ServerLevel)this.f_58857_).removeNode(this.m_58899_());
        }
    }

    public void m_142339_(Level pLevel) {
        super.m_142339_(pLevel);
    }
}

