/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity.machine;

import com.hbm_m.api.energy.EnergyNetworkManager;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.block.entity.machine.BaseMachineBlockEntity;
import com.hbm_m.block.machine.MachineAdvancedAssemblerBlock;
import com.hbm_m.capability.ModCapabilities;
import com.hbm_m.client.ClientSoundManager;
import com.hbm_m.item.ItemCreativeBattery;
import com.hbm_m.item.tools.ItemBlueprintFolder;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.menu.MachineAdvancedAssemblerMenu;
import com.hbm_m.module.machine.MachineModuleAdvancedAssembler;
import com.hbm_m.multiblock.IFrameSupportable;
import com.hbm_m.multiblock.MultiblockStructureHelper;
import com.hbm_m.multiblock.PartRole;
import com.hbm_m.recipe.AssemblerRecipe;
import com.hbm_m.sound.AdvancedAssemblerSoundInstance;
import com.hbm_m.sound.ModSounds;
import com.hbm_m.util.LongDataPacker;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MachineAdvancedAssemblerBlockEntity
extends BaseMachineBlockEntity
implements IFrameSupportable {
    private static final int SLOT_COUNT = 17;
    private static final int ENERGY_SLOT = 0;
    private static final int BLUEPRINT_FOLDER_SLOT = 1;
    private static final int OUTPUT_SLOT_START = 2;
    private static final int OUTPUT_SLOT_END = 3;
    private static final int INPUT_SLOT_START = 4;
    private static final int INPUT_SLOT_END = 15;
    private static final int STAMPING_SLOT = 16;
    private final FluidTank inputTank = new FluidTank(4000);
    private final FluidTank outputTank = new FluidTank(4000);
    protected LazyOptional<IFluidHandler> fluidInputHandler = LazyOptional.empty();
    protected LazyOptional<IFluidHandler> fluidOutputHandler = LazyOptional.empty();
    public boolean frame = false;
    @Nullable
    private ResourceLocation selectedRecipeId = null;
    @Nullable
    private AssemblerRecipe cachedRecipe = null;
    private boolean recipeCacheDirty = false;
    @Nullable
    private MachineModuleAdvancedAssembler assemblerModule = null;
    private boolean clientIsCrafting = false;
    private boolean wasCraftingLastTick = false;
    public long lastUseTick = 0L;
    private boolean needsClientSync = false;
    private int ticksSinceLastSync = 0;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            long currentEnergy = MachineAdvancedAssemblerBlockEntity.this.getEnergyStored();
            long maxEnergy = MachineAdvancedAssemblerBlockEntity.this.getMaxEnergyStored();
            long delta = MachineAdvancedAssemblerBlockEntity.this.getEnergyDelta();
            return switch (index) {
                case 0 -> {
                    if (MachineAdvancedAssemblerBlockEntity.this.assemblerModule != null) {
                        yield MachineAdvancedAssemblerBlockEntity.this.assemblerModule.getProgressInt();
                    }
                    yield 0;
                }
                case 1 -> {
                    if (MachineAdvancedAssemblerBlockEntity.this.assemblerModule != null) {
                        yield MachineAdvancedAssemblerBlockEntity.this.assemblerModule.getMaxProgress();
                    }
                    yield 0;
                }
                case 2 -> LongDataPacker.packHigh(currentEnergy);
                case 3 -> LongDataPacker.packLow(currentEnergy);
                case 4 -> LongDataPacker.packHigh(maxEnergy);
                case 5 -> LongDataPacker.packLow(maxEnergy);
                case 6 -> LongDataPacker.packHigh(delta);
                case 7 -> LongDataPacker.packLow(delta);
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
        }

        public int m_6499_() {
            return 8;
        }
    };
    @OnlyIn(value=Dist.CLIENT)
    public final AssemblerArm[] arms = new AssemblerArm[2];
    @OnlyIn(value=Dist.CLIENT)
    public float ringAngle;
    @OnlyIn(value=Dist.CLIENT)
    public float prevRingAngle;
    @OnlyIn(value=Dist.CLIENT)
    private float ringTarget;
    @OnlyIn(value=Dist.CLIENT)
    private float ringSpeed;
    @OnlyIn(value=Dist.CLIENT)
    private int ringDelay;

    public MachineAdvancedAssemblerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ADVANCED_ASSEMBLY_MACHINE_BE.get(), pos, state, 17, 100000L, 100000L);
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.assemblerModule = new MachineModuleAdvancedAssembler(0, this, (IItemHandler)this.inventory, this.f_58857_);
        }
    }

    @Override
    protected Component getDefaultName() {
        return Component.m_237115_((String)"container.hbm_m.advanced_assembly_machine");
    }

    public Component m_5446_() {
        return this.getDefaultName();
    }

    @Override
    protected void setupFluidCapability() {
        this.fluidInputHandler = LazyOptional.of(() -> this.inputTank);
        this.fluidOutputHandler = LazyOptional.of(() -> this.outputTank);
    }

    @Override
    protected boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
        }
        if (slot == 1) {
            return stack.m_41720_() instanceof ItemBlueprintFolder;
        }
        if (slot >= 2 && slot <= 3) {
            return false;
        }
        if (slot >= 4 && slot <= 15) {
            return this.assemblerModule == null || this.assemblerModule.isItemValidForSlot(slot, stack);
        }
        return slot == 16;
    }

    public AABB getRenderBoundingBox() {
        BlockState state = this.m_58900_();
        Block block = state.m_60734_();
        if (!(block instanceof MachineAdvancedAssemblerBlock)) {
            return new AABB(this.f_58858_.m_7918_(-2, -1, -2), this.f_58858_.m_7918_(3, 4, 3));
        }
        MachineAdvancedAssemblerBlock block2 = (MachineAdvancedAssemblerBlock)block;
        MultiblockStructureHelper structureHelper = block2.getStructureHelper();
        Map<BlockPos, Supplier<BlockState>> structureMap = structureHelper.getStructureMap();
        if (structureMap == null || structureMap.isEmpty()) {
            return new AABB(this.f_58858_.m_7918_(-1, 0, -1), this.f_58858_.m_7918_(2, 3, 2));
        }
        int minX = 0;
        int minY = 0;
        int minZ = 0;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (BlockPos offset : structureMap.keySet()) {
            minX = Math.min(minX, offset.m_123341_());
            minY = Math.min(minY, offset.m_123342_());
            minZ = Math.min(minZ, offset.m_123343_());
            maxX = Math.max(maxX, offset.m_123341_());
            maxY = Math.max(maxY, offset.m_123342_());
            maxZ = Math.max(maxZ, offset.m_123343_());
        }
        double margin = 1.5;
        return new AABB((double)(this.f_58858_.m_123341_() + minX) - margin, (double)(this.f_58858_.m_123342_() + minY) - margin, (double)(this.f_58858_.m_123343_() + minZ) - margin, (double)(this.f_58858_.m_123341_() + maxX + 1) + margin, (double)(this.f_58858_.m_123342_() + maxY + 1) + margin, (double)(this.f_58858_.m_123343_() + maxZ + 1) + margin);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        this.sendUpdateToClient();
        return new MachineAdvancedAssemblerMenu(containerId, playerInventory, this, this.data);
    }

    @Override
    public void checkForFrame() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            MultiblockStructureHelper.updateFrameForController(this.f_58857_, this.f_58858_);
        }
    }

    @Override
    public boolean setFrameVisible(boolean visible) {
        if (this.frame != visible) {
            this.frame = visible;
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.sendUpdateToClient();
                MainRegistry.LOGGER.debug("[FRAME SET] \u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0440\u0430\u043c\u043a\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e \u043d\u0430 " + visible);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isFrameVisible() {
        return this.frame;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MachineAdvancedAssemblerBlockEntity entity) {
        if (level.f_46443_) {
            entity.clientTick(level, pos, state);
        } else {
            entity.serverTick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(Level level, BlockPos pos, BlockState state) {
        ClientSoundManager.updateSound(this, this.isCrafting(), () -> new AdvancedAssemblerSoundInstance(this.m_58899_()));
        this.prevRingAngle = this.ringAngle;
        boolean craftingNow = this.isCrafting();
        if (craftingNow) {
            for (AssemblerArm arm : this.arms) {
                arm.updateInterp();
                arm.updateArm(level, pos, level.f_46441_);
            }
        } else {
            for (AssemblerArm arm : this.arms) {
                arm.updateInterp();
                arm.returnToNullPos();
            }
        }
        if (craftingNow && !this.wasCraftingLastTick) {
            this.ringTarget = (level.f_46441_.m_188501_() * 2.0f - 1.0f) * 135.0f;
            this.ringSpeed = 10.0f + level.f_46441_.m_188501_() * 5.0f;
            this.ringDelay = 0;
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)ModSounds.ASSEMBLER_START.get(), SoundSource.BLOCKS, 0.5f, 1.0f, false);
        }
        this.wasCraftingLastTick = craftingNow;
        if (craftingNow) {
            if (this.ringAngle != this.ringTarget) {
                float ringDelta = Mth.m_14177_((float)(this.ringTarget - this.ringAngle));
                float absDelta = Math.abs(ringDelta);
                if (absDelta <= this.ringSpeed) {
                    this.ringAngle = this.ringTarget;
                    this.ringDelay = 20 + level.f_46441_.m_188503_(21);
                } else {
                    this.ringAngle += Math.signum(ringDelta) * this.ringSpeed;
                }
            } else if (this.ringDelay > 0) {
                --this.ringDelay;
                if (this.ringDelay == 0) {
                    level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)ModSounds.ASSEMBLER_START.get(), SoundSource.BLOCKS, 0.3f, 1.0f, false);
                    this.ringTarget = (level.f_46441_.m_188501_() * 2.0f - 1.0f) * 135.0f;
                    this.ringSpeed = 10.0f + level.f_46441_.m_188501_() * 5.0f;
                }
            }
        } else {
            this.ringAngle = Math.abs(this.ringAngle) > 0.1f ? Mth.m_14179_((float)0.1f, (float)this.ringAngle, (float)0.0f) : 0.0f;
        }
    }

    private void serverTick() {
        this.ensureNetworkInitialized();
        long gameTime = this.f_58857_.m_46467_();
        if (gameTime % 5L == 0L) {
            this.chargeMachineFromBattery();
        }
        if (gameTime % 10L == 0L) {
            this.updateEnergyDelta(this.getEnergyStored());
        }
        if (this.assemblerModule == null && this.f_58857_ != null) {
            this.assemblerModule = new MachineModuleAdvancedAssembler(0, this, (IItemHandler)this.inventory, this.f_58857_);
        }
        if (this.assemblerModule != null) {
            AssemblerRecipe recipe;
            boolean wasCrafting = this.assemblerModule.isProcessing();
            ItemStack blueprintStack = this.inventory.getStackInSlot(1);
            if (this.selectedRecipeId != null && (this.recipeCacheDirty || gameTime % 20L == 0L)) {
                String currentPool;
                String recipePool;
                AssemblerRecipe currentRecipe = this.getCachedRecipe();
                if (currentRecipe != null && wasCrafting && (recipePool = currentRecipe.getBlueprintPool()) != null && !recipePool.isEmpty() && !recipePool.equals(currentPool = ItemBlueprintFolder.getBlueprintPool(blueprintStack))) {
                    this.selectedRecipeId = null;
                    this.cachedRecipe = null;
                    this.assemblerModule.setPreferredRecipe(null);
                    this.assemblerModule.resetProgress();
                    this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.ASSEMBLER_STOP.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
                    this.needsClientSync = true;
                    return;
                }
                this.recipeCacheDirty = false;
            }
            if (this.selectedRecipeId != null && this.assemblerModule.getPreferredRecipe() == null && (recipe = this.getCachedRecipe()) != null) {
                this.assemblerModule.setPreferredRecipe(recipe);
            }
            this.assemblerModule.update(1.0, 1.0, true, blueprintStack);
            boolean isCraftingNow = this.assemblerModule.isProcessing();
            if (isCraftingNow && this.assemblerModule.getPreferredRecipe() != null) {
                ResourceLocation autoSelectedRecipeId = this.assemblerModule.getPreferredRecipe().m_6423_();
                if (this.selectedRecipeId == null || !this.selectedRecipeId.equals((Object)autoSelectedRecipeId)) {
                    this.selectedRecipeId = autoSelectedRecipeId;
                    this.cachedRecipe = this.assemblerModule.getPreferredRecipe();
                    this.recipeCacheDirty = false;
                    this.needsClientSync = true;
                }
            }
            if (this.assemblerModule.getCurrentRecipe() != null) {
                ResourceLocation currentRecipeId = ((AssemblerRecipe)this.assemblerModule.getCurrentRecipe()).m_6423_();
                if (this.selectedRecipeId == null || !this.selectedRecipeId.equals((Object)currentRecipeId)) {
                    this.selectedRecipeId = currentRecipeId;
                    this.cachedRecipe = (AssemblerRecipe)this.assemblerModule.getCurrentRecipe();
                    this.recipeCacheDirty = false;
                    this.needsClientSync = true;
                }
            }
            if (wasCrafting && !isCraftingNow) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.ASSEMBLER_STOP.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            if (wasCrafting != isCraftingNow) {
                this.needsClientSync = true;
            } else if (isCraftingNow) {
                ++this.ticksSinceLastSync;
                if (this.ticksSinceLastSync >= 40) {
                    this.needsClientSync = true;
                }
            }
            if (this.needsClientSync) {
                this.m_6596_();
                this.sendUpdateToClient();
                this.needsClientSync = false;
                this.ticksSinceLastSync = 0;
            }
        }
    }

    private void chargeMachineFromBattery() {
        ItemStack energySourceStack = this.inventory.getStackInSlot(0);
        if (energySourceStack.m_41619_()) {
            return;
        }
        if (energySourceStack.m_41720_() instanceof ItemCreativeBattery) {
            this.setEnergyStored(this.getMaxEnergyStored());
            return;
        }
        energySourceStack.getCapability(ModCapabilities.HBM_ENERGY_PROVIDER).ifPresent(itemEnergy -> {
            long extracted;
            long energyNeeded = this.getMaxEnergyStored() - this.getEnergyStored();
            if (energyNeeded <= 0L) {
                return;
            }
            long maxCanReceive = this.getReceiveSpeed();
            long energyToTransfer = Math.min(energyNeeded, maxCanReceive);
            if (energyToTransfer > 0L && (extracted = itemEnergy.extractEnergy(energyToTransfer, false)) > 0L) {
                this.setEnergyStored(this.getEnergyStored() + extracted);
                this.m_6596_();
            }
        });
        if (!energySourceStack.getCapability(ModCapabilities.HBM_ENERGY_PROVIDER).isPresent()) {
            energySourceStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(itemEnergy -> {
                long energyNeeded = this.getMaxEnergyStored() - this.getEnergyStored();
                if (energyNeeded <= 0L) {
                    return;
                }
                int maxTransfer = (int)Math.min(Integer.MAX_VALUE, Math.min(energyNeeded, this.getReceiveSpeed()));
                int extracted = itemEnergy.extractEnergy(maxTransfer, false);
                if (extracted > 0) {
                    this.setEnergyStored(this.getEnergyStored() + (long)extracted);
                    this.m_6596_();
                }
            });
        }
    }

    @Nullable
    private AssemblerRecipe getCachedRecipe() {
        if (this.selectedRecipeId == null || this.f_58857_ == null) {
            this.cachedRecipe = null;
            return null;
        }
        if (this.cachedRecipe == null || this.recipeCacheDirty) {
            this.cachedRecipe = this.f_58857_.m_7465_().m_44043_(this.selectedRecipeId).filter(recipe -> recipe instanceof AssemblerRecipe).map(recipe -> (AssemblerRecipe)recipe).orElse(null);
            this.recipeCacheDirty = false;
        }
        return this.cachedRecipe;
    }

    public List<AssemblerRecipe> getAvailableRecipes() {
        if (this.f_58857_ == null) {
            return List.of();
        }
        ItemStack folderStack = this.getBlueprintFolder();
        String activePool = ItemBlueprintFolder.getBlueprintPool(folderStack);
        List allRecipes = this.f_58857_.m_7465_().m_44013_((RecipeType)AssemblerRecipe.Type.INSTANCE);
        return allRecipes.stream().filter(recipe -> {
            String recipePool = recipe.getBlueprintPool();
            if (recipePool == null || recipePool.isEmpty()) {
                return true;
            }
            return activePool != null && !activePool.isEmpty() && activePool.equals(recipePool);
        }).toList();
    }

    public void setSelectedRecipe(ResourceLocation recipeId) {
        boolean wasCrafting = this.assemblerModule != null && this.assemblerModule.isProcessing();
        this.selectedRecipeId = recipeId;
        this.recipeCacheDirty = true;
        this.cachedRecipe = null;
        if (this.assemblerModule != null && this.f_58857_ != null) {
            AssemblerRecipe recipe = this.getCachedRecipe();
            this.assemblerModule.setPreferredRecipe(recipe);
            this.assemblerModule.resetProgress();
            if (wasCrafting) {
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.ASSEMBLER_STOP.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        }
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.sendUpdateToClient();
        }
    }

    @Nullable
    public AssemblerRecipe getSelectedRecipe() {
        return this.getCachedRecipe();
    }

    public ResourceLocation getSelectedRecipeId() {
        return this.selectedRecipeId;
    }

    @Override
    public NonNullList<ItemStack> getGhostItems() {
        AssemblerRecipe recipe = null;
        if (this.assemblerModule != null && this.assemblerModule.getPreferredRecipe() != null) {
            recipe = this.assemblerModule.getPreferredRecipe();
        }
        if (recipe == null && this.selectedRecipeId != null && this.f_58857_ != null) {
            recipe = this.getCachedRecipe();
        }
        if (recipe != null) {
            return BaseMachineBlockEntity.createGhostItemsFromIngredients(recipe.m_7527_());
        }
        return NonNullList.m_122779_();
    }

    public ItemStack getBlueprintFolder() {
        return this.inventory.getStackInSlot(1);
    }

    public boolean isCrafting() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return this.clientIsCrafting;
        }
        return this.assemblerModule != null && this.assemblerModule.isProcessing();
    }

    public int getProgress() {
        return this.assemblerModule != null ? this.assemblerModule.getProgressInt() : 0;
    }

    public int getMaxProgress() {
        return this.assemblerModule != null ? this.assemblerModule.getMaxProgress() : 100;
    }

    @Override
    protected boolean isCriticalSlot(int slot) {
        return slot >= 4 && slot <= 15;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("input_tank", (Tag)this.inputTank.writeToNBT(new CompoundTag()));
        tag.m_128365_("output_tank", (Tag)this.outputTank.writeToNBT(new CompoundTag()));
        tag.m_128356_("last_use_tick", this.lastUseTick);
        tag.m_128379_("FrameVisible", this.frame);
        tag.m_128379_("HasRecipe", this.selectedRecipeId != null);
        if (this.selectedRecipeId != null) {
            tag.m_128359_("SelectedRecipe", this.selectedRecipeId.toString());
        }
        if (this.assemblerModule != null) {
            CompoundTag moduleTag = new CompoundTag();
            this.assemblerModule.writeToNBT(moduleTag);
            tag.m_128365_("AssemblerModule", (Tag)moduleTag);
        }
        tag.m_128379_("is_crafting", this.isCrafting());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputTank.readFromNBT(tag.m_128469_("input_tank"));
        this.outputTank.readFromNBT(tag.m_128469_("output_tank"));
        this.lastUseTick = tag.m_128454_("last_use_tick");
        this.frame = tag.m_128471_("FrameVisible");
        this.clientIsCrafting = tag.m_128471_("is_crafting");
        if (tag.m_128441_("HasRecipe") && tag.m_128471_("HasRecipe")) {
            this.selectedRecipeId = ResourceLocation.m_135820_((String)tag.m_128461_("SelectedRecipe"));
            this.recipeCacheDirty = true;
        } else {
            this.selectedRecipeId = null;
            this.cachedRecipe = null;
        }
        if (tag.m_128441_("AssemblerModule") && this.f_58857_ != null) {
            if (this.assemblerModule == null) {
                this.assemblerModule = new MachineModuleAdvancedAssembler(0, this, (IItemHandler)this.inventory, this.f_58857_);
            }
            this.assemblerModule.readFromNBT(tag.m_128469_("AssemblerModule"));
        }
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, be -> tag);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidInputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && this.arms[0] == null) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.initClientArms());
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.assemblerModule == null) {
            this.assemblerModule = new MachineModuleAdvancedAssembler(0, this, (IItemHandler)this.inventory, this.f_58857_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void initClientArms() {
        for (int i = 0; i < this.arms.length; ++i) {
            this.arms[i] = new AssemblerArm();
        }
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidInputHandler.invalidate();
        this.fluidOutputHandler.invalidate();
    }

    @Override
    public void m_7651_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            ClientSoundManager.updateSound(this, false, null);
        }
        super.m_7651_();
    }

    @Override
    protected void ensureNetworkInitialized() {
        Block block;
        if (this.networkInitialized) {
            return;
        }
        super.ensureNetworkInitialized();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (block = this.m_58900_().m_60734_()) instanceof MachineAdvancedAssemblerBlock) {
            MachineAdvancedAssemblerBlock block2 = (MachineAdvancedAssemblerBlock)block;
            MultiblockStructureHelper helper = block2.getStructureHelper();
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)MachineAdvancedAssemblerBlock.FACING);
            EnergyNetworkManager manager = EnergyNetworkManager.get((ServerLevel)this.f_58857_);
            for (BlockPos localPos : helper.getStructureMap().keySet()) {
                if (block2.getPartRole(localPos) != PartRole.ENERGY_CONNECTOR) continue;
                BlockPos partWorldPos = helper.getRotatedPos(this.f_58858_, localPos, facing);
                manager.addNode(partWorldPos);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AssemblerArm {
        public float[] angles = new float[4];
        public float[] prevAngles = new float[4];
        private float[] targetAngles = new float[4];
        private float[] speed = new float[4];
        private ArmActionState state = ArmActionState.ASSUME_POSITION;
        private int actionDelay = 0;
        private static final float[][] POSITIONS = new float[][]{{45.0f, -15.0f, -5.0f}, {15.0f, 15.0f, -15.0f}, {25.0f, 10.0f, -15.0f}, {30.0f, 0.0f, -10.0f}, {70.0f, -10.0f, -25.0f}};

        public AssemblerArm() {
            this.resetSpeed();
        }

        public void updateInterp() {
            System.arraycopy(this.angles, 0, this.prevAngles, 0, this.angles.length);
        }

        public void returnToNullPos() {
            Arrays.fill(this.targetAngles, 0.0f);
            this.speed[2] = 3.0f;
            this.speed[1] = 3.0f;
            this.speed[0] = 3.0f;
            this.speed[3] = 0.25f;
            this.state = ArmActionState.RETRACT_STRIKER;
            this.move();
        }

        private void resetSpeed() {
            this.speed[0] = 15.0f;
            this.speed[1] = 15.0f;
            this.speed[2] = 15.0f;
            this.speed[3] = 0.5f;
        }

        public void updateArm(Level level, BlockPos pos, RandomSource random) {
            this.resetSpeed();
            if (this.actionDelay > 0) {
                --this.actionDelay;
                return;
            }
            switch (this.state) {
                case ASSUME_POSITION: {
                    if (!this.move()) break;
                    this.actionDelay = 2;
                    this.state = ArmActionState.EXTEND_STRIKER;
                    this.targetAngles[3] = -0.75f;
                    break;
                }
                case EXTEND_STRIKER: {
                    if (!this.move()) break;
                    level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)ModSounds.ASSEMBLER_STRIKE_RANDOM.get(), SoundSource.BLOCKS, 0.5f, 1.0f, false);
                    this.state = ArmActionState.RETRACT_STRIKER;
                    this.targetAngles[3] = 0.0f;
                    break;
                }
                case RETRACT_STRIKER: {
                    if (!this.move()) break;
                    this.actionDelay = 2 + random.m_188503_(5);
                    this.chooseNewArmPosition(random);
                    this.state = ArmActionState.ASSUME_POSITION;
                }
            }
        }

        public void chooseNewArmPosition(RandomSource random) {
            int chosen = random.m_188503_(5);
            this.targetAngles[0] = POSITIONS[chosen][0];
            this.targetAngles[1] = POSITIONS[chosen][1];
            this.targetAngles[2] = POSITIONS[chosen][2];
        }

        private boolean move() {
            boolean allReached = true;
            for (int i = 0; i < this.angles.length; ++i) {
                float current = this.angles[i];
                float target = this.targetAngles[i];
                if (current == target) continue;
                allReached = false;
                float delta = target - current;
                float absDelta = Math.abs(delta);
                if (absDelta <= this.speed[i]) {
                    this.angles[i] = target;
                    continue;
                }
                int n = i;
                this.angles[n] = this.angles[n] + Math.signum(delta) * this.speed[i];
            }
            return allReached;
        }

        private static enum ArmActionState {
            ASSUME_POSITION,
            EXTEND_STRIKER,
            RETRACT_STRIKER;

        }
    }
}

