/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity.machine;

import com.hbm_m.api.energy.EnergyNetworkManager;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.block.entity.machine.BaseMachineBlockEntity;
import com.hbm_m.block.entity.machine.UniversalMachinePartBlockEntity;
import com.hbm_m.block.machine.MachineAssemblerBlock;
import com.hbm_m.capability.ModCapabilities;
import com.hbm_m.client.ClientSoundManager;
import com.hbm_m.item.ItemAssemblyTemplate;
import com.hbm_m.item.ItemCreativeBattery;
import com.hbm_m.menu.MachineAssemblerMenu;
import com.hbm_m.multiblock.MultiblockStructureHelper;
import com.hbm_m.multiblock.PartRole;
import com.hbm_m.recipe.AssemblerRecipe;
import com.hbm_m.sound.AssemblerSoundInstance;
import com.hbm_m.util.LongDataPacker;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MachineAssemblerBlockEntity
extends BaseMachineBlockEntity {
    private static final int SLOT_COUNT = 18;
    private static final int ENERGY_SLOT = 0;
    private static final int TEMPLATE_SLOT = 4;
    private static final int OUTPUT_SLOT = 5;
    private static final int INPUT_SLOT_START = 6;
    private static final int INPUT_SLOT_END = 17;
    private boolean isCrafting = false;
    private int progress = 0;
    private int maxProgress = 100;
    private LazyOptional<IItemHandler> lazyInputProxy = LazyOptional.empty();
    private LazyOptional<IItemHandler> lazyOutputProxy = LazyOptional.empty();
    private final Set<BlockPos> lastPullSources = new HashSet<BlockPos>();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            long energy = MachineAssemblerBlockEntity.this.getEnergyStored();
            long maxEnergy = MachineAssemblerBlockEntity.this.getMaxEnergyStored();
            long delta = MachineAssemblerBlockEntity.this.getEnergyDelta();
            return switch (index) {
                case 0 -> MachineAssemblerBlockEntity.this.progress;
                case 1 -> MachineAssemblerBlockEntity.this.maxProgress;
                case 2 -> LongDataPacker.packHigh(energy);
                case 3 -> LongDataPacker.packLow(energy);
                case 4 -> LongDataPacker.packHigh(maxEnergy);
                case 5 -> LongDataPacker.packLow(maxEnergy);
                case 6 -> LongDataPacker.packHigh(delta);
                case 7 -> LongDataPacker.packLow(delta);
                case 8 -> {
                    if (MachineAssemblerBlockEntity.this.isCrafting) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    MachineAssemblerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    MachineAssemblerBlockEntity.this.maxProgress = value;
                    break;
                }
                case 8: {
                    MachineAssemblerBlockEntity.this.isCrafting = value != 0;
                }
            }
        }

        public int m_6499_() {
            return 9;
        }
    };

    public MachineAssemblerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MACHINE_ASSEMBLER_BE.get(), pos, state, 18, 100000L, 100000L);
    }

    @Override
    protected Component getDefaultName() {
        return Component.m_237115_((String)"container.hbm_m.machine_assembler");
    }

    public Component m_5446_() {
        return this.getDefaultName();
    }

    @Override
    protected boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.getCapability(ForgeCapabilities.ENERGY).isPresent() || stack.m_41720_() instanceof ItemCreativeBattery;
        }
        if (slot == 4) {
            return stack.m_41720_() instanceof ItemAssemblyTemplate;
        }
        if (slot == 5) {
            return false;
        }
        return slot >= 6 && slot <= 17;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        this.sendUpdateToClient();
        return new MachineAssemblerMenu(containerId, playerInventory, this, this.data);
    }

    public LazyOptional<IItemHandler> getItemHandlerForPart(PartRole role) {
        if (role == PartRole.ITEM_INPUT) {
            if (!this.lazyInputProxy.isPresent()) {
                this.lazyInputProxy = LazyOptional.of(this::createInputProxy);
            }
            return this.lazyInputProxy;
        }
        if (role == PartRole.ITEM_OUTPUT) {
            if (!this.lazyOutputProxy.isPresent()) {
                this.lazyOutputProxy = LazyOptional.of(this::createOutputProxy);
            }
            return this.lazyOutputProxy;
        }
        return LazyOptional.empty();
    }

    @NotNull
    private IItemHandler createInputProxy() {
        return new IItemHandler(){

            public int getSlots() {
                return 12;
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return MachineAssemblerBlockEntity.this.inventory.getStackInSlot(slot + 6);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return MachineAssemblerBlockEntity.this.inventory.insertItem(slot + 6, stack, simulate);
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.f_41583_;
            }

            public int getSlotLimit(int slot) {
                return MachineAssemblerBlockEntity.this.inventory.getSlotLimit(slot + 6);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return MachineAssemblerBlockEntity.this.inventory.isItemValid(slot + 6, stack);
            }
        };
    }

    @NotNull
    private IItemHandler createOutputProxy() {
        return new IItemHandler(){

            public int getSlots() {
                return 1;
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return slot == 0 ? MachineAssemblerBlockEntity.this.inventory.getStackInSlot(5) : ItemStack.f_41583_;
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return stack;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return slot == 0 ? MachineAssemblerBlockEntity.this.inventory.extractItem(5, amount, simulate) : ItemStack.f_41583_;
            }

            public int getSlotLimit(int slot) {
                return slot == 0 ? MachineAssemblerBlockEntity.this.inventory.getSlotLimit(5) : 0;
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return false;
            }
        };
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MachineAssemblerBlockEntity entity) {
        if (level.f_46443_) {
            entity.clientTick();
        } else {
            entity.serverTick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientTick() {
        ClientSoundManager.updateSound(this, this.isCrafting(), () -> new AssemblerSoundInstance(this.m_58899_()));
    }

    private void serverTick() {
        boolean canInsert;
        boolean hasRecipe;
        Optional<AssemblerRecipe> recipeOpt;
        this.ensureNetworkInitialized();
        long gameTime = this.f_58857_.m_46467_();
        if (gameTime % 5L == 0L) {
            this.chargeFromEnergySlot();
        }
        if (gameTime % 10L == 0L) {
            this.updateEnergyDelta(this.getEnergyStored());
        }
        if ((recipeOpt = this.getRecipeFromTemplate()).isPresent()) {
            this.pullIngredientsForOneCraft(recipeOpt.get());
        }
        boolean hasResources = (hasRecipe = recipeOpt.isPresent()) && this.hasResources(recipeOpt.get());
        boolean bl = canInsert = hasRecipe && this.canInsertResult(recipeOpt.get().m_8043_(null));
        if (hasRecipe && hasResources && canInsert) {
            AssemblerRecipe recipe = recipeOpt.get();
            long energyPerTick = recipe.getPowerConsumption();
            if (this.getEnergyStored() >= energyPerTick) {
                if (!this.isCrafting) {
                    this.isCrafting = true;
                    this.maxProgress = recipe.getDuration();
                    this.m_6596_();
                    this.sendUpdateToClient();
                }
                this.setEnergyStored(this.getEnergyStored() - energyPerTick);
                ++this.progress;
                this.m_6596_();
                if (this.progress >= this.maxProgress) {
                    this.craftItem(recipe);
                    this.progress = 0;
                    this.pushOutputToNeighbors();
                    this.getRecipeFromTemplate().ifPresent(this::pullIngredientsForOneCraft);
                }
            } else {
                this.stopCrafting();
            }
        } else {
            this.stopCrafting();
        }
    }

    private void stopCrafting() {
        if (this.isCrafting) {
            this.progress = 0;
            this.isCrafting = false;
            this.m_6596_();
            this.sendUpdateToClient();
        }
    }

    private void chargeFromEnergySlot() {
        ItemStack energySourceStack = this.inventory.getStackInSlot(0);
        if (energySourceStack.m_41619_()) {
            return;
        }
        if (energySourceStack.m_41720_() instanceof ItemCreativeBattery) {
            this.setEnergyStored(this.getMaxEnergyStored());
            return;
        }
        energySourceStack.getCapability(ModCapabilities.HBM_ENERGY_PROVIDER).ifPresent(itemEnergy -> {
            long extracted;
            long energyNeeded = this.getMaxEnergyStored() - this.getEnergyStored();
            if (energyNeeded <= 0L) {
                return;
            }
            long maxCanReceive = this.getReceiveSpeed();
            long energyToTransfer = Math.min(energyNeeded, maxCanReceive);
            if (energyToTransfer > 0L && (extracted = itemEnergy.extractEnergy(energyToTransfer, false)) > 0L) {
                this.setEnergyStored(this.getEnergyStored() + extracted);
                this.m_6596_();
            }
        });
        if (!energySourceStack.getCapability(ModCapabilities.HBM_ENERGY_PROVIDER).isPresent()) {
            energySourceStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(itemEnergy -> {
                long energyNeeded = this.getMaxEnergyStored() - this.getEnergyStored();
                if (energyNeeded <= 0L) {
                    return;
                }
                int maxTransfer = (int)Math.min(Integer.MAX_VALUE, Math.min(energyNeeded, this.getReceiveSpeed()));
                int extracted = itemEnergy.extractEnergy(maxTransfer, false);
                if (extracted > 0) {
                    this.setEnergyStored(this.getEnergyStored() + (long)extracted);
                    this.m_6596_();
                }
            });
        }
    }

    private Optional<AssemblerRecipe> getRecipeFromTemplate() {
        ItemStack templateStack = this.inventory.getStackInSlot(4);
        if (!(templateStack.m_41720_() instanceof ItemAssemblyTemplate)) {
            return Optional.empty();
        }
        ItemStack outputStack = ItemAssemblyTemplate.getRecipeOutput(templateStack);
        if (outputStack.m_41619_()) {
            return Optional.empty();
        }
        RecipeManager recipeManager = this.f_58857_.m_7465_();
        return recipeManager.m_44013_((RecipeType)AssemblerRecipe.Type.INSTANCE).stream().filter(r -> ItemStack.m_150942_((ItemStack)r.m_8043_(null), (ItemStack)outputStack)).findFirst();
    }

    @Override
    public NonNullList<ItemStack> getGhostItems() {
        Optional<AssemblerRecipe> recipeOpt = this.getRecipeFromTemplate();
        if (recipeOpt.isEmpty()) {
            return NonNullList.m_122779_();
        }
        AssemblerRecipe recipe = recipeOpt.get();
        return BaseMachineBlockEntity.createGhostItemsFromIngredients(recipe.m_7527_());
    }

    private boolean hasResources(AssemblerRecipe recipe) {
        SimpleContainer container = new SimpleContainer(12);
        for (int i = 0; i < container.m_6643_(); ++i) {
            container.m_6836_(i, this.inventory.getStackInSlot(6 + i));
        }
        return recipe.matches(container, this.f_58857_);
    }

    private boolean canInsertResult(ItemStack result) {
        ItemStack outputSlotStack = this.inventory.getStackInSlot(5);
        return outputSlotStack.m_41619_() || ItemStack.m_150942_((ItemStack)outputSlotStack, (ItemStack)result) && outputSlotStack.m_41613_() + result.m_41613_() <= outputSlotStack.m_41741_();
    }

    private void craftItem(AssemblerRecipe recipe) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        ItemStack result = recipe.m_8043_(null).m_41777_();
        block0: for (Ingredient ingredient : ingredients) {
            for (int i = 6; i <= 17; ++i) {
                ItemStack stackInSlot = this.inventory.getStackInSlot(i);
                if (!ingredient.test(stackInSlot)) continue;
                this.inventory.extractItem(i, 1, false);
                continue block0;
            }
        }
        ItemStack outputSlot = this.inventory.getStackInSlot(5);
        if (outputSlot.m_41619_()) {
            this.inventory.setStackInSlot(5, result);
        } else {
            outputSlot.m_41769_(result.m_41613_());
        }
        this.m_6596_();
        this.sendUpdateToClient();
    }

    private void pullIngredientsForOneCraft(AssemblerRecipe recipe) {
        if (this.f_58857_ == null || this.hasResources(recipe)) {
            return;
        }
        this.lastPullSources.clear();
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        IdentityHashMap<Ingredient, Integer> required = new IdentityHashMap<Ingredient, Integer>();
        for (Ingredient ing : ingredients) {
            required.put(ing, required.getOrDefault(ing, 0) + 1);
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)MachineAssemblerBlock.FACING);
        MultiblockStructureHelper helper = ((MachineAssemblerBlock)this.m_58900_().m_60734_()).getStructureHelper();
        for (BlockPos localOffset : helper.getPartOffsets()) {
            Direction dirToNeighbor;
            int dz;
            int dx;
            BlockPos neighborPosGlobal;
            BlockEntity neighbor;
            BlockPos partPos;
            BlockEntity partBE;
            int x = localOffset.m_123341_();
            int y = localOffset.m_123342_();
            int z = localOffset.m_123343_();
            boolean isInputConveyor = y == 0 && x == 2 && (z == 0 || z == 1);
            if (!isInputConveyor || !((partBE = this.f_58857_.m_7702_(partPos = helper.getRotatedPos(this.f_58858_, localOffset, facing))) instanceof UniversalMachinePartBlockEntity) || (neighbor = this.f_58857_.m_7702_(neighborPosGlobal = partPos.m_7918_(dx = Integer.signum(partPos.m_123341_() - this.f_58858_.m_123341_()), 0, dz = Integer.signum(partPos.m_123343_() - this.f_58858_.m_123343_())))) == null || neighbor instanceof UniversalMachinePartBlockEntity || neighbor == this || this.lastPullSources.contains(neighborPosGlobal)) continue;
            int dxN = partPos.m_123341_() - neighborPosGlobal.m_123341_();
            int dzN = partPos.m_123343_() - neighborPosGlobal.m_123343_();
            if (dxN == 1 && dzN == 0) {
                dirToNeighbor = Direction.EAST;
            } else if (dxN == -1 && dzN == 0) {
                dirToNeighbor = Direction.WEST;
            } else if (dxN == 0 && dzN == 1) {
                dirToNeighbor = Direction.SOUTH;
            } else {
                if (dxN != 0 || dzN != -1) continue;
                dirToNeighbor = Direction.NORTH;
            }
            IItemHandler cap = (IItemHandler)neighbor.getCapability(ForgeCapabilities.ITEM_HANDLER, dirToNeighbor).orElse(null);
            if (cap == null) continue;
            for (Map.Entry entry : required.entrySet()) {
                Ingredient ingredient = (Ingredient)entry.getKey();
                int need = (Integer)entry.getValue();
                int present = 0;
                for (int i = 6; i <= 17; ++i) {
                    ItemStack s = this.inventory.getStackInSlot(i);
                    if (s.m_41619_() || !ingredient.test(s)) continue;
                    present += s.m_41613_();
                }
                int missing = need - present;
                if (missing <= 0) continue;
                for (int slot = 0; slot < cap.getSlots() && missing > 0; ++slot) {
                    ItemStack simulated;
                    ItemStack possible = cap.getStackInSlot(slot);
                    if (possible.m_41619_() || !ingredient.test(possible) || (simulated = cap.extractItem(slot, missing, true)).m_41619_()) continue;
                    ItemStack toInsert = simulated.m_41777_();
                    for (int dest = 6; dest <= 17 && !toInsert.m_41619_(); ++dest) {
                        ItemStack remain = this.inventory.insertItem(dest, toInsert.m_41777_(), true);
                        int inserted = toInsert.m_41613_() - remain.m_41613_();
                        if (inserted <= 0) continue;
                        ItemStack actuallyExtracted = cap.extractItem(slot, inserted, false);
                        this.inventory.insertItem(dest, actuallyExtracted.m_41777_(), false);
                        this.lastPullSources.add(neighborPosGlobal);
                        this.m_6596_();
                        missing -= inserted;
                        toInsert = remain;
                    }
                }
            }
        }
    }

    private void pushOutputToNeighbors() {
        if (this.f_58857_ == null) {
            return;
        }
        ItemStack out = this.inventory.getStackInSlot(5);
        if (out.m_41619_()) {
            return;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)MachineAssemblerBlock.FACING);
        MultiblockStructureHelper helper = ((MachineAssemblerBlock)this.m_58900_().m_60734_()).getStructureHelper();
        for (BlockPos localOffset : helper.getPartOffsets()) {
            boolean isOutputConveyor;
            if (out.m_41619_()) break;
            int x = localOffset.m_123341_();
            int y = localOffset.m_123342_();
            int z = localOffset.m_123343_();
            boolean bl = isOutputConveyor = y == 0 && x == -1 && (z == 0 || z == 1);
            if (!isOutputConveyor) continue;
            BlockPos partPos = helper.getRotatedPos(this.f_58858_, localOffset, facing);
            int dxOut = Integer.signum(partPos.m_123341_() - this.f_58858_.m_123341_());
            int dzOut = Integer.signum(partPos.m_123343_() - this.f_58858_.m_123343_());
            Direction outDir = Direction.m_122372_((float)dxOut, (float)0.0f, (float)dzOut);
            Direction facingDir = (Direction)this.m_58900_().m_61143_((Property)MachineAssemblerBlock.FACING);
            BlockPos neighborPos = partPos.m_121945_(outDir).m_121945_(facingDir.m_122424_());
            BlockEntity neighbor = this.f_58857_.m_7702_(neighborPos);
            if (neighbor == null || neighbor instanceof UniversalMachinePartBlockEntity || neighbor == this || this.lastPullSources.contains(neighborPos)) continue;
            Direction side1 = outDir.m_122424_();
            Direction side2 = facingDir;
            IItemHandler cap = (IItemHandler)neighbor.getCapability(ForgeCapabilities.ITEM_HANDLER, side1).orElse((Object)((IItemHandler)neighbor.getCapability(ForgeCapabilities.ITEM_HANDLER, side2).orElse(null)));
            if (cap == null) continue;
            ItemStack toInsert = out.m_41777_();
            for (int slot = 0; slot < cap.getSlots() && !toInsert.m_41619_(); ++slot) {
                ItemStack remaining = cap.insertItem(slot, toInsert.m_41777_(), false);
                if (remaining.m_41613_() >= toInsert.m_41613_()) continue;
                this.inventory.getStackInSlot(5).m_41774_(toInsert.m_41613_() - remaining.m_41613_());
                toInsert = remaining;
            }
            out = this.inventory.getStackInSlot(5);
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("progress", this.progress);
        tag.m_128405_("maxProgress", this.maxProgress);
        tag.m_128379_("isCrafting", this.isCrafting);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("progress");
        this.maxProgress = tag.m_128451_("maxProgress");
        this.isCrafting = tag.m_128471_("isCrafting");
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && !this.isCrafting) {
            ClientSoundManager.updateSound(this, false, null);
        }
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("isCrafting", this.isCrafting);
        return tag;
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyInputProxy.invalidate();
        this.lazyOutputProxy.invalidate();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setCrafting(boolean crafting) {
        this.isCrafting = crafting;
    }

    public boolean isCrafting() {
        return this.isCrafting;
    }

    @Override
    public void m_142339_(Level pLevel) {
        super.m_142339_(pLevel);
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            EnergyNetworkManager.get((ServerLevel)this.f_58857_).removeNode(this.m_58899_());
        }
    }
}

