/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity.machine;

import com.hbm_m.api.energy.EnergyNetworkManager;
import com.hbm_m.api.energy.IEnergyConnector;
import com.hbm_m.api.energy.IEnergyProvider;
import com.hbm_m.api.energy.IEnergyReceiver;
import com.hbm_m.api.energy.PackedEnergyCapabilityProvider;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.block.machine.MachineBatteryBlock;
import com.hbm_m.capability.ModCapabilities;
import com.hbm_m.menu.MachineBatteryMenu;
import com.hbm_m.util.LongDataPacker;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class MachineBatteryBlockEntity
extends BlockEntity
implements MenuProvider,
IEnergyProvider,
IEnergyReceiver {
    private final long capacity;
    private final long transferRate;
    private long energy = 0L;
    private long lastEnergy = 0L;
    public int modeOnNoSignal = 0;
    public int modeOnSignal = 0;
    private IEnergyReceiver.Priority priority = IEnergyReceiver.Priority.LOW;
    private long energyDelta = 0L;
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            MachineBatteryBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IEnergyProvider> hbmProvider = LazyOptional.empty();
    private LazyOptional<IEnergyReceiver> hbmReceiver = LazyOptional.empty();
    private LazyOptional<IEnergyConnector> hbmConnector = LazyOptional.empty();
    private PackedEnergyCapabilityProvider feCapabilityProvider;
    protected final ContainerData data;

    public MachineBatteryBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.MACHINE_BATTERY_BE.get(), pos, state);
        long l;
        Block block = state.m_60734_();
        if (block instanceof MachineBatteryBlock) {
            MachineBatteryBlock b = (MachineBatteryBlock)block;
            l = b.getCapacity();
        } else {
            l = 9000000000000000000L;
        }
        this.capacity = l;
        this.transferRate = 100000000000L;
        this.feCapabilityProvider = new PackedEnergyCapabilityProvider(this);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> LongDataPacker.packHigh(MachineBatteryBlockEntity.this.energy);
                    case 1 -> LongDataPacker.packLow(MachineBatteryBlockEntity.this.energy);
                    case 2 -> LongDataPacker.packHigh(MachineBatteryBlockEntity.this.capacity);
                    case 3 -> LongDataPacker.packLow(MachineBatteryBlockEntity.this.capacity);
                    case 4 -> (int)MachineBatteryBlockEntity.this.energyDelta;
                    case 5 -> MachineBatteryBlockEntity.this.modeOnNoSignal;
                    case 6 -> MachineBatteryBlockEntity.this.modeOnSignal;
                    case 7 -> MachineBatteryBlockEntity.this.priority.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 5: {
                        MachineBatteryBlockEntity.this.modeOnNoSignal = value;
                        break;
                    }
                    case 6: {
                        MachineBatteryBlockEntity.this.modeOnSignal = value;
                        break;
                    }
                    case 7: {
                        MachineBatteryBlockEntity.this.priority = IEnergyReceiver.Priority.values()[Math.max(0, Math.min(value, IEnergyReceiver.Priority.values().length - 1))];
                    }
                }
            }

            public int m_6499_() {
                return 8;
            }
        };
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.hbmProvider = LazyOptional.of(() -> this);
        this.hbmReceiver = LazyOptional.of(() -> this);
        this.hbmConnector = LazyOptional.of(() -> this);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.hbmConnector.isPresent()) {
            this.hbmConnector.invalidate();
        }
        if (this.lazyItemHandler.isPresent()) {
            this.lazyItemHandler.invalidate();
        }
        if (this.hbmProvider.isPresent()) {
            this.hbmProvider.invalidate();
        }
        if (this.hbmReceiver.isPresent()) {
            this.hbmReceiver.invalidate();
        }
        if (this.feCapabilityProvider != null) {
            this.feCapabilityProvider.invalidate();
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MachineBatteryBlockEntity be) {
        long gameTime;
        if (level.f_46443_) {
            return;
        }
        EnergyNetworkManager manager = EnergyNetworkManager.get((ServerLevel)level);
        if (!manager.hasNode(pos)) {
            manager.addNode(pos);
        }
        if ((gameTime = level.m_46467_()) % 10L == 0L) {
            be.energyDelta = (be.energy - be.lastEnergy) / 10L;
            be.lastEnergy = be.energy;
        }
        be.chargeFromItem();
        be.dischargeToItem();
    }

    private void chargeFromItem() {
        this.itemHandler.getStackInSlot(0).getCapability(ForgeCapabilities.ENERGY).ifPresent(source -> {
            if (!source.canExtract()) {
                return;
            }
            long spaceAvailable = this.capacity - this.energy;
            if (spaceAvailable <= 0L) {
                return;
            }
            int maxTransfer = (int)Math.min(this.transferRate, spaceAvailable);
            int extracted = source.extractEnergy(maxTransfer, false);
            if (extracted > 0) {
                this.energy += (long)extracted;
                this.m_6596_();
            }
        });
    }

    private void dischargeToItem() {
        this.itemHandler.getStackInSlot(1).getCapability(ForgeCapabilities.ENERGY).ifPresent(target -> {
            if (!target.canReceive()) {
                return;
            }
            long availableEnergy = this.energy;
            if (availableEnergy <= 0L) {
                return;
            }
            int maxTransfer = (int)Math.min(this.transferRate, availableEnergy);
            int received = target.receiveEnergy(maxTransfer, false);
            if (received > 0) {
                this.energy -= (long)received;
                this.m_6596_();
            }
        });
    }

    public int getCurrentMode() {
        if (this.f_58857_ == null) {
            return this.modeOnNoSignal;
        }
        return this.f_58857_.m_276867_(this.f_58858_) ? this.modeOnSignal : this.modeOnNoSignal;
    }

    @Override
    public long getEnergyStored() {
        return this.energy;
    }

    @Override
    public long getMaxEnergyStored() {
        return this.capacity;
    }

    @Override
    public void setEnergyStored(long energy) {
        this.energy = Math.max(0L, Math.min(this.capacity, energy));
        this.m_6596_();
    }

    @Override
    public long getProvideSpeed() {
        return this.transferRate;
    }

    @Override
    public long getReceiveSpeed() {
        return this.transferRate;
    }

    @Override
    public IEnergyReceiver.Priority getPriority() {
        return this.priority;
    }

    public void setPriority(IEnergyReceiver.Priority p) {
        this.priority = p;
        this.m_6596_();
    }

    @Override
    public boolean canConnectEnergy(Direction side) {
        return true;
    }

    @Override
    public long extractEnergy(long maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0L;
        }
        long energyExtracted = Math.min(this.energy, Math.min(this.transferRate, maxExtract));
        if (!simulate && energyExtracted > 0L) {
            this.setEnergyStored(this.energy - energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public boolean canExtract() {
        int mode = this.getCurrentMode();
        return (mode == 0 || mode == 2) && this.energy > 0L;
    }

    @Override
    public long receiveEnergy(long maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0L;
        }
        long energyReceived = Math.min(this.capacity - this.energy, Math.min(this.transferRate, maxReceive));
        if (!simulate && energyReceived > 0L) {
            this.setEnergyStored(this.energy + energyReceived);
        }
        return energyReceived;
    }

    @Override
    public boolean canReceive() {
        int mode = this.getCurrentMode();
        return (mode == 0 || mode == 1) && this.energy < this.capacity;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        if (cap == ModCapabilities.HBM_ENERGY_CONNECTOR) {
            return this.hbmConnector.cast();
        }
        int mode = this.getCurrentMode();
        if (cap == ModCapabilities.HBM_ENERGY_PROVIDER && (mode == 0 || mode == 2)) {
            return this.hbmProvider.cast();
        }
        if (cap == ModCapabilities.HBM_ENERGY_RECEIVER && (mode == 0 || mode == 1)) {
            return this.hbmReceiver.cast();
        }
        LazyOptional<T> feCap = this.feCapabilityProvider.getCapability(cap, side);
        if (feCap.isPresent()) {
            return feCap;
        }
        return super.getCapability(cap, side);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energy = tag.m_128454_("Energy");
        this.lastEnergy = tag.m_128454_("lastEnergy");
        this.energyDelta = tag.m_128454_("energyDelta");
        this.modeOnNoSignal = tag.m_128451_("modeOnNoSignal");
        this.modeOnSignal = tag.m_128451_("modeOnSignal");
        if (tag.m_128441_("priority")) {
            int priorityIndex = tag.m_128451_("priority");
            this.priority = IEnergyReceiver.Priority.values()[Math.max(0, Math.min(priorityIndex, IEnergyReceiver.Priority.values().length - 1))];
        }
        if (tag.m_128441_("Inventory")) {
            this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128356_("Energy", this.energy);
        tag.m_128405_("modeOnNoSignal", this.modeOnNoSignal);
        tag.m_128356_("lastEnergy", this.lastEnergy);
        tag.m_128356_("energyDelta", this.energyDelta);
        tag.m_128405_("modeOnSignal", this.modeOnSignal);
        tag.m_128405_("priority", this.priority.ordinal());
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new MachineBatteryMenu(windowId, playerInventory, this, this.data);
    }

    public void handleButtonPress(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.data.m_8050_(5, (this.modeOnNoSignal + 1) % 4);
                break;
            }
            case 1: {
                this.data.m_8050_(6, (this.modeOnSignal + 1) % 4);
                break;
            }
            case 2: {
                IEnergyReceiver.Priority[] priorities = IEnergyReceiver.Priority.values();
                int currentIndex = this.priority.ordinal();
                int nextIndex = (currentIndex + 1) % priorities.length;
                this.data.m_8050_(7, nextIndex);
            }
        }
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            EnergyNetworkManager.get((ServerLevel)this.f_58857_).removeNode(this.m_58899_());
        }
    }
}

