/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity.machine;

import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.block.entity.machine.BaseMachineBlockEntity;
import com.hbm_m.menu.MachinePressMenu;
import com.hbm_m.recipe.PressRecipe;
import com.hbm_m.sound.ModSounds;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

public class MachinePressBlockEntity
extends BaseMachineBlockEntity {
    private static final int SLOT_COUNT = 4;
    private static final int FUEL_SLOT = 0;
    private static final int STAMP_SLOT = 1;
    private static final int MATERIAL_SLOT = 2;
    private static final int OUTPUT_SLOT = 3;
    private static final int MAX_SPEED = 400;
    private static final int PROGRESS_AT_MAX = 25;
    private static final int MAX_PRESS = 200;
    private static final int FUEL_PER_OPERATION = 200;
    private int speed = 0;
    private int burnTime = 0;
    private int press = 0;
    private boolean isRetracting = false;
    private int delay = 0;
    private int heatState = 0;
    private int pressPosition = 0;
    private float visualPressPosition = 0.0f;
    private float prevVisualPressPosition = 0.0f;
    private boolean clientPressInitialized = false;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> MachinePressBlockEntity.this.press;
                case 1 -> 200;
                case 2 -> MachinePressBlockEntity.this.burnTime;
                case 3 -> 200;
                case 4 -> MachinePressBlockEntity.this.speed;
                case 5 -> 400;
                case 6 -> MachinePressBlockEntity.this.heatState;
                case 7 -> MachinePressBlockEntity.this.pressPosition;
                case 8 -> {
                    if (MachinePressBlockEntity.this.isRetracting) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    MachinePressBlockEntity.this.press = value;
                    break;
                }
                case 2: {
                    MachinePressBlockEntity.this.burnTime = value;
                    break;
                }
                case 4: {
                    MachinePressBlockEntity.this.speed = value;
                    break;
                }
                case 6: {
                    MachinePressBlockEntity.this.heatState = value;
                    break;
                }
                case 7: {
                    MachinePressBlockEntity.this.pressPosition = value;
                    break;
                }
                case 8: {
                    MachinePressBlockEntity.this.isRetracting = value == 1;
                }
            }
        }

        public int m_6499_() {
            return 9;
        }
    };

    public MachinePressBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PRESS_BE.get(), pos, state, 4, 50000L, 1000L);
    }

    @Override
    protected Component getDefaultName() {
        return Component.m_237115_((String)"container.hbm_m.press");
    }

    public Component m_5446_() {
        return this.getDefaultName();
    }

    @Override
    protected boolean isItemValidForSlot(int slot, ItemStack stack) {
        return switch (slot) {
            case 0 -> {
                if (this.getBurnTime(stack.m_41720_()) > 0) {
                    yield true;
                }
                yield false;
            }
            case 1 -> true;
            case 2 -> true;
            case 3 -> false;
            default -> false;
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new MachinePressMenu(containerId, playerInventory, this, this.data);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MachinePressBlockEntity entity) {
        if (level.f_46443_) {
            entity.clientTick();
        } else {
            entity.serverTick();
        }
    }

    private void serverTick() {
        int fuelValue;
        if (this.f_58857_ == null) {
            return;
        }
        boolean needsSync = false;
        int previousPress = this.press;
        int previousPressPosition = this.pressPosition;
        int previousBurnTime = this.burnTime;
        int previousSpeed = this.speed;
        boolean previousRetracting = this.isRetracting;
        ItemStack fuelStack = this.inventory.getStackInSlot(0);
        if (!fuelStack.m_41619_() && this.burnTime < 200 && (fuelValue = this.getBurnTime(fuelStack.m_41720_())) > 0) {
            this.burnTime += fuelValue * 20;
            fuelStack.m_41774_(1);
            needsSync = true;
        }
        boolean canProcess = this.canProcess();
        boolean preheated = false;
        if ((canProcess || this.isRetracting) && this.burnTime >= 200) {
            this.speed += preheated ? 4 : 1;
            if (this.speed > 400) {
                this.speed = 400;
            }
        } else {
            --this.speed;
            if (this.speed < 0) {
                this.speed = 0;
            }
        }
        this.heatState = Math.min(12, this.speed / 33);
        if (this.delay <= 0) {
            int stampSpeed = this.speed * 25 / 400;
            if (this.isRetracting) {
                this.press -= stampSpeed;
                if (this.press <= 0) {
                    this.press = 0;
                    this.isRetracting = false;
                    this.delay = 5;
                }
            } else if (canProcess) {
                this.press += stampSpeed;
                if (this.press >= 200) {
                    this.craftItem();
                    this.isRetracting = true;
                    this.delay = 5;
                    if (this.burnTime >= 200) {
                        this.burnTime -= 200;
                    }
                    needsSync = true;
                }
            } else if (this.press > 0) {
                this.isRetracting = true;
            }
        } else {
            --this.delay;
        }
        this.pressPosition = Math.min(20, this.press * 20 / 200);
        if (this.press != previousPress || this.pressPosition != previousPressPosition || this.burnTime != previousBurnTime || this.speed != previousSpeed || this.isRetracting != previousRetracting) {
            needsSync = true;
        }
        if (needsSync) {
            this.m_6596_();
            this.sendUpdateToClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientTick() {
        float target = this.convertPressToProgress();
        if (!this.clientPressInitialized) {
            this.visualPressPosition = target;
            this.prevVisualPressPosition = target;
            this.clientPressInitialized = true;
        }
        this.prevVisualPressPosition = this.visualPressPosition;
        this.visualPressPosition = Mth.m_14179_((float)0.25f, (float)this.visualPressPosition, (float)target);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getPressAnimationProgress(float partialTick) {
        float interpolated = Mth.m_14179_((float)partialTick, (float)this.prevVisualPressPosition, (float)this.visualPressPosition);
        return Mth.m_14036_((float)interpolated, (float)0.0f, (float)1.0f);
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)(this.f_58858_.m_123342_() + 3), (double)(this.f_58858_.m_123343_() + 1));
    }

    private void craftItem() {
        Optional<PressRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return;
        }
        ItemStack output = recipe.get().m_8043_(this.f_58857_.m_9598_());
        this.inventory.extractItem(2, 1, false);
        ItemStack outputSlot = this.inventory.getStackInSlot(3);
        if (outputSlot.m_41619_()) {
            this.inventory.setStackInSlot(3, output.m_41777_());
        } else {
            outputSlot.m_41769_(output.m_41613_());
        }
        ItemStack stamp = this.inventory.getStackInSlot(1);
        if (stamp.m_41763_()) {
            stamp.m_41721_(stamp.m_41773_() + 1);
            if (stamp.m_41773_() >= stamp.m_41776_()) {
                this.inventory.setStackInSlot(1, ItemStack.f_41583_);
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12018_, SoundSource.BLOCKS, 1.5f, 0.8f);
            }
        }
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.PRESS_OPERATE.get(), SoundSource.BLOCKS, 1.5f, 1.0f);
    }

    private boolean canProcess() {
        if (this.burnTime < 200) {
            return false;
        }
        if (this.inventory.getStackInSlot(1).m_41619_() || this.inventory.getStackInSlot(2).m_41619_()) {
            return false;
        }
        Optional<PressRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = recipe.get().m_8043_(this.f_58857_.m_9598_());
        ItemStack outputSlot = this.inventory.getStackInSlot(3);
        if (outputSlot.m_41619_()) {
            return true;
        }
        return outputSlot.m_41613_() + result.m_41613_() <= outputSlot.m_41741_() && outputSlot.m_150930_(result.m_41720_()) && outputSlot.m_41773_() == result.m_41773_();
    }

    private Optional<PressRecipe> getCurrentRecipe() {
        SimpleContainer container = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            container.m_6836_(i, this.inventory.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)PressRecipe.Type.INSTANCE, (Container)container, this.f_58857_);
    }

    public int getBurnTime(Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        int vanillaBurnTime = ForgeHooks.getBurnTime((ItemStack)stack, null);
        if (vanillaBurnTime <= 0) {
            return 0;
        }
        return vanillaBurnTime / 20;
    }

    public int getHeatState() {
        return this.heatState;
    }

    public boolean isHeated() {
        return this.burnTime >= 200;
    }

    public boolean isCrafting() {
        return this.press > 0 || this.isRetracting;
    }

    public void drops() {
        SimpleContainer container = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            container.m_6836_(i, this.inventory.getStackInSlot(i));
        }
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)container);
        }
    }

    public ContainerData getBlockEntityData() {
        return this.data;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("press", this.press);
        tag.m_128405_("burnTime", this.burnTime);
        tag.m_128405_("speed", this.speed);
        tag.m_128379_("isRetracting", this.isRetracting);
        tag.m_128405_("delay", this.delay);
        tag.m_128405_("heatState", this.heatState);
        tag.m_128405_("pressPosition", this.pressPosition);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.press = tag.m_128451_("press");
        this.burnTime = tag.m_128451_("burnTime");
        this.speed = tag.m_128451_("speed");
        this.isRetracting = tag.m_128471_("isRetracting");
        this.delay = tag.m_128451_("delay");
        this.heatState = tag.m_128451_("heatState");
        this.pressPosition = tag.m_128451_("pressPosition");
        float progress = this.convertPressToProgress();
        this.clientPressInitialized = true;
        this.visualPressPosition = progress;
        this.prevVisualPressPosition = progress;
    }

    public ItemStack getMaterialStack() {
        return this.inventory.getStackInSlot(2);
    }

    public ItemStack getStampStack() {
        return this.inventory.getStackInSlot(1);
    }

    private float convertPressToProgress() {
        return (float)this.press / 200.0f;
    }
}

