/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity.machine;

import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.block.entity.machine.BaseMachineBlockEntity;
import com.hbm_m.capability.ModCapabilities;
import com.hbm_m.client.ClientSoundManager;
import com.hbm_m.item.ItemBlades;
import com.hbm_m.item.ModItems;
import com.hbm_m.menu.MachineShredderMenu;
import com.hbm_m.recipe.ShredderRecipe;
import com.hbm_m.sound.ShredderSoundInstance;
import com.hbm_m.util.LongDataPacker;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class MachineShredderBlockEntity
extends BaseMachineBlockEntity {
    private static final int BATTERY_SLOT = 29;
    private static final int TOTAL_SLOTS = 30;
    private static final int INPUT_START = 0;
    private static final int INPUT_END = 8;
    private static final int OUTPUT_START = 9;
    private static final int OUTPUT_END = 26;
    private static final int BLADE_LEFT = 27;
    private static final int BLADE_RIGHT = 28;
    public static final long MAX_POWER = 10000L;
    private static final long MAX_RECEIVE = 1000L;
    public static final int PROCESSING_SPEED = 60;
    private static final long ENERGY_PER_TICK = 5L;
    private int progress = 0;
    private boolean isActive = false;
    private boolean clientIsActive = false;
    private int syncCounter = 0;
    private static final int SYNC_INTERVAL = 20;
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int index) {
            long energy = MachineShredderBlockEntity.this.getEnergyStored();
            long maxEnergy = MachineShredderBlockEntity.this.getMaxEnergyStored();
            long delta = MachineShredderBlockEntity.this.getEnergyDelta();
            return switch (index) {
                case 0 -> MachineShredderBlockEntity.this.progress;
                case 1 -> 60;
                case 2 -> LongDataPacker.packHigh(energy);
                case 3 -> LongDataPacker.packLow(energy);
                case 4 -> LongDataPacker.packHigh(maxEnergy);
                case 5 -> LongDataPacker.packLow(maxEnergy);
                case 6 -> LongDataPacker.packHigh(delta);
                case 7 -> LongDataPacker.packLow(delta);
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
        }

        public int m_6499_() {
            return 8;
        }
    };

    public MachineShredderBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SHREDDER.get(), pos, state, 30, 10000L, 1000L);
    }

    @Override
    protected Component getDefaultName() {
        return Component.m_237115_((String)"container.hbm_m.shredder");
    }

    public Component m_5446_() {
        return this.getDefaultName();
    }

    @Override
    protected boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (slot >= 0 && slot <= 8) {
            return !(stack.m_41720_() instanceof ItemBlades);
        }
        if (slot >= 9 && slot <= 26) {
            return false;
        }
        if (slot == 27 || slot == 28) {
            return stack.m_41720_() instanceof ItemBlades;
        }
        if (slot == 29) {
            boolean hasHbmEnergy = stack.getCapability(ModCapabilities.HBM_ENERGY_PROVIDER).map(provider -> provider.canExtract()).orElse(false);
            if (hasHbmEnergy) {
                return true;
            }
            return stack.getCapability(ForgeCapabilities.ENERGY).map(storage -> storage.canExtract()).orElse(false);
        }
        return false;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new MachineShredderMenu(containerId, playerInventory, this, this.containerData);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("progress", this.progress);
        tag.m_128379_("active", this.isActive);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("progress", this.progress);
        tag.m_128379_("active", this.isActive);
        return tag;
    }

    @Override
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, be -> tag);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("progress");
        if (tag.m_128441_("power")) {
            this.setEnergyStored(tag.m_128454_("power"));
        }
        if (tag.m_128441_("active")) {
            this.clientIsActive = this.isActive = tag.m_128471_("active");
        } else {
            this.isActive = false;
            this.clientIsActive = false;
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            ClientSoundManager.stopSound(this.f_58858_);
        }
    }

    public void drops() {
        SimpleContainer container = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            container.m_6836_(i, this.inventory.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)container);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MachineShredderBlockEntity blockEntity) {
        if (level.m_5776_()) {
            blockEntity.clientTick();
        } else {
            blockEntity.serverTick(level, pos);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientTick() {
        ClientSoundManager.updateSound(this, this.getIsActive(), () -> new ShredderSoundInstance(this.m_58899_()));
    }

    public boolean getIsActive() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return this.clientIsActive;
        }
        return this.isActive;
    }

    private void serverTick(Level level, BlockPos pos) {
        long currentEnergy;
        this.ensureNetworkInitialized();
        boolean dirty = false;
        this.chargeFromBattery();
        if (level.m_46467_() % 10L == 0L) {
            this.updateEnergyDelta(this.getEnergyStored());
        }
        boolean canProcess = this.canProcess();
        boolean wasActive = this.isActive;
        boolean canWork = false;
        if (canProcess && (currentEnergy = this.getEnergyStored()) >= 5L) {
            this.setEnergyStored(currentEnergy - 5L);
            canWork = true;
            dirty = true;
        }
        if (canWork) {
            ++this.progress;
            if (this.progress >= 60) {
                for (int i = 27; i <= 28; ++i) {
                    int oldDamage;
                    int newDamage;
                    ItemBlades bladeItem;
                    int maxDamage;
                    Item item;
                    ItemStack blade = this.inventory.getStackInSlot(i);
                    if (blade.m_41619_() || !((item = blade.m_41720_()) instanceof ItemBlades) || (maxDamage = (bladeItem = (ItemBlades)item).getMaxDamage(blade)) <= 0 || (newDamage = Math.min(maxDamage, (oldDamage = blade.m_41773_()) + 1)) == oldDamage) continue;
                    blade.m_41721_(newDamage);
                    dirty = true;
                    if (oldDamage >= maxDamage || newDamage < maxDamage) continue;
                    level.m_5594_(null, pos, SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, 0.8f);
                }
                this.progress = 0;
                this.processItem();
                dirty = true;
            } else {
                dirty = true;
            }
        } else if (this.progress > 0) {
            this.progress = 0;
            dirty = true;
        }
        this.isActive = canWork;
        if (wasActive != this.isActive) {
            dirty = true;
        }
        if (this.isActive || wasActive) {
            dirty = true;
        }
        ++this.syncCounter;
        if (this.syncCounter >= 20) {
            this.syncCounter = 0;
            dirty = true;
        }
        if (dirty) {
            this.m_6596_();
            this.sendUpdateToClient();
        }
    }

    private void chargeFromBattery() {
        ItemStack batteryStack = this.inventory.getStackInSlot(29);
        if (batteryStack.m_41619_()) {
            return;
        }
        boolean transferred = batteryStack.getCapability(ModCapabilities.HBM_ENERGY_PROVIDER).map(itemEnergy -> {
            if (!itemEnergy.canExtract()) {
                return false;
            }
            long energyNeeded = this.getMaxEnergyStored() - this.getEnergyStored();
            if (energyNeeded <= 0L) {
                return false;
            }
            long energyToTransfer = Math.min(energyNeeded, this.getReceiveSpeed());
            long extracted = itemEnergy.extractEnergy(energyToTransfer, false);
            if (extracted > 0L) {
                this.setEnergyStored(this.getEnergyStored() + extracted);
                this.m_6596_();
                return true;
            }
            return false;
        }).orElse(false);
        if (transferred) {
            return;
        }
        batteryStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(itemEnergy -> {
            if (!itemEnergy.canExtract()) {
                return;
            }
            long energyNeeded = this.getMaxEnergyStored() - this.getEnergyStored();
            if (energyNeeded <= 0L) {
                return;
            }
            int maxTransfer = (int)Math.min(Integer.MAX_VALUE, Math.min(energyNeeded, this.getReceiveSpeed()));
            if (maxTransfer <= 0) {
                return;
            }
            int extracted = itemEnergy.extractEnergy(maxTransfer, false);
            if (extracted > 0) {
                this.setEnergyStored(this.getEnergyStored() + (long)extracted);
                this.m_6596_();
            }
        });
    }

    public boolean hasPower() {
        return this.getEnergyStored() > 0L;
    }

    public long getPower() {
        return this.getEnergyStored();
    }

    public long getMaxPower() {
        return this.getMaxEnergyStored();
    }

    public long getPowerScaled(long i) {
        return this.getEnergyStored() * i / 10000L;
    }

    public boolean canProcess() {
        int gearLeft = this.getGearLeft();
        int gearRight = this.getGearRight();
        if (gearLeft == 0 || gearLeft == 3 || gearRight == 0 || gearRight == 3) {
            return false;
        }
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_() || stack.m_41613_() <= 0 || !this.hasSpace(stack)) continue;
            return true;
        }
        return false;
    }

    private void processItem() {
        block0: for (int inpSlot = 0; inpSlot <= 8; ++inpSlot) {
            ItemStack outputStack;
            int outSlot;
            ItemStack result;
            ItemStack inputStack = this.inventory.getStackInSlot(inpSlot);
            if (inputStack.m_41619_() || !this.hasSpace(inputStack) || (result = this.getRecipeResult(inputStack)) == null || result.m_41619_()) continue;
            boolean flag = false;
            for (outSlot = 9; outSlot <= 26; ++outSlot) {
                outputStack = this.inventory.getStackInSlot(outSlot);
                if (outputStack.m_41619_() || !ItemStack.m_150942_((ItemStack)outputStack, (ItemStack)result) || outputStack.m_41613_() + result.m_41613_() > outputStack.m_41741_()) continue;
                outputStack.m_41769_(result.m_41613_());
                inputStack.m_41774_(1);
                flag = true;
                break;
            }
            if (flag) continue;
            for (outSlot = 9; outSlot <= 26; ++outSlot) {
                outputStack = this.inventory.getStackInSlot(outSlot);
                if (!outputStack.m_41619_()) continue;
                this.inventory.setStackInSlot(outSlot, result.m_41777_());
                inputStack.m_41774_(1);
                continue block0;
            }
        }
    }

    private boolean hasSpace(ItemStack stack) {
        ItemStack result = this.getRecipeResult(stack);
        if (result == null || result.m_41619_()) {
            return false;
        }
        for (int i = 9; i <= 26; ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (slotStack.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)result) || slotStack.m_41613_() + result.m_41613_() > result.m_41741_()) continue;
            return true;
        }
        return false;
    }

    private ItemStack getRecipeResult(ItemStack input) {
        if (input.m_41619_() || this.f_58857_ == null) {
            return new ItemStack((ItemLike)ModItems.SCRAP.get(), 1);
        }
        SimpleContainer container = new SimpleContainer(1);
        container.m_6836_(0, input);
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)ShredderRecipe.Type.INSTANCE, (Container)container, this.f_58857_);
        if (recipe.isPresent()) {
            return ((ShredderRecipe)recipe.get()).m_8043_(this.f_58857_.m_9598_()).m_41777_();
        }
        if (this.isDustLike(input)) {
            ItemStack copy = input.m_41777_();
            copy.m_41764_(1);
            return copy;
        }
        return new ItemStack((ItemLike)ModItems.SCRAP.get(), 1);
    }

    public int getGearLeft() {
        ItemStack blade = this.inventory.getStackInSlot(27);
        if (blade.m_41619_() || !(blade.m_41720_() instanceof ItemBlades)) {
            return 0;
        }
        ItemBlades bladeItem = (ItemBlades)blade.m_41720_();
        int maxDamage = bladeItem.getMaxDamage(blade);
        if (maxDamage == 0) {
            return 1;
        }
        int currentDamage = blade.m_41773_();
        if (currentDamage < maxDamage / 2) {
            return 1;
        }
        if (currentDamage < maxDamage) {
            return 2;
        }
        return 3;
    }

    public int getGearRight() {
        ItemStack blade = this.inventory.getStackInSlot(28);
        if (blade.m_41619_() || !(blade.m_41720_() instanceof ItemBlades)) {
            return 0;
        }
        ItemBlades bladeItem = (ItemBlades)blade.m_41720_();
        int maxDamage = bladeItem.getMaxDamage(blade);
        if (maxDamage == 0) {
            return 1;
        }
        int currentDamage = blade.m_41773_();
        if (currentDamage < maxDamage / 2) {
            return 1;
        }
        if (currentDamage < maxDamage) {
            return 2;
        }
        return 3;
    }

    public int getDiFurnaceProgressScaled(int i) {
        return this.progress * i / 60;
    }

    public boolean isProcessing() {
        return this.progress > 0;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return 60;
    }

    private boolean isDustLike(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (item == ModItems.DUST.get() || item == ModItems.DUST_TINY.get()) {
            return true;
        }
        for (RegistryObject<Item> powder : ModItems.POWDERS.values()) {
            if (powder == null || !powder.isPresent() || powder.get() != item) continue;
            return true;
        }
        for (RegistryObject<Item> powder : ModItems.INGOT_POWDERS.values()) {
            if (powder == null || !powder.isPresent() || powder.get() != item) continue;
            return true;
        }
        for (RegistryObject<Item> powder : ModItems.INGOT_POWDERS_TINY.values()) {
            if (powder == null || !powder.isPresent() || powder.get() != item) continue;
            return true;
        }
        return false;
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }
}

