/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity.machine;

import com.hbm_m.api.energy.EnergyNetworkManager;
import com.hbm_m.api.energy.IEnergyConnector;
import com.hbm_m.api.energy.IEnergyProvider;
import com.hbm_m.api.energy.IEnergyReceiver;
import com.hbm_m.api.energy.PackedEnergyCapabilityProvider;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.block.machine.MachineWoodBurnerBlock;
import com.hbm_m.capability.ModCapabilities;
import com.hbm_m.item.ModItems;
import com.hbm_m.menu.MachineWoodBurnerMenu;
import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class MachineWoodBurnerBlockEntity
extends BlockEntity
implements MenuProvider,
IEnergyProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            MachineWoodBurnerBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
            }
            if (slot == 1) {
                return false;
            }
            if (slot == 2) {
                return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
            }
            return false;
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private long energy = 0L;
    private final long capacity = 100000L;
    private final long generationRate = 50L;
    private final LazyOptional<IEnergyProvider> hbmProvider = LazyOptional.of(() -> this);
    private final LazyOptional<IEnergyConnector> hbmConnector = LazyOptional.of(() -> this);
    private final PackedEnergyCapabilityProvider feCapabilityProvider = new PackedEnergyCapabilityProvider(this);
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int i) {
            return switch (i) {
                case 0 -> (int)(MachineWoodBurnerBlockEntity.this.energy & 0xFFFFFFFFL);
                case 1 -> (int)(MachineWoodBurnerBlockEntity.this.energy >> 32);
                case 2 -> 100000;
                case 3 -> 0;
                case 4 -> MachineWoodBurnerBlockEntity.this.burnTime;
                case 5 -> MachineWoodBurnerBlockEntity.this.maxBurnTime;
                case 6 -> {
                    if (MachineWoodBurnerBlockEntity.this.isBurning()) {
                        yield 1;
                    }
                    yield 0;
                }
                case 7 -> {
                    if (MachineWoodBurnerBlockEntity.this.enabled) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int i, int v) {
            if (i == 7) {
                MachineWoodBurnerBlockEntity.this.enabled = v != 0;
            }
        }

        public int m_6499_() {
            return 8;
        }
    };
    private int burnTime = 0;
    private int maxBurnTime = 0;
    private boolean enabled = true;
    private static final int FUEL_SLOT = 0;
    private static final int ASH_SLOT = 1;
    private static final int CHARGE_SLOT = 2;

    public MachineWoodBurnerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.WOOD_BURNER_BE.get(), pPos, pBlockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MachineWoodBurnerBlockEntity be) {
        if (level.m_5776_()) {
            return;
        }
        EnergyNetworkManager manager = EnergyNetworkManager.get((ServerLevel)level);
        if (!manager.hasNode(pos)) {
            LOGGER.info("[WOOD_BURNER] Attempting to add node at {}", (Object)pos);
            manager.addNode(pos);
            if (!manager.hasNode(pos)) {
                BlockEntity beCheck = level.m_7702_(pos);
                if (beCheck != null) {
                    boolean hasProvider = beCheck.getCapability(ModCapabilities.HBM_ENERGY_PROVIDER).isPresent();
                    boolean hasReceiver = beCheck.getCapability(ModCapabilities.HBM_ENERGY_RECEIVER).isPresent();
                    boolean hasConnector = beCheck.getCapability(ModCapabilities.HBM_ENERGY_CONNECTOR).isPresent();
                    LOGGER.warn("[WOOD_BURNER] Node NOT added! Capabilities: provider={}, receiver={}, connector={}", new Object[]{hasProvider, hasReceiver, hasConnector});
                } else {
                    LOGGER.warn("[WOOD_BURNER] BlockEntity is NULL at {}", (Object)pos);
                }
            } else {
                LOGGER.info("[WOOD_BURNER] Node successfully added at {}", (Object)pos);
            }
        }
        boolean wasBurning = be.isBurning();
        boolean canCurrentlyBurn = be.canBurn();
        if (be.enabled && be.burnTime <= 0 && canCurrentlyBurn) {
            be.startBurning();
        }
        if (be.isBurning() && be.enabled) {
            --be.burnTime;
            be.energy = Math.min(be.capacity, be.energy + be.generationRate);
            be.chargeItem();
            if (be.burnTime == 0) {
                be.maxBurnTime = 0;
                if (level.f_46441_.m_188501_() < 0.5f) {
                    ItemStack ashStack = be.itemHandler.getStackInSlot(1);
                    if (ashStack.m_41619_()) {
                        be.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)ModItems.WOOD_ASH_POWDER.get()));
                    } else if (ashStack.m_150930_((Item)ModItems.WOOD_ASH_POWDER.get()) && ashStack.m_41613_() < ashStack.m_41741_()) {
                        ashStack.m_41769_(1);
                    }
                }
            }
        } else if (be.isBurning()) {
            be.burnTime = 0;
            be.maxBurnTime = 0;
        }
        if (wasBurning != be.isBurning()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)MachineWoodBurnerBlock.LIT, (Comparable)Boolean.valueOf(be.isBurning())), 3);
        }
        MachineWoodBurnerBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
    }

    private boolean canBurn() {
        return !this.itemHandler.getStackInSlot(0).m_41619_() && this.energy < this.capacity;
    }

    private void startBurning() {
        ItemStack fuelStack = this.itemHandler.getStackInSlot(0);
        int burnTicks = ForgeHooks.getBurnTime((ItemStack)fuelStack, null);
        if (burnTicks > 0) {
            this.maxBurnTime = burnTicks;
            this.burnTime = burnTicks;
            if (fuelStack.m_41720_() == Items.f_42448_) {
                this.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)Items.f_42446_));
            } else {
                fuelStack.m_41774_(1);
            }
        }
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @Override
    public long getEnergyStored() {
        return this.energy;
    }

    @Override
    public long getMaxEnergyStored() {
        return this.capacity;
    }

    @Override
    public void setEnergyStored(long energy) {
        this.energy = Math.max(0L, Math.min(this.capacity, energy));
        this.m_6596_();
    }

    @Override
    public long getProvideSpeed() {
        return this.generationRate * 2L;
    }

    @Override
    public boolean canConnectEnergy(Direction side) {
        return true;
    }

    @Override
    public long extractEnergy(long maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0L;
        }
        long energyExtracted = Math.min(this.energy, Math.min(this.getProvideSpeed(), maxExtract));
        if (!simulate && energyExtracted > 0L) {
            this.setEnergyStored(this.energy - energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public boolean canExtract() {
        return this.energy > 0L;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ModCapabilities.HBM_ENERGY_PROVIDER) {
            return this.hbmProvider.cast();
        }
        if (cap == ModCapabilities.HBM_ENERGY_CONNECTOR) {
            return this.hbmConnector.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        LazyOptional<T> feCap = this.feCapabilityProvider.getCapability(cap, side);
        if (feCap.isPresent()) {
            return feCap;
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.hbmProvider.invalidate();
        this.feCapabilityProvider.invalidate();
        this.hbmConnector.invalidate();
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128356_("energy", this.energy);
        tag.m_128405_("burnTime", this.burnTime);
        tag.m_128405_("maxBurnTime", this.maxBurnTime);
        tag.m_128379_("enabled", this.enabled);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.energy = tag.m_128454_("energy");
        this.burnTime = tag.m_128451_("burnTime");
        this.maxBurnTime = tag.m_128451_("maxBurnTime");
        this.enabled = tag.m_128471_("enabled");
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.hbm_m.wood_burner");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player p) {
        return new MachineWoodBurnerMenu(id, inv, this, this.data);
    }

    public void drops() {
        if (this.f_58857_ != null) {
            SimpleContainer simpleContainer = new SimpleContainer(this.itemHandler.getSlots());
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                simpleContainer.m_6836_(i, this.itemHandler.getStackInSlot(i));
            }
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)simpleContainer);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void m_142339_(Level pLevel) {
        super.m_142339_(pLevel);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            EnergyNetworkManager.get((ServerLevel)this.f_58857_).removeNode(this.m_58899_());
        }
    }

    private void chargeItem() {
        IEnergyStorage itemEnergy;
        if (this.energy <= 0L) {
            return;
        }
        ItemStack itemToCharge = this.itemHandler.getStackInSlot(2);
        if (itemToCharge.m_41619_()) {
            return;
        }
        LazyOptional hbmEnergy = itemToCharge.getCapability(ModCapabilities.HBM_ENERGY_RECEIVER);
        if (hbmEnergy.isPresent()) {
            long maxTransfer;
            long accepted;
            IEnergyReceiver itemReceiver = (IEnergyReceiver)hbmEnergy.resolve().get();
            if (itemReceiver.canReceive() && (accepted = itemReceiver.receiveEnergy(maxTransfer = Math.min(this.energy, this.getProvideSpeed()), false)) > 0L) {
                this.setEnergyStored(this.energy - accepted);
                this.m_6596_();
            }
            return;
        }
        LazyOptional forgeEnergy = itemToCharge.getCapability(ForgeCapabilities.ENERGY);
        if (forgeEnergy.isPresent() && (itemEnergy = (IEnergyStorage)forgeEnergy.resolve().get()).canReceive()) {
            long maxTransfer = Math.min(this.energy, this.getProvideSpeed());
            int transferInt = (int)Math.min(Integer.MAX_VALUE, maxTransfer);
            if (transferInt <= 0) {
                return;
            }
            int accepted = itemEnergy.receiveEnergy(transferInt, false);
            if (accepted > 0) {
                this.setEnergyStored(this.energy - (long)accepted);
                this.m_6596_();
            }
        }
    }
}

