/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.entity.machine;

import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.block.entity.machine.MachineAssemblerBlockEntity;
import com.hbm_m.capability.ModCapabilities;
import com.hbm_m.multiblock.IMultiblockPart;
import com.hbm_m.multiblock.PartRole;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UniversalMachinePartBlockEntity
extends BlockEntity
implements IMultiblockPart {
    private BlockPos controllerPos;
    private PartRole role = PartRole.DEFAULT;

    public UniversalMachinePartBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.UNIVERSAL_MACHINE_PART_BE.get(), pPos, pBlockState);
    }

    @Override
    public synchronized void setControllerPos(BlockPos pos) {
        this.controllerPos = pos;
        this.m_6596_();
    }

    @Override
    public void setPartRole(PartRole role) {
        if (this.role != role) {
            this.role = role;
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            }
        }
    }

    @Override
    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    @Override
    public PartRole getPartRole() {
        return this.role;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.controllerPos == null || this.f_58857_ == null) {
            return super.getCapability(cap, side);
        }
        BlockEntity controllerBE = this.f_58857_.m_7702_(this.controllerPos);
        if (controllerBE == null) {
            return super.getCapability(cap, side);
        }
        if (this.role == PartRole.ENERGY_CONNECTOR) {
            if (cap == ModCapabilities.HBM_ENERGY_PROVIDER || cap == ModCapabilities.HBM_ENERGY_RECEIVER || cap == ModCapabilities.HBM_ENERGY_CONNECTOR) {
                return controllerBE.getCapability(cap, side);
            }
            if (cap == ForgeCapabilities.ENERGY) {
                return controllerBE.getCapability(cap, side);
            }
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && (this.role == PartRole.ITEM_INPUT || this.role == PartRole.ITEM_OUTPUT)) {
            if (controllerBE instanceof MachineAssemblerBlockEntity) {
                MachineAssemblerBlockEntity assembler = (MachineAssemblerBlockEntity)controllerBE;
                return assembler.getItemHandlerForPart(this.role).cast();
            }
            return controllerBE.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.controllerPos != null) {
            pTag.m_128365_("ControllerPos", (Tag)NbtUtils.m_129224_((BlockPos)this.controllerPos));
        }
        pTag.m_128359_("PartRole", this.role.name());
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("ControllerPos")) {
            this.controllerPos = NbtUtils.m_129239_((CompoundTag)pTag.m_128469_("ControllerPos"));
        }
        if (pTag.m_128441_("PartRole")) {
            try {
                this.role = PartRole.valueOf(pTag.m_128461_("PartRole"));
            }
            catch (IllegalArgumentException e) {
                this.role = PartRole.DEFAULT;
            }
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }
}

