/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.explosives;

import com.hbm_m.block.IDetonatable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class DetMinerBlock
extends Block
implements IDetonatable {
    private static final int MINING_RADIUS = 3;
    private static final int DETONATION_RADIUS = 6;

    public DetMinerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.detminer.line1").m_130940_(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.detminer.line4").m_130940_(ChatFormatting.GRAY));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_ && level.m_276867_(pos)) {
            this.onDetonate(level, pos, state, null);
        }
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    @Override
    public boolean onDetonate(Level level, BlockPos pos, BlockState state, Player player) {
        if (level.f_46443_) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.destroyBlocksInRadius(serverLevel, pos);
        this.triggerNearbyDetonations(serverLevel, pos, player);
        serverLevel.m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 1.0f);
        serverLevel.m_46597_(pos, Blocks.f_50016_.m_49966_());
        serverLevel.m_142346_(null, GameEvent.f_157794_, pos);
        return true;
    }

    private void destroyBlocksInRadius(ServerLevel serverLevel, BlockPos pos) {
        ArrayList<BlockPos> blocksToDestroy = new ArrayList<BlockPos>();
        ArrayList collectedDrops = new ArrayList();
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    double dist = Math.sqrt(x * x + y * y + z * z);
                    if (!(dist <= 3.0)) continue;
                    BlockPos checkPos = pos.m_7918_(x, y, z);
                    BlockState blockState = serverLevel.m_8055_(checkPos);
                    float hardness = blockState.m_60800_((BlockGetter)serverLevel, checkPos);
                    if (blockState.m_60795_() || blockState.m_60713_(Blocks.f_50752_) || blockState.m_60713_((Block)this) || !(hardness < 30.0f)) continue;
                    blocksToDestroy.add(checkPos);
                    LootParams.Builder lootParamsBuilder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)checkPos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_);
                    collectedDrops.addAll(blockState.m_287290_(lootParamsBuilder));
                }
            }
        }
        for (BlockPos blockPos : blocksToDestroy) {
            serverLevel.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
            serverLevel.m_142346_(null, GameEvent.f_157794_, blockPos);
        }
        for (ItemStack drop : collectedDrops) {
            if (drop.m_41619_()) continue;
            serverLevel.m_7967_((Entity)new ItemEntity((Level)serverLevel, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, drop));
        }
    }

    private void triggerNearbyDetonations(ServerLevel serverLevel, BlockPos pos, Player player) {
        for (int x = -6; x <= 6; ++x) {
            for (int y = -6; y <= 6; ++y) {
                for (int z = -6; z <= 6; ++z) {
                    BlockPos checkPos;
                    BlockState checkState;
                    Block block;
                    double dist = Math.sqrt(x * x + y * y + z * z);
                    if (!(dist <= 6.0) || !(dist > 0.0) || !((block = (checkState = serverLevel.m_8055_(checkPos = pos.m_7918_(x, y, z))).m_60734_()) instanceof IDetonatable)) continue;
                    IDetonatable detonatable = (IDetonatable)block;
                    int delay = (int)(dist * 2.0);
                    serverLevel.m_7654_().m_6937_((Runnable)new TickTask(delay, () -> detonatable.onDetonate((Level)serverLevel, checkPos, checkState, player)));
                }
            }
        }
    }
}

