/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.explosives;

import com.hbm_m.block.entity.MineBlockEntity;
import com.hbm_m.sound.ModSounds;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MineBlock
extends Block
implements EntityBlock {
    private static final VoxelShape COLLISION_SHAPE = Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.25, (double)0.75);
    private static final double DETECTION_RADIUS = 10.0;
    private static final float EXPLOSION_POWER = 2.5f;
    public static final DirectionProperty FACING = DirectionProperty.m_156003_((String)"facing");
    private static final Random RANDOM = new Random();

    public MineBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.mine.line1").m_130940_(ChatFormatting.GRAY));
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : (lvl, pos, st, te) -> {
            if (te instanceof MineBlockEntity) {
                MineBlockEntity mine = (MineBlockEntity)te;
                MineBlockEntity.tick(lvl, pos, st, mine);
            }
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return COLLISION_SHAPE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return COLLISION_SHAPE;
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        Player player;
        if (!(level.f_46443_ || entity instanceof Player && (player = (Player)entity).m_7500_() || !(entity instanceof LivingEntity))) {
            this.explodeMine(level, pos);
            level.m_7471_(pos, false);
        }
        super.m_141947_(level, pos, state, entity);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    private void explodeMine(Level level, BlockPos pos) {
        this.playDetonationSound(level, pos);
        level.m_255391_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 2.5f, true, Level.ExplosionInteraction.NONE);
        level.m_7471_(pos, false);
    }

    private void playDetonationSound(Level level, BlockPos pos) {
        SoundEvent[] sounds = new SoundEvent[]{(SoundEvent)ModSounds.EXPLOSION_SMALL_NEAR1.orElse(null), (SoundEvent)ModSounds.EXPLOSION_SMALL_NEAR2.orElse(null), (SoundEvent)ModSounds.EXPLOSION_SMALL_NEAR3.orElse(null)};
        List<SoundEvent> availableSounds = Arrays.stream(sounds).filter(Objects::nonNull).toList();
        if (!availableSounds.isEmpty()) {
            SoundEvent soundToPlay = availableSounds.get(RANDOM.nextInt(availableSounds.size()));
            level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soundToPlay, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MineBlockEntity(pos, state);
    }
}

