/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.explosives;

import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.particle.ModExplosionParticles;
import com.hbm_m.sound.ModSounds;
import com.hbm_m.util.ShockwaveGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MineNukeBlock
extends Block
implements EntityBlock {
    private static final float EXPLOSION_POWER = 20.0f;
    private static final int CRATER_RADIUS = 20;
    private static final int CRATER_DEPTH = 3;
    private static final DirectionProperty FACING = DirectionProperty.m_156003_((String)"facing");
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.25, (double)0.75);
    private static final VoxelShape COLLISION_SHAPE = Shapes.m_83048_((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.25, (double)0.75);
    private static final Random RANDOM = new Random();
    private static final float DAMAGE_RADIUS = 30.0f;
    private static final float DAMAGE_AMOUNT = 200.0f;
    private static final float MAX_DAMAGE_DISTANCE = 25.0f;

    public MineNukeBlock(BlockBehaviour.Properties properties) {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(3.5f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.mine_nuke.line1").m_130940_(ChatFormatting.DARK_RED));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.mine_nuke.line2").m_130940_(ChatFormatting.RED));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.mine_nuke.line3").m_130940_(ChatFormatting.GRAY));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return COLLISION_SHAPE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return COLLISION_SHAPE;
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        Player player;
        if (!(level.f_46443_ || entity instanceof Player && (player = (Player)entity).m_7500_() || !(entity instanceof LivingEntity))) {
            this.detonate(level, pos);
            level.m_7471_(pos, false);
        }
        super.m_141947_(level, pos, state, entity);
    }

    private void detonate(Level level, BlockPos pos) {
        ServerLevel serverLevel;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        this.playRandomDetonationSound(level, pos);
        level.m_255391_(null, x, y, z, 20.0f, false, Level.ExplosionInteraction.NONE);
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            this.dealExplosionDamage(serverLevel, x, y, z);
        }
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            this.spawnExplosionEffects(serverLevel, x, y, z);
            MinecraftServer server = serverLevel.m_7654_();
            if (server != null) {
                server.m_6937_((Runnable)new TickTask(5, () -> ShockwaveGenerator.generateCrater(serverLevel, pos, 20, 3, (Block)ModBlocks.WASTE_LOG.get(), (Block)ModBlocks.WASTE_PLANKS.get(), (Block)ModBlocks.BURNED_GRASS.get())));
            }
        }
    }

    private void dealExplosionDamage(ServerLevel serverLevel, double x, double y, double z) {
        List entitiesNearby = serverLevel.m_45976_(LivingEntity.class, new AABB(x - 30.0, y - 30.0, z - 30.0, x + 30.0, y + 30.0, z + 30.0));
        for (LivingEntity entity : entitiesNearby) {
            double distanceToEntity = Math.sqrt(Math.pow(entity.m_20185_() - x, 2.0) + Math.pow(entity.m_20186_() - y, 2.0) + Math.pow(entity.m_20189_() - z, 2.0));
            if (!(distanceToEntity <= 30.0)) continue;
            float damage = 200.0f;
            if (distanceToEntity > 25.0) {
                float remainingDistance = 5.0f;
                float damageDistance = (float)distanceToEntity - 25.0f;
                damage = 200.0f * (1.0f - damageDistance / remainingDistance) * 0.5f;
            }
            entity.m_6469_(entity.m_269291_().m_269093_(null), damage);
        }
    }

    private void spawnExplosionEffects(ServerLevel level, double x, double y, double z) {
        int i;
        level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.FLASH.get()), x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        for (i = 0; i < 200; ++i) {
            double dx = (level.f_46441_.m_188500_() - 0.5) * 4.0;
            double dy = level.f_46441_.m_188500_() * 3.0;
            double dz = (level.f_46441_.m_188500_() - 0.5) * 4.0;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.EXPLOSION_SPARK.get()), x, y, z, 1, dx, dy, dz, 1.0);
        }
        for (int ring = 0; ring < 3; ++ring) {
            double ringY = y + (double)ring * 0.5;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.SHOCKWAVE.get()), x, ringY, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < 40; ++i) {
            double offsetX = (level.f_46441_.m_188500_() - 0.5) * 4.0;
            double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 4.0;
            double ySpeed = 0.5 + level.f_46441_.m_188500_() * 0.3;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.MUSHROOM_SMOKE.get()), x + offsetX, y, z + offsetZ, 1, offsetX * 0.05, ySpeed, offsetZ * 0.05, 1.0);
        }
        for (i = 0; i < 60; ++i) {
            double angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
            double radius = 5.0 + level.f_46441_.m_188500_() * 8.0;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            double capY = y + 15.0 + level.f_46441_.m_188500_() * 5.0;
            double xSpeed = Math.cos(angle) * 0.3;
            double ySpeed = -0.1 + level.f_46441_.m_188500_() * 0.1;
            double zSpeed = Math.sin(angle) * 0.3;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.MUSHROOM_SMOKE.get()), x + offsetX, capY, z + offsetZ, 1, xSpeed, ySpeed, zSpeed, 1.0);
        }
    }

    private void playRandomDetonationSound(Level level, BlockPos pos) {
        List<SoundEvent> sounds = Arrays.asList((SoundEvent)ModSounds.MUKE_EXPLOSION.orElse(null), (SoundEvent)ModSounds.MUKE_EXPLOSION.orElse(null), (SoundEvent)ModSounds.MUKE_EXPLOSION.orElse(null));
        sounds.removeIf(Objects::isNull);
        if (!sounds.isEmpty()) {
            SoundEvent sound = sounds.get(RANDOM.nextInt(sounds.size()));
            level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, sound, SoundSource.BLOCKS, 4.0f, 1.0f);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.MINE_NUKE_BLOCK_ENTITY.get()).m_155264_(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }
}

