/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.explosives;

import com.hbm_m.block.IDetonatable;
import com.hbm_m.block.ModBlocks;
import com.hbm_m.particle.ModExplosionParticles;
import com.hbm_m.util.CraterGenerator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NuclearChargeBlock
extends Block
implements IDetonatable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"NuclearCharge");
    private static final float EXPLOSION_POWER = 25.0f;
    private static final double PARTICLE_VIEW_DISTANCE = 512.0;
    private static final int CRATER_RADIUS = 60;
    private static final int CRATER_DEPTH = 30;
    private static final int CRATER_GENERATION_DELAY = 30;

    public NuclearChargeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.nuclear_charge.line1").m_130940_(ChatFormatting.DARK_RED));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.nuclear_charge.line2").m_130940_(ChatFormatting.RED));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.nuclear_charge.line3").m_130940_(ChatFormatting.RED));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.nuclear_charge.line4").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.hbm_m.nuclear_charge.line5").m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public boolean onDetonate(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            level.m_7471_(pos, false);
            level.m_254849_(null, x, y, z, 25.0f, Level.ExplosionInteraction.NONE);
            this.scheduleExplosionEffects(serverLevel, x, y, z);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                server.m_6937_((Runnable)new TickTask(30, () -> {
                    CraterGenerator.generateCrater(serverLevel, pos, 60, 30, (Block)ModBlocks.SELLAFIELD_SLAKED.get(), (Block)ModBlocks.SELLAFIELD_SLAKED1.get(), (Block)ModBlocks.SELLAFIELD_SLAKED2.get(), (Block)ModBlocks.SELLAFIELD_SLAKED3.get(), (Block)ModBlocks.WASTE_LOG.get(), (Block)ModBlocks.WASTE_PLANKS.get(), (Block)ModBlocks.BURNED_GRASS.get());
                    LOGGER.info("\u041a\u0440\u0430\u0442\u0435\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d \u0432 \u043f\u043e\u0437\u0438\u0446\u0438\u0438: {}", (Object)pos);
                }));
            }
            return true;
        }
        return false;
    }

    private void scheduleExplosionEffects(ServerLevel level, double x, double y, double z) {
        this.spawnFlash(level, x, y, z);
        this.spawnSparks(level, x, y, z);
        if (level.m_7654_() != null) {
            level.m_7654_().m_6937_((Runnable)new TickTask(5, () -> this.spawnShockwave(level, x, y, z)));
        }
        if (level.m_7654_() != null) {
            level.m_7654_().m_6937_((Runnable)new TickTask(10, () -> this.spawnMushroomCloud(level, x, y, z)));
        }
    }

    private void spawnFlash(ServerLevel level, double x, double y, double z) {
        level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.FLASH.get()), x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private void spawnSparks(ServerLevel level, double x, double y, double z) {
        for (int i = 0; i < 200; ++i) {
            double xSpeed = (level.f_46441_.m_188500_() - 0.5) * 4.0;
            double ySpeed = level.f_46441_.m_188500_() * 3.0;
            double zSpeed = (level.f_46441_.m_188500_() - 0.5) * 4.0;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.EXPLOSION_SPARK.get()), x, y, z, 1, xSpeed, ySpeed, zSpeed, 1.0);
        }
    }

    private void spawnShockwave(ServerLevel level, double x, double y, double z) {
        for (int ring = 0; ring < 3; ++ring) {
            double ringY = y + (double)ring * 0.5;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.SHOCKWAVE.get()), x, ringY, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void spawnMushroomCloud(ServerLevel level, double x, double y, double z) {
        int i;
        for (i = 0; i < 40; ++i) {
            double offsetX = (level.f_46441_.m_188500_() - 0.5) * 4.0;
            double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 4.0;
            double ySpeed = 0.5 + level.f_46441_.m_188500_() * 0.3;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.MUSHROOM_SMOKE.get()), x + offsetX, y, z + offsetZ, 1, offsetX * 0.05, ySpeed, offsetZ * 0.05, 1.0);
        }
        for (i = 0; i < 60; ++i) {
            double angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
            double radius = 5.0 + level.f_46441_.m_188500_() * 8.0;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            double capY = y + 15.0 + level.f_46441_.m_188500_() * 5.0;
            double xSpeed = Math.cos(angle) * 0.3;
            double ySpeed = -0.1 + level.f_46441_.m_188500_() * 0.1;
            double zSpeed = Math.sin(angle) * 0.3;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.MUSHROOM_SMOKE.get()), x + offsetX, capY, z + offsetZ, 1, xSpeed, ySpeed, zSpeed, 1.0);
        }
    }
}

