/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.explosives;

import com.hbm_m.block.IDetonatable;
import com.hbm_m.block.ModBlocks;
import com.hbm_m.particle.ModExplosionParticles;
import com.hbm_m.util.ShockwaveGenerator;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SmokeBombBlock
extends Block
implements IDetonatable {
    private static final float EXPLOSION_POWER = 25.0f;
    private static final double PARTICLE_VIEW_DISTANCE = 512.0;
    private static final int CRATER_RADIUS = 25;
    private static final int CRATER_DEPTH = 8;
    private static final int DETONATION_RADIUS = 6;
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);

    public SmokeBombBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @Override
    public boolean onDetonate(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            level.m_7471_(pos, false);
            level.m_254849_(null, x, y, z, 25.0f, Level.ExplosionInteraction.NONE);
            this.triggerNearbyDetonations(serverLevel, pos, player);
            this.scheduleExplosionEffects(serverLevel, x, y, z);
            if (serverLevel.m_7654_() != null) {
                serverLevel.m_7654_().m_6937_((Runnable)new TickTask(30, () -> {
                    level.m_254849_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 8.0f, Level.ExplosionInteraction.NONE);
                    ShockwaveGenerator.generateCrater(serverLevel, pos, 25, 8, (Block)ModBlocks.WASTE_LOG.get(), (Block)ModBlocks.WASTE_PLANKS.get(), (Block)ModBlocks.BURNED_GRASS.get());
                }));
            }
            return true;
        }
        return false;
    }

    private void scheduleExplosionEffects(ServerLevel level, double x, double y, double z) {
        this.spawnFlash(level, x, y, z);
        this.spawnSparks(level, x, y, z);
        level.m_7654_().m_6937_((Runnable)new TickTask(5, () -> this.spawnShockwave(level, x, y, z)));
        level.m_7654_().m_6937_((Runnable)new TickTask(10, () -> this.spawnMushroomCloud(level, x, y, z)));
    }

    private void spawnFlash(ServerLevel level, double x, double y, double z) {
        level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.FLASH.get()), x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private void spawnSparks(ServerLevel level, double x, double y, double z) {
        for (int i = 0; i < 400; ++i) {
            double xSpeed = (level.f_46441_.m_188500_() - 0.5) * 4.0;
            double ySpeed = level.f_46441_.m_188500_() * 3.0;
            double zSpeed = (level.f_46441_.m_188500_() - 0.5) * 4.0;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.EXPLOSION_SPARK.get()), x, y, z, 1, xSpeed, ySpeed, zSpeed, 1.0);
        }
    }

    private void spawnShockwave(ServerLevel level, double x, double y, double z) {
        for (int ring = 0; ring < 3; ++ring) {
            double ringY = y + (double)ring * 0.5;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.SHOCKWAVE.get()), x, ringY, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void spawnMushroomCloud(ServerLevel level, double x, double y, double z) {
        int i;
        for (i = 0; i < 80; ++i) {
            double offsetX = (level.f_46441_.m_188500_() - 0.5) * 4.0;
            double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 4.0;
            double ySpeed = 0.5 + level.f_46441_.m_188500_() * 0.3;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.MUSHROOM_SMOKE.get()), x + offsetX, y, z + offsetZ, 1, offsetX * 0.05, ySpeed, offsetZ * 0.05, 1.0);
        }
        for (i = 0; i < 120; ++i) {
            double angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
            double radius = 5.0 + level.f_46441_.m_188500_() * 8.0;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            double capY = y + 15.0 + level.f_46441_.m_188500_() * 5.0;
            double xSpeed = Math.cos(angle) * 0.3;
            double ySpeed = -0.1 + level.f_46441_.m_188500_() * 0.1;
            double zSpeed = Math.sin(angle) * 0.3;
            level.m_8767_((ParticleOptions)((SimpleParticleType)ModExplosionParticles.MUSHROOM_SMOKE.get()), x + offsetX, capY, z + offsetZ, 1, xSpeed, ySpeed, zSpeed, 1.0);
        }
    }

    private void triggerNearbyDetonations(ServerLevel serverLevel, BlockPos pos, Player player) {
        for (int x = -6; x <= 6; ++x) {
            for (int y = -6; y <= 6; ++y) {
                for (int z = -6; z <= 6; ++z) {
                    BlockPos checkPos;
                    BlockState checkState;
                    Block block;
                    double dist = Math.sqrt(x * x + y * y + z * z);
                    if (!(dist <= 6.0) || !(dist > 0.0) || !((block = (checkState = serverLevel.m_8055_(checkPos = pos.m_7918_(x, y, z))).m_60734_()) instanceof IDetonatable)) continue;
                    IDetonatable detonatable = (IDetonatable)block;
                    int delay = (int)(dist * 2.0);
                    serverLevel.m_7654_().m_6937_((Runnable)new TickTask(delay, () -> detonatable.onDetonate((Level)serverLevel, checkPos, checkState, player)));
                }
            }
        }
    }
}

