/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.machine;

import com.google.common.collect.ImmutableMap;
import com.hbm_m.api.energy.EnergyNetworkManager;
import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.block.entity.machine.MachineAdvancedAssemblerBlockEntity;
import com.hbm_m.multiblock.IFrameSupportable;
import com.hbm_m.multiblock.IMultiblockController;
import com.hbm_m.multiblock.MultiblockStructureHelper;
import com.hbm_m.multiblock.PartRole;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.NetworkHooks;

public class MachineAdvancedAssemblerBlock
extends BaseEntityBlock
implements IMultiblockController {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private final MultiblockStructureHelper structureHelper;

    public MachineAdvancedAssemblerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.structureHelper = new MultiblockStructureHelper(MachineAdvancedAssemblerBlock.defineStructure(), () -> ((Block)ModBlocks.UNIVERSAL_MACHINE_PART.get()).m_49966_());
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        if (!pLevel.m_5776_() && !pState.m_60713_(pOldState.m_60734_())) {
            MultiblockStructureHelper helper = this.getStructureHelper();
            Direction facing = (Direction)pState.m_61143_((Property)FACING);
            helper.placeStructure(pLevel, pPos, facing, this);
            for (BlockPos localPos : helper.getStructureMap().keySet()) {
                if (this.getPartRole(localPos) != PartRole.ENERGY_CONNECTOR) continue;
                BlockPos worldPos = helper.getRotatedPos(pPos, localPos, facing);
                EnergyNetworkManager.get((ServerLevel)pLevel).addNode(worldPos);
            }
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof IFrameSupportable) {
                IFrameSupportable be = (IFrameSupportable)blockEntity;
                be.checkForFrame();
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_()) && !level.m_5776_()) {
            MultiblockStructureHelper helper = this.getStructureHelper();
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            for (BlockPos localPos : helper.getStructureMap().keySet()) {
                if (this.getPartRole(localPos) != PartRole.ENERGY_CONNECTOR) continue;
                BlockPos worldPos = helper.getRotatedPos(pos, localPos, facing);
                EnergyNetworkManager.get((ServerLevel)level).removeNode(worldPos);
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof MachineAdvancedAssemblerBlockEntity) {
                blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)handler.getStackInSlot(i));
                    }
                });
            }
            helper.destroyStructure(level, pos, facing);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new MachineAdvancedAssemblerBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pType) {
        return MachineAdvancedAssemblerBlock.m_152132_(pType, (BlockEntityType)((BlockEntityType)ModBlockEntities.ADVANCED_ASSEMBLY_MACHINE_BE.get()), MachineAdvancedAssemblerBlockEntity::tick);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity;
        if (!pLevel.m_5776_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)blockEntity;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)provider, (BlockPos)pPos);
        }
        return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
    }

    @Override
    public MultiblockStructureHelper getStructureHelper() {
        return this.structureHelper;
    }

    private static Map<BlockPos, Supplier<BlockState>> defineStructure() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int y = 0; y <= 2; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    builder.put((Object)new BlockPos(x, y, z), () -> ((Block)ModBlocks.UNIVERSAL_MACHINE_PART.get()).m_49966_());
                }
            }
        }
        return builder.build();
    }

    @Override
    public PartRole getPartRole(BlockPos localOffset) {
        return localOffset.m_123342_() == 0 ? PartRole.ENERGY_CONNECTOR : PartRole.DEFAULT;
    }
}

