/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.machine;

import com.hbm_m.api.energy.EnergyNetworkManager;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.block.entity.machine.MachineBatteryBlockEntity;
import com.hbm_m.util.EnergyFormatter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class MachineBatteryBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final long capacity;

    public MachineBatteryBlock(BlockBehaviour.Properties properties, long capacity) {
        super(properties);
        this.capacity = capacity;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public long getCapacity() {
        return this.capacity;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MachineBatteryBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return MachineBatteryBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.MACHINE_BATTERY_BE.get()), MachineBatteryBlockEntity::tick);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_()) && !level.m_5776_()) {
            EnergyNetworkManager.get((ServerLevel)level).removeNode(pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            BlockEntity entity = level.m_7702_(pos);
            if (entity instanceof MachineBatteryBlockEntity) {
                MachineBatteryBlockEntity battery = (MachineBatteryBlockEntity)entity;
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)battery, (BlockPos)pos);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        BlockEntity be;
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (!pLevel.f_46443_ && (be = pLevel.m_7702_(pPos)) instanceof MachineBatteryBlockEntity) {
            MachineBatteryBlockEntity batteryBE = (MachineBatteryBlockEntity)be;
            CompoundTag itemNbt = pStack.m_41783_();
            if (itemNbt != null && itemNbt.m_128441_("BlockEntityTag")) {
                batteryBE.m_142466_(itemNbt.m_128469_("BlockEntityTag"));
                batteryBE.m_6596_();
            }
        }
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
        long energy = 0L;
        CompoundTag nbt = pStack.m_41783_();
        if (nbt != null && nbt.m_128441_("BlockEntityTag")) {
            energy = nbt.m_128469_("BlockEntityTag").m_128454_("Energy");
        }
        String energyStr = EnergyFormatter.format(energy);
        String maxEnergyStr = EnergyFormatter.format(this.capacity);
        pTooltip.add((Component)Component.m_237110_((String)"tooltip.hbm_m.machine_battery.stored", (Object[])new Object[]{energyStr, maxEnergyStr}).m_130940_(ChatFormatting.YELLOW));
    }
}

