/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.block.machine;

import com.google.common.collect.ImmutableMap;
import com.hbm_m.api.energy.EnergyNetworkManager;
import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.block.entity.machine.MachineWoodBurnerBlockEntity;
import com.hbm_m.multiblock.IMultiblockController;
import com.hbm_m.multiblock.MultiblockStructureHelper;
import com.hbm_m.multiblock.PartRole;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.NetworkHooks;

public class MachineWoodBurnerBlock
extends BaseEntityBlock
implements IMultiblockController {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    private static MultiblockStructureHelper STRUCTURE_HELPER;

    public MachineWoodBurnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, LIT});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!state.m_60713_(oldState.m_60734_()) && !level.m_5776_()) {
            MultiblockStructureHelper helper = this.getStructureHelper();
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            helper.placeStructure(level, pos, facing, this);
            EnergyNetworkManager.get((ServerLevel)level).addNode(pos);
            for (BlockPos localPos : helper.getStructureMap().keySet()) {
                if (this.getPartRole(localPos) != PartRole.ENERGY_CONNECTOR) continue;
                BlockPos worldPos = helper.getRotatedPos(pos, localPos, facing);
                EnergyNetworkManager.get((ServerLevel)level).addNode(worldPos);
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_() && !level.m_5776_()) {
            MultiblockStructureHelper helper = this.getStructureHelper();
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            EnergyNetworkManager.get((ServerLevel)level).removeNode(pos);
            for (BlockPos localPos : helper.getStructureMap().keySet()) {
                if (this.getPartRole(localPos) != PartRole.ENERGY_CONNECTOR) continue;
                BlockPos worldPos = helper.getRotatedPos(pos, localPos, facing);
                EnergyNetworkManager.get((ServerLevel)level).removeNode(worldPos);
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof MachineWoodBurnerBlockEntity) {
                blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)handler.getStackInSlot(i));
                    }
                });
            }
            helper.destroyStructure(level, pos, facing);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MachineWoodBurnerBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)blockEntity;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)provider, (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return MachineWoodBurnerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.WOOD_BURNER_BE.get()), MachineWoodBurnerBlockEntity::tick);
    }

    @Override
    public MultiblockStructureHelper getStructureHelper() {
        if (STRUCTURE_HELPER == null) {
            STRUCTURE_HELPER = new MultiblockStructureHelper(MachineWoodBurnerBlock.defineStructure(), () -> ((Block)ModBlocks.UNIVERSAL_MACHINE_PART.get()).m_49966_());
        }
        return STRUCTURE_HELPER;
    }

    private static Map<BlockPos, Supplier<BlockState>> defineStructure() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int y = 0; y <= 1; ++y) {
            for (int x = 0; x <= 1; ++x) {
                for (int z = 0; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    builder.put((Object)new BlockPos(x, y, z), () -> ((Block)ModBlocks.UNIVERSAL_MACHINE_PART.get()).m_49966_());
                }
            }
        }
        return builder.build();
    }

    @Override
    public PartRole getPartRole(BlockPos localOffset) {
        return localOffset.m_123342_() == 0 && localOffset.m_123343_() == 1 && (localOffset.m_123341_() == 0 || localOffset.m_123341_() == 1) ? PartRole.ENERGY_CONNECTOR : PartRole.DEFAULT;
    }
}

