/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.capability;

import com.hbm_m.capability.ChunkRadiation;
import com.hbm_m.capability.IChunkRadiation;
import com.hbm_m.config.ModClothConfig;
import com.hbm_m.main.MainRegistry;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkRadiationProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final Capability<IChunkRadiation> CHUNK_RADIATION_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IChunkRadiation>(){});
    private static final String NBT_KEY_BLOCK = "blockRadiation";
    private static final String NBT_KEY_AMBIENT = "ambientRadiation";
    private IChunkRadiation chunkRadiation = null;
    private final LazyOptional<IChunkRadiation> optional = LazyOptional.of(this::getOrCreate);

    private IChunkRadiation getOrCreate() {
        if (this.chunkRadiation == null) {
            this.chunkRadiation = new ChunkRadiation();
        }
        return this.chunkRadiation;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CHUNK_RADIATION_CAPABILITY) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        IChunkRadiation radiation = this.getOrCreate();
        if (radiation.getBlockRadiation() > 1.0E-6f || radiation.getAmbientRadiation() > 1.0E-6f) {
            CompoundTag tag = new CompoundTag();
            if (radiation.getBlockRadiation() > 1.0E-6f) {
                tag.m_128350_(NBT_KEY_BLOCK, radiation.getBlockRadiation());
            }
            if (radiation.getAmbientRadiation() > 1.0E-6f) {
                tag.m_128350_(NBT_KEY_AMBIENT, radiation.getAmbientRadiation());
            }
            if (ModClothConfig.get().enableDebugLogging) {
                MainRegistry.LOGGER.debug("Serializing ChunkRadiation: {}", (Object)tag);
            }
            return tag;
        }
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
        IChunkRadiation radiation = this.getOrCreate();
        if (nbt.m_128425_(NBT_KEY_BLOCK, 5)) {
            radiation.setBlockRadiation(nbt.m_128457_(NBT_KEY_BLOCK));
        } else {
            radiation.setBlockRadiation(0.0f);
        }
        if (nbt.m_128425_(NBT_KEY_AMBIENT, 5)) {
            radiation.setAmbientRadiation(nbt.m_128457_(NBT_KEY_AMBIENT));
        } else {
            radiation.setAmbientRadiation(0.0f);
        }
        if (ModClothConfig.get().enableDebugLogging && nbt.m_128440_() > 0) {
            MainRegistry.LOGGER.debug("Deserialized ChunkRadiation: block={}, ambient={}", (Object)Float.valueOf(radiation.getBlockRadiation()), (Object)Float.valueOf(radiation.getAmbientRadiation()));
        }
    }
}

