/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientRadiationData {
    private static final Map<ResourceLocation, Map<ChunkPos, Float>> radiationByDimension = new ConcurrentHashMap<ResourceLocation, Map<ChunkPos, Float>>();

    public static void clearAll() {
        radiationByDimension.clear();
    }

    public static void updateRadiationData(ResourceLocation dimension, Map<ChunkPos, Float> newData) {
        Map radiationLevels = radiationByDimension.computeIfAbsent(dimension, k -> new ConcurrentHashMap());
        for (Map.Entry<ChunkPos, Float> entry : newData.entrySet()) {
            if (entry.getValue().floatValue() < 1.0E-6f) {
                radiationLevels.remove(entry.getKey());
                continue;
            }
            radiationLevels.put(entry.getKey(), entry.getValue());
        }
    }

    public static float getRadiationForChunk(ResourceLocation dimension, ChunkPos pos) {
        Map<ChunkPos, Float> radiationLevels = radiationByDimension.get(dimension);
        if (radiationLevels == null) {
            return 0.0f;
        }
        return radiationLevels.getOrDefault(pos, Float.valueOf(0.0f)).floatValue();
    }
}

