/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client;

import com.hbm_m.config.ModClothConfig;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;

public class ClientRenderHandler {
    private static final Map<BlockPos, Long> highlightedBlocks = new HashMap<BlockPos, Long>();

    public static void highlightBlocks(List<BlockPos> positions) {
        long duration = (long)ModClothConfig.get().obstructionHighlightDuration * 1000L;
        long expiryTime = System.currentTimeMillis() + duration;
        highlightedBlocks.clear();
        for (BlockPos pos : positions) {
            highlightedBlocks.put(pos, expiryTime);
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES || highlightedBlocks.isEmpty()) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Minecraft mc = Minecraft.m_91087_();
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        long currentTime = System.currentTimeMillis();
        VertexConsumer fillConsumer = mc.m_91269_().m_110104_().m_6299_(CustomRenderTypes.HIGHLIGHT_BOX_FILL);
        Color color = Color.RED;
        float alpha = (float)ModClothConfig.get().obstructionHighlightAlpha / 100.0f;
        if (alpha <= 0.0f) {
            highlightedBlocks.clear();
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        highlightedBlocks.entrySet().removeIf(entry -> {
            BlockPos pos = (BlockPos)entry.getKey();
            if (currentTime > (Long)entry.getValue()) {
                return true;
            }
            boolean drawDown = !highlightedBlocks.containsKey(pos.m_7495_());
            boolean drawUp = !highlightedBlocks.containsKey(pos.m_7494_());
            boolean drawNorth = !highlightedBlocks.containsKey(pos.m_122012_());
            boolean drawSouth = !highlightedBlocks.containsKey(pos.m_122019_());
            boolean drawWest = !highlightedBlocks.containsKey(pos.m_122024_());
            boolean drawEast = !highlightedBlocks.containsKey(pos.m_122029_());
            AABB boundingBox = new AABB(pos).m_82400_(0.002);
            ClientRenderHandler.renderFilledBox(poseStack, fillConsumer, boundingBox, color, alpha, drawDown, drawUp, drawNorth, drawSouth, drawWest, drawEast);
            return false;
        });
        poseStack.m_85849_();
        mc.m_91269_().m_110104_().m_109912_(CustomRenderTypes.HIGHLIGHT_BOX_FILL);
    }

    private static void renderFilledBox(PoseStack poseStack, VertexConsumer consumer, AABB box, Color color, float alpha, boolean drawDown, boolean drawUp, boolean drawNorth, boolean drawSouth, boolean drawWest, boolean drawEast) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float minX = (float)box.f_82288_;
        float minY = (float)box.f_82289_;
        float minZ = (float)box.f_82290_;
        float maxX = (float)box.f_82291_;
        float maxY = (float)box.f_82292_;
        float maxZ = (float)box.f_82293_;
        if (drawDown) {
            consumer.m_252986_(matrix, minX, minY, minZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, maxX, minY, minZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, maxX, minY, maxZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, minX, minY, maxZ).m_85950_(r, g, b, alpha).m_5752_();
        }
        if (drawUp) {
            consumer.m_252986_(matrix, minX, maxY, maxZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, maxX, maxY, minZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, minX, maxY, minZ).m_85950_(r, g, b, alpha).m_5752_();
        }
        if (drawNorth) {
            consumer.m_252986_(matrix, minX, minY, minZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, minX, maxY, minZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, maxX, maxY, minZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, maxX, minY, minZ).m_85950_(r, g, b, alpha).m_5752_();
        }
        if (drawSouth) {
            consumer.m_252986_(matrix, maxX, minY, maxZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, minX, maxY, maxZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, minX, minY, maxZ).m_85950_(r, g, b, alpha).m_5752_();
        }
        if (drawWest) {
            consumer.m_252986_(matrix, minX, minY, maxZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, minX, maxY, maxZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, minX, maxY, minZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, minX, minY, minZ).m_85950_(r, g, b, alpha).m_5752_();
        }
        if (drawEast) {
            consumer.m_252986_(matrix, maxX, minY, minZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, maxX, maxY, minZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, maxX, maxY, maxZ).m_85950_(r, g, b, alpha).m_5752_();
            consumer.m_252986_(matrix, maxX, minY, maxZ).m_85950_(r, g, b, alpha).m_5752_();
        }
    }

    private static class CustomRenderTypes
    extends RenderType {
        public static final RenderType HIGHLIGHT_BOX_FILL = CustomRenderTypes.m_173215_((String)"highlight_box_fill", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173104_).m_110685_(f_110139_).m_110663_(f_110111_).m_110661_(f_110110_).m_110671_(f_110153_).m_110687_(f_110115_).m_110691_(false));

        private CustomRenderTypes(String s, VertexFormat v, VertexFormat.Mode m, int i, boolean b, boolean b2, Runnable r, Runnable r2) {
            super(s, v, m, i, b, b2, r, r2);
        }
    }
}

