/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client;

import com.google.common.collect.ImmutableMap;
import com.hbm_m.block.ModBlocks;
import com.hbm_m.block.entity.DoorDeclRegistry;
import com.hbm_m.block.entity.ModBlockEntities;
import com.hbm_m.client.ChunkRadiationDebugRenderer;
import com.hbm_m.client.ClientRenderHandler;
import com.hbm_m.client.DarkParticleHandler;
import com.hbm_m.client.DoorOutlineRenderer;
import com.hbm_m.client.loader.DoorModelLoader;
import com.hbm_m.client.loader.MachineAdvancedAssemblerModelLoader;
import com.hbm_m.client.loader.PressModelLoader;
import com.hbm_m.client.loader.ProceduralWireLoader;
import com.hbm_m.client.loader.TemplateModelLoader;
import com.hbm_m.client.overlay.GUIAnvil;
import com.hbm_m.client.overlay.GUIArmorTable;
import com.hbm_m.client.overlay.GUIBlastFurnace;
import com.hbm_m.client.overlay.GUIMachineAdvancedAssembler;
import com.hbm_m.client.overlay.GUIMachineAssembler;
import com.hbm_m.client.overlay.GUIMachineBattery;
import com.hbm_m.client.overlay.GUIMachinePress;
import com.hbm_m.client.overlay.GUIMachineShredder;
import com.hbm_m.client.overlay.GUIMachineWoodBurner;
import com.hbm_m.client.overlay.OverlayGeiger;
import com.hbm_m.client.overlay.OverlayRadiationVisuals;
import com.hbm_m.client.overlay.crates.GUIDeshCrate;
import com.hbm_m.client.overlay.crates.GUIIronCrate;
import com.hbm_m.client.overlay.crates.GUISteelCrate;
import com.hbm_m.client.render.DoorRenderer;
import com.hbm_m.client.render.GlobalMeshCache;
import com.hbm_m.client.render.MachineAdvancedAssemblerRenderer;
import com.hbm_m.client.render.MachineAdvancedAssemblerVboRenderer;
import com.hbm_m.client.render.MachinePressRenderer;
import com.hbm_m.client.render.ModShaders;
import com.hbm_m.client.render.OcclusionCullingHelper;
import com.hbm_m.client.render.shader.ImmediateFallbackRenderer;
import com.hbm_m.client.render.shader.RenderPathManager;
import com.hbm_m.client.render.shader.ShaderReloadListener;
import com.hbm_m.client.tooltip.ItemTooltipComponent;
import com.hbm_m.client.tooltip.ItemTooltipComponentRenderer;
import com.hbm_m.config.ModClothConfig;
import com.hbm_m.config.ModConfigKeybindHandler;
import com.hbm_m.entity.ModEntities;
import com.hbm_m.item.ItemAssemblyTemplate;
import com.hbm_m.item.ModItems;
import com.hbm_m.item.ModTags;
import com.hbm_m.item.tools.ItemBlueprintFolder;
import com.hbm_m.main.MainRegistry;
import com.hbm_m.menu.ModMenuTypes;
import com.hbm_m.multiblock.DoorPartAABBRegistry;
import com.hbm_m.particle.ModExplosionParticles;
import com.hbm_m.particle.ModParticleTypes;
import com.hbm_m.particle.custom.DarkParticle;
import com.hbm_m.particle.custom.ExplosionWaveParticle;
import com.hbm_m.particle.custom.RadFogParticle;
import com.hbm_m.particle.explosions.ExplosionSparkParticle;
import com.hbm_m.particle.explosions.FlashParticle;
import com.hbm_m.particle.explosions.MushroomSmokeParticle;
import com.hbm_m.particle.explosions.ShockwaveParticle;
import com.hbm_m.recipe.AssemblerRecipe;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="hbm_m", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetup {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        MainRegistry.LOGGER.info("FMLClientSetupEvent fired. Registering client-side FORGE event handlers.");
        MinecraftForge.EVENT_BUS.register(ModConfigKeybindHandler.class);
        MinecraftForge.EVENT_BUS.register(DarkParticleHandler.class);
        MinecraftForge.EVENT_BUS.register(ChunkRadiationDebugRenderer.class);
        MinecraftForge.EVENT_BUS.register(ClientRenderHandler.class);
        MinecraftForge.EVENT_BUS.register(DoorOutlineRenderer.class);
        ModEntities.GRENADE_NUC_PROJECTILE.ifPresent(entityType -> EntityRenderers.m_174036_((EntityType)entityType, ThrownItemRenderer::new));
        ModEntities.GRENADE_IF_FIRE_PROJECTILE.ifPresent(entityType -> EntityRenderers.m_174036_((EntityType)entityType, ThrownItemRenderer::new));
        ModEntities.GRENADE_IF_SLIME_PROJECTILE.ifPresent(entityType -> EntityRenderers.m_174036_((EntityType)entityType, ThrownItemRenderer::new));
        ModEntities.GRENADE_IF_HE_PROJECTILE.ifPresent(entityType -> EntityRenderers.m_174036_((EntityType)entityType, ThrownItemRenderer::new));
        ModEntities.GRENADE_PROJECTILE.ifPresent(entityType -> EntityRenderers.m_174036_((EntityType)entityType, ThrownItemRenderer::new));
        ModEntities.GRENADEHE_PROJECTILE.ifPresent(entityType -> EntityRenderers.m_174036_((EntityType)entityType, ThrownItemRenderer::new));
        ModEntities.GRENADEFIRE_PROJECTILE.ifPresent(entityType -> EntityRenderers.m_174036_((EntityType)entityType, ThrownItemRenderer::new));
        ModEntities.GRENADESMART_PROJECTILE.ifPresent(entityType -> EntityRenderers.m_174036_((EntityType)entityType, ThrownItemRenderer::new));
        ModEntities.GRENADESLIME_PROJECTILE.ifPresent(entityType -> EntityRenderers.m_174036_((EntityType)entityType, ThrownItemRenderer::new));
        ModEntities.GRENADE_IF_PROJECTILE.ifPresent(entityType -> EntityRenderers.m_174036_((EntityType)entityType, ThrownItemRenderer::new));
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.ARMOR_TABLE_MENU.get()), GUIArmorTable::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.MACHINE_ASSEMBLER_MENU.get()), GUIMachineAssembler::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.ADVANCED_ASSEMBLY_MACHINE_MENU.get()), GUIMachineAdvancedAssembler::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.MACHINE_BATTERY_MENU.get()), GUIMachineBattery::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.BLAST_FURNACE_MENU.get()), GUIBlastFurnace::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.PRESS_MENU.get()), GUIMachinePress::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.SHREDDER_MENU.get()), GUIMachineShredder::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.WOOD_BURNER_MENU.get()), GUIMachineWoodBurner::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.ANVIL_MENU.get()), GUIAnvil::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.IRON_CRATE_MENU.get()), GUIIronCrate::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.STEEL_CRATE_MENU.get()), GUISteelCrate::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.DESH_CRATE_MENU.get()), GUIDeshCrate::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.ADVANCED_ASSEMBLY_MACHINE_BE.get()), MachineAdvancedAssemblerRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.DOOR_ENTITY.get()), DoorRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.PRESS_BE.get()), MachinePressRenderer::new);
            OcclusionCullingHelper.setTransparentBlocksTag(ModTags.Blocks.NON_OCCLUDING);
            try {
                RenderPathManager.updateRenderPath();
                MainRegistry.LOGGER.info("VBO render system initialized successfully");
            }
            catch (Exception e) {
                MainRegistry.LOGGER.error("Failed to initialize VBO render system", (Throwable)e);
            }
            MinecraftForge.EVENT_BUS.addListener(ClientSetup::onClientDisconnect);
            MainRegistry.LOGGER.info("Initial render path check completed");
        });
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticleTypes.EXPLOSION_WAVE.get(), ExplosionWaveParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModExplosionParticles.FLASH.get(), FlashParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModExplosionParticles.SHOCKWAVE.get(), ShockwaveParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModExplosionParticles.MUSHROOM_SMOKE.get(), MushroomSmokeParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModExplosionParticles.EXPLOSION_SPARK.get(), ExplosionSparkParticle.Provider::new);
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        ModelResourceLocation leavesLocation;
        Map modelRegistry = event.getModels();
        BakedModel originalModel = (BakedModel)modelRegistry.get(leavesLocation = new ModelResourceLocation(ModBlocks.WASTE_LEAVES.getId(), ""));
        if (originalModel != null) {
            LeavesModelWrapper wrappedModel = new LeavesModelWrapper(originalModel);
            event.getModels().put(leavesLocation, wrappedModel);
            if (ModClothConfig.get().enableDebugLogging) {
                MainRegistry.LOGGER.debug("Successfully wrapped waste_leaves model for dynamic render types.");
            }
        } else if (ModClothConfig.get().enableDebugLogging) {
            MainRegistry.LOGGER.warn("Could not find model for waste_leaves to wrap.");
        }
    }

    @SubscribeEvent
    public static void onModelRegister(ModelEvent.RegisterGeometryLoaders event) {
        DoorDeclRegistry.init();
        MainRegistry.LOGGER.info("DoorDeclRegistry initialized with {} doors", (Object)DoorDeclRegistry.getAll().size());
        event.register("procedural_wire", (IGeometryLoader)new ProceduralWireLoader());
        event.register("advanced_assembly_machine_loader", (IGeometryLoader)new MachineAdvancedAssemblerModelLoader());
        event.register("door", (IGeometryLoader)new DoorModelLoader());
        event.register("template_loader", (IGeometryLoader)new TemplateModelLoader());
        event.register("press_loader", (IGeometryLoader)new PressModelLoader());
        MainRegistry.LOGGER.info("Registered geometry loaders: procedural_wire, advanced_assembly_machine_loader, template_loader, door, press_loader");
    }

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        ModConfigKeybindHandler.onRegisterKeyMappings(event);
        MainRegistry.LOGGER.info("Registered key mappings.");
    }

    @SubscribeEvent
    public static void onResourceReload(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new ShaderReloadListener());
        event.registerReloadListener((preparationBarrier, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> preparationBarrier.m_6769_(null).thenRunAsync(() -> {
            MachineAdvancedAssemblerVboRenderer.clearGlobalCache();
            ImmediateFallbackRenderer.clearGlobalCache();
            DoorRenderer.clearAllCaches();
            MachinePressRenderer.clearCaches();
            GlobalMeshCache.clearAll();
            DoorPartAABBRegistry.clear();
            ImmediateFallbackRenderer.onShaderReload();
            RenderPathManager.updateRenderPath();
            MainRegistry.LOGGER.info("VBO cache cleanup completed, render path preserved");
        }, gameExecutor));
    }

    public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        MainRegistry.LOGGER.info("Client disconnecting, clearing VBO caches...");
        DoorRenderer.clearAllCaches();
        MachineAdvancedAssemblerVboRenderer.clearGlobalCache();
        MachinePressRenderer.clearCaches();
        ImmediateFallbackRenderer.forceReset();
    }

    @SubscribeEvent
    public static void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticleTypes.DARK_PARTICLE.get(), DarkParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticleTypes.RAD_FOG_PARTICLE.get(), RadFogParticle.Provider::new);
        MainRegistry.LOGGER.info("Registered custom particle providers.");
    }

    @SubscribeEvent
    public static void onRegisterGuiOverlays(RegisterGuiOverlaysEvent event) {
        MainRegistry.LOGGER.info("Registering GUI overlays...");
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "geiger_counter_hud", OverlayGeiger.GEIGER_HUD_OVERLAY);
        event.registerAbove(VanillaGuiOverlay.PORTAL.id(), "radiation_pixels", OverlayRadiationVisuals.RADIATION_PIXELS_OVERLAY);
        MainRegistry.LOGGER.info("GUI overlays registered.");
    }

    @SubscribeEvent
    public static void registerTooltipFactories(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(ItemTooltipComponent.class, ItemTooltipComponentRenderer::new);
    }

    @SubscribeEvent
    public static void onRegisterShaders(RegisterShadersEvent event) throws IOException {
        MainRegistry.LOGGER.info("Registering custom shaders...");
        VertexFormat blockLitFormat = new VertexFormat(ImmutableMap.builder().put((Object)"Position", (Object)DefaultVertexFormat.f_85804_).put((Object)"Normal", (Object)DefaultVertexFormat.f_85809_).put((Object)"UV0", (Object)DefaultVertexFormat.f_85806_).put((Object)"InstMatRow0", (Object)DefaultVertexFormat.f_85809_).put((Object)"InstMatRow1", (Object)DefaultVertexFormat.f_85809_).put((Object)"InstMatRow2", (Object)DefaultVertexFormat.f_85809_).put((Object)"InstMatRow3", (Object)DefaultVertexFormat.f_85809_).put((Object)"InstLight", (Object)DefaultVertexFormat.f_85808_).build());
        event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"hbm_m", (String)"block_lit"), blockLitFormat), ModShaders::setBlockLitShader);
        MainRegistry.LOGGER.info("Successfully registered block_lit shader");
    }

    public static void addTemplatesClient(BuildCreativeModeTabContentsEvent event) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
            List recipes = recipeManager.m_44013_((RecipeType)AssemblerRecipe.Type.INSTANCE);
            HashSet<String> blueprintPools = new HashSet<String>();
            for (AssemblerRecipe recipe : recipes) {
                String pool = recipe.getBlueprintPool();
                if (pool == null || pool.isEmpty()) continue;
                blueprintPools.add(pool);
            }
            for (String pool : blueprintPools) {
                ItemStack folderStack = new ItemStack((ItemLike)ModItems.BLUEPRINT_FOLDER.get());
                ItemBlueprintFolder.writeBlueprintPool(folderStack, pool);
                event.m_246342_(folderStack);
            }
            if (ModClothConfig.get().enableDebugLogging) {
                MainRegistry.LOGGER.info("Added {} blueprint folders to NTM Templates tab", (Object)blueprintPools.size());
            }
            for (AssemblerRecipe recipe : recipes) {
                ItemStack templateStack = new ItemStack((ItemLike)ModItems.ASSEMBLY_TEMPLATE.get());
                ItemAssemblyTemplate.writeRecipeOutput(templateStack, recipe.m_8043_(null));
                event.m_246342_(templateStack);
            }
            if (ModClothConfig.get().enableDebugLogging) {
                MainRegistry.LOGGER.info("Added {} templates to NTM Templates tab", (Object)recipes.size());
            }
        } else if (ModClothConfig.get().enableDebugLogging) {
            MainRegistry.LOGGER.warn("Could not populate templates tab: Minecraft level is null.");
        }
    }

    private static class LeavesModelWrapper
    extends BakedModelWrapper<BakedModel> {
        public LeavesModelWrapper(BakedModel originalModel) {
            super(originalModel);
        }

        public ChunkRenderTypeSet getRenderTypes(@Nonnull BlockState state, @Nonnull RandomSource rand, @Nonnull ModelData data) {
            GraphicsStatus graphics = (GraphicsStatus)Minecraft.m_91087_().f_91066_.m_232060_().m_231551_();
            if (graphics == GraphicsStatus.FANCY || graphics == GraphicsStatus.FABULOUS) {
                return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110457_()});
            }
            return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110451_()});
        }
    }
}

