/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientSoundManager {
    private static final Map<BlockPos, AbstractTickableSoundInstance> ACTIVE_SOUNDS = new ConcurrentHashMap<BlockPos, AbstractTickableSoundInstance>();

    public static void updateSound(BlockEntity be, boolean shouldBePlaying, Supplier<? extends AbstractTickableSoundInstance> soundSupplier) {
        BlockPos pos = be.m_58899_();
        if (shouldBePlaying) {
            ACTIVE_SOUNDS.computeIfAbsent(pos, key -> {
                AbstractTickableSoundInstance newSound = (AbstractTickableSoundInstance)soundSupplier.get();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)newSound);
                return newSound;
            });
        } else {
            AbstractTickableSoundInstance existingSound = ACTIVE_SOUNDS.remove(pos);
            if (existingSound != null) {
                Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)existingSound);
            }
        }
    }

    public static void updateDoorSound(BlockPos pos, boolean isMoving, Supplier<AbstractTickableSoundInstance> loopSoundSupplier) {
        if (isMoving) {
            ACTIVE_SOUNDS.computeIfAbsent(pos, key -> {
                AbstractTickableSoundInstance newSound = (AbstractTickableSoundInstance)loopSoundSupplier.get();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)newSound);
                return newSound;
            });
        } else {
            ClientSoundManager.stopSound(pos);
        }
    }

    public static void playOneShotSound(BlockPos pos, SoundEvent sound, float volume) {
        if (sound == null) {
            return;
        }
        SimpleSoundInstance soundInstance = new SimpleSoundInstance(sound, SoundSource.BLOCKS, volume, 1.0f, RandomSource.m_216327_(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)soundInstance);
    }

    public static void stopSound(BlockPos pos) {
        AbstractTickableSoundInstance existingSound = ACTIVE_SOUNDS.remove(pos);
        if (existingSound != null) {
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)existingSound);
        }
    }

    public static void clearAll() {
        ACTIVE_SOUNDS.values().forEach(sound -> Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)sound));
        ACTIVE_SOUNDS.clear();
    }
}

