/*
 * Decompiled with CFR 0.152.
 */
package com.hbm_m.client;

import com.hbm_m.block.DoorBlock;
import com.hbm_m.block.machine.UniversalMachinePartBlock;
import com.hbm_m.multiblock.IMultiblockPart;
import com.hbm_m.multiblock.MultiblockStructureHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class DoorOutlineRenderer {
    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        HitResult hitResult = mc.f_91077_;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)hitResult;
        BlockPos pos = blockHit.m_82425_();
        BlockState state = mc.f_91073_.m_8055_(pos);
        if (!(state.m_60734_() instanceof UniversalMachinePartBlock)) {
            return;
        }
        BlockEntity blockEntity = mc.f_91073_.m_7702_(pos);
        if (!(blockEntity instanceof IMultiblockPart)) {
            return;
        }
        IMultiblockPart part = (IMultiblockPart)blockEntity;
        BlockPos controllerPos = part.getControllerPos();
        if (controllerPos == null) {
            return;
        }
        BlockState controllerState = mc.f_91073_.m_8055_(controllerPos);
        Block block = controllerState.m_60734_();
        if (!(block instanceof DoorBlock)) {
            return;
        }
        DoorBlock doorBlock = (DoorBlock)block;
        String doorId = doorBlock.getDoorDeclId();
        Direction facing = (Direction)controllerState.m_61143_((Property)DoorBlock.FACING);
        Map<String, AABB> partAABBs = MultiblockStructureHelper.getDoorPartAABBs(doorId);
        if (partAABBs.isEmpty()) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 camPos = camera.m_90583_();
        VertexConsumer consumer = mc.m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
        poseStack.m_85836_();
        poseStack.m_85837_(-camPos.f_82479_, -camPos.f_82480_, -camPos.f_82481_);
        for (Map.Entry<String, AABB> entry : partAABBs.entrySet()) {
            AABB aabb = entry.getValue();
            AABB rotated = MultiblockStructureHelper.rotateAABBByFacing(aabb, facing);
            AABB worldAABB = rotated.m_82386_((double)controllerPos.m_123341_(), (double)controllerPos.m_123342_(), (double)controllerPos.m_123343_());
            LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)worldAABB, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        }
        poseStack.m_85849_();
    }
}

